/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class MapType
extends Type {
    private Class keyClass;
    private Class valueClass;
    private QName keyName;
    private QName valueName;
    private QName entryName;
    static /* synthetic */ Class class$java$util$Map;

    public MapType(QName schemaType, Class keyClass, Class valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.setSchemaType(schemaType);
        this.setKeyName(new QName(schemaType.getNamespaceURI(), "key"));
        this.setValueName(new QName(schemaType.getNamespaceURI(), "value"));
        this.setEntryName(new QName(schemaType.getNamespaceURI(), "entry"));
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        Map map = this.instantiateMap();
        try {
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            Object key = null;
            Object value = null;
            while (reader.hasMoreElementReaders()) {
                MessageReader entryReader = reader.getNextElementReader();
                if (entryReader.getName().equals(this.getEntryName())) {
                    while (entryReader.hasMoreElementReaders()) {
                        MessageReader evReader = entryReader.getNextElementReader();
                        if (evReader.getName().equals(this.getKeyName())) {
                            key = keyType.readObject(evReader, context);
                            continue;
                        }
                        if (evReader.getName().equals(this.getValueName())) {
                            value = valueType.readObject(evReader, context);
                            continue;
                        }
                        this.readToEnd(evReader);
                    }
                    map.put(key, value);
                    continue;
                }
                this.readToEnd(entryReader);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected Map instantiateMap() {
        Map map = null;
        if (this.getTypeClass().equals(class$java$util$Map == null ? (class$java$util$Map = MapType.class$("java.util.Map")) : class$java$util$Map) || this.getTypeClass().isInterface()) {
            map = new HashMap();
        } else {
            try {
                map = (Map)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not create map implementation: " + this.getTypeClass().getName(), (Throwable)e);
            }
        }
        return map;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            Map map = (Map)object;
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            if (keyType == null) {
                throw new XFireRuntimeException("Couldn't find type for key class " + keyType.getTypeClass() + ".");
            }
            if (valueType == null) {
                throw new XFireRuntimeException("Couldn't find type for value class " + keyType.getTypeClass() + ".");
            }
            Iterator itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                MessageWriter entryWriter = writer.getElementWriter(this.getEntryName());
                MessageWriter keyWriter = entryWriter.getElementWriter(this.getKeyName());
                keyType.writeObject(entry.getKey(), keyWriter, context);
                keyWriter.close();
                MessageWriter valueWriter = entryWriter.getElementWriter(this.getValueName());
                valueType.writeObject(entry.getValue(), valueWriter, context);
                valueWriter.close();
                entryWriter.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public void writeSchema(Element root) {
        String ctPref = "xsd:complexType";
        String seqPref = "xsd:sequence";
        Element complex = new Element(ctPref, "http://www.w3.org/2001/XMLSchema");
        complex.addAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.appendChild((Node)complex);
        Element seq = new Element(seqPref, "http://www.w3.org/2001/XMLSchema");
        complex.appendChild((Node)seq);
        Type keyType = this.getKeyType();
        Type valueType = this.getValueType();
        String prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)this.getSchemaType().getNamespaceURI());
        String keyTypeName = prefix + ":" + keyType.getSchemaType().getLocalPart();
        String valueTypeName = prefix + ":" + valueType.getSchemaType().getLocalPart();
        Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
        seq.appendChild((Node)element);
        element.addAttribute(new Attribute("name", this.getEntryName().getLocalPart()));
        element.addAttribute(new Attribute("minOccurs", "0"));
        element.addAttribute(new Attribute("maxOccurs", "unbounded"));
        Element evComplex = new Element(ctPref, "http://www.w3.org/2001/XMLSchema");
        element.appendChild((Node)evComplex);
        Element evseq = new Element(seqPref, "http://www.w3.org/2001/XMLSchema");
        evComplex.appendChild((Node)evseq);
        this.createElement(evseq, this.getKeyName(), keyTypeName);
        this.createElement(evseq, this.getValueName(), valueTypeName);
    }

    private void createElement(Element seq, QName name, String keyTypeName) {
        Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
        seq.appendChild((Node)element);
        element.addAttribute(new Attribute("name", name.getLocalPart()));
        element.addAttribute(new Attribute("type", keyTypeName));
        element.addAttribute(new Attribute("minOccurs", "0"));
        element.addAttribute(new Attribute("maxOccurs", "1"));
    }

    public Type getKeyType() {
        return this.getOrCreateType(this.keyClass);
    }

    private Type getOrCreateType(Class clazz) {
        Type type = this.getTypeMapping().getType(clazz);
        if (type == null) {
            System.out.println("Couldn't find type for " + clazz);
            type = this.getTypeMapping().getTypeCreator().createType(clazz);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    public Type getValueType() {
        return this.getOrCreateType(this.valueClass);
    }

    public Class getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(Class keyClass) {
        this.keyClass = keyClass;
    }

    public QName getKeyName() {
        return this.keyName;
    }

    public void setKeyName(QName keyName) {
        this.keyName = keyName;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public QName getValueName() {
        return this.valueName;
    }

    public void setValueName(QName valueName) {
        this.valueName = valueName;
    }

    public QName getEntryName() {
        return this.entryName;
    }

    public void setEntryName(QName entryName) {
        this.entryName = entryName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

