/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.jaxws.JAXWSHelper;
import org.codehaus.xfire.jaxws.SourceDispatch;
import org.codehaus.xfire.jaxws.handler.SimpleHandlerResolver;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegate
extends javax.xml.ws.spi.ServiceDelegate {
    private JAXWSHelper jaxWsHelper = JAXWSHelper.getInstance();
    private XFireProxyFactory factory = this.jaxWsHelper.getProxyFactory();
    private ServiceFactory serviceFactory = this.jaxWsHelper.getServiceFactory();
    private URL wsdlLocation;
    private Executor executor;
    private HandlerResolver handlerResolver;
    private QName serviceName;
    private Map<QName, Service> port2Service = new HashMap<QName, Service>();
    private Map<Class, Service> intf2service = new HashMap<Class, Service>();
    private Map<QName, PortInfo> port2info = new HashMap<QName, PortInfo>();

    public ServiceDelegate() {
        this.handlerResolver = new SimpleHandlerResolver();
    }

    public ServiceDelegate(URL wsdlLocation, QName serviceName, Class clientClass) {
        this();
        this.wsdlLocation = wsdlLocation;
        this.serviceName = serviceName;
        try {
            Method method = clientClass.getMethod("getPortClassMap", new Class[0]);
            Map port2Class = (Map)method.invoke(null, new Object[0]);
            for (Map.Entry entry : port2Class.entrySet()) {
                QName port = (QName)entry.getKey();
                Class clazz = (Class)entry.getValue();
                Service service = this.getService(clazz);
                this.port2Service.put(port, service);
                this.intf2service.put(clazz, service);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Service.", e);
        }
    }

    private Service getService(Class clazz) {
        Service service = this.intf2service.get(clazz);
        if (service == null) {
            service = this.serviceFactory.create(clazz, this.serviceName, this.wsdlLocation, null);
            this.intf2service.put(clazz, service);
        }
        return service;
    }

    public <T> T getPort(QName portName, Class<T> clazz) {
        Endpoint endpoint = this.getService(clazz).getEndpoint(portName);
        if (endpoint == null) {
            throw new WebServiceException("Invalid port name " + portName);
        }
        return (T)this.createPort(endpoint);
    }

    private Object createPort(Endpoint endpoint) {
        try {
            return this.factory.create(endpoint);
        }
        catch (MalformedURLException e) {
            throw new WebServiceException("Invalid url: " + endpoint.getUrl(), (Throwable)e);
        }
    }

    public <T> T getPort(Class<T> clazz) {
        if (this.getService(clazz).getEndpoints().size() == 0) {
            throw new WebServiceException("No available ports.");
        }
        return (T)this.createPort((Endpoint)this.getService(clazz).getEndpoints().iterator().next());
    }

    public void addPort(QName portName, String bindingUri, String address) {
        PortInfo portInfo = new PortInfo(bindingUri, address);
        this.port2info.put(portName, portInfo);
    }

    public <T> Dispatch<T> createDispatch(QName port, Class<T> type, Service.Mode serviceMode) {
        String address;
        Transport transport;
        PortInfo portInfo = this.getPortInfo(port);
        if (portInfo != null) {
            String bindingUri = portInfo.getBindingUri();
            transport = this.jaxWsHelper.getBinding(bindingUri).getTransport();
            address = portInfo.getAddress();
        } else {
            Service service = this.port2Service.get(port);
            if (service == null) {
                throw new IllegalStateException("Could not find port " + port);
            }
            Endpoint ep = service.getEndpoint(port);
            transport = this.jaxWsHelper.getTransportManager().getTransport(ep.getBinding().getBindingId());
            address = ep.getUrl();
        }
        Client client = new Client(transport, this.jaxWsHelper.getSourceService(), address);
        if (type == Source.class) {
            SourceDispatch dispatch = new SourceDispatch(client);
            dispatch.setMode(serviceMode);
            return dispatch;
        }
        throw new WebServiceException("Unknown dispatch type: " + type.getName());
    }

    private PortInfo getPortInfo(QName port) {
        return this.port2info.get(port);
    }

    public Dispatch<Object> createDispatch(QName arg0, JAXBContext arg1, Service.Mode arg2) {
        return null;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Iterator<QName> getPorts() {
        ArrayList<QName> ports = new ArrayList<QName>();
        ports.addAll(this.port2info.keySet());
        ports.addAll(this.port2Service.keySet());
        return ports.iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    static class PortInfo {
        private String bindingUri;
        private String address;

        public PortInfo(String bindingUri, String address2) {
            this.bindingUri = bindingUri;
            this.address = address2;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getBindingUri() {
            return this.bindingUri;
        }

        public void setBindingUri(String bindingUri) {
            this.bindingUri = bindingUri;
        }
    }
}

