/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class MapType
extends Type {
    private Class keyClass;
    private Class valueClass;
    private QName keyName;
    private QName valueName;
    private QName entryName;

    public MapType(QName schemaType, Class keyClass, Class valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.setSchemaType(schemaType);
        this.setKeyName(new QName(schemaType.getNamespaceURI(), "key"));
        this.setValueName(new QName(schemaType.getNamespaceURI(), "value"));
        this.setEntryName(new QName(schemaType.getNamespaceURI(), "entry"));
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        Map map = this.instantiateMap();
        try {
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            Object key = null;
            Object value = null;
            while (reader.hasMoreElementReaders()) {
                MessageReader entryReader = reader.getNextElementReader();
                if (entryReader.getName().equals(this.getEntryName())) {
                    while (entryReader.hasMoreElementReaders()) {
                        MessageReader evReader = entryReader.getNextElementReader();
                        if (evReader.getName().equals(this.getKeyName())) {
                            key = keyType.readObject(evReader, context);
                            continue;
                        }
                        if (evReader.getName().equals(this.getValueName())) {
                            value = valueType.readObject(evReader, context);
                            continue;
                        }
                        this.readToEnd(evReader);
                    }
                    map.put(key, value);
                    continue;
                }
                this.readToEnd(entryReader);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected Map instantiateMap() {
        Map map = null;
        if (this.getTypeClass().equals(Map.class)) {
            map = new HashMap();
        } else if (this.getTypeClass().equals(Hashtable.class)) {
            map = new Hashtable();
        } else if (this.getTypeClass().isInterface()) {
            map = new HashMap();
        } else {
            try {
                map = (Map)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not create map implementation: " + this.getTypeClass().getName(), e);
            }
        }
        return map;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            Map map = (Map)object;
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            Iterator itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                MessageWriter entryWriter = writer.getElementWriter(this.getEntryName());
                MessageWriter keyWriter = entryWriter.getElementWriter(this.getKeyName());
                keyType.writeObject(entry.getKey(), keyWriter, context);
                keyWriter.close();
                MessageWriter valueWriter = entryWriter.getElementWriter(this.getValueName());
                valueType.writeObject(entry.getValue(), valueWriter, context);
                valueWriter.close();
                entryWriter.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }

    public void writeSchema(Element root) {
        Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)complex);
        Element seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.addContent((Content)seq);
        Type keyType = this.getKeyType();
        Type valueType = this.getValueType();
        Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
        seq.addContent((Content)element);
        element.setAttribute(new Attribute("name", this.getEntryName().getLocalPart()));
        element.setAttribute(new Attribute("minOccurs", "0"));
        element.setAttribute(new Attribute("maxOccurs", "unbounded"));
        Element evComplex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        element.addContent((Content)evComplex);
        Element evseq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
        evComplex.addContent((Content)evseq);
        this.createElement(root, evseq, this.getKeyName(), keyType);
        this.createElement(root, evseq, this.getValueName(), valueType);
    }

    private void createElement(Element root, Element seq, QName name, Type type) {
        Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
        seq.addContent((Content)element);
        String prefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), type.getSchemaType().getNamespaceURI());
        String typeName = prefix + ":" + type.getSchemaType().getLocalPart();
        element.setAttribute(new Attribute("name", name.getLocalPart()));
        element.setAttribute(new Attribute("type", typeName));
        element.setAttribute(new Attribute("minOccurs", "0"));
        element.setAttribute(new Attribute("maxOccurs", "1"));
    }

    public Type getKeyType() {
        Type keyType = this.getOrCreateType(this.keyClass);
        if (keyType == null) {
            throw new XFireRuntimeException("Couldn't find type for key class " + this.keyClass + ".");
        }
        return keyType;
    }

    private Type getOrCreateType(Class clazz) {
        Type type = this.getTypeMapping().getType(clazz);
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(clazz);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getKeyType());
        deps.add(this.getValueType());
        return deps;
    }

    public boolean isComplex() {
        return true;
    }

    public Type getValueType() {
        Type valueType = this.getOrCreateType(this.valueClass);
        if (valueType == null) {
            throw new XFireRuntimeException("Couldn't find type for key class " + this.valueClass + ".");
        }
        return valueType;
    }

    public Class getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(Class keyClass) {
        this.keyClass = keyClass;
    }

    public QName getKeyName() {
        return this.keyName;
    }

    public void setKeyName(QName keyName) {
        this.keyName = keyName;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public QName getValueName() {
        return this.valueName;
    }

    public void setValueName(QName valueName) {
        this.valueName = valueName;
    }

    public QName getEntryName() {
        return this.entryName;
    }

    public void setEntryName(QName entryName) {
        this.entryName = entryName;
    }
}

