/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.fault.FaultInfoException;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GenerationException;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jsr181.AbstractPlugin;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceGenerator
extends AbstractPlugin
implements GeneratorPlugin {
    private static final Log log = LogFactory.getLog(AbstractServiceGenerator.class);
    private Service currentService;

    @Override
    public void generate(GenerationContext context) throws Exception {
        for (List list : context.getServices().values()) {
            Iterator sitr = list.iterator();
            while (sitr.hasNext()) {
                this.generate(context, (Service)sitr.next());
            }
        }
    }

    public void generate(GenerationContext context, Service service) throws Exception {
        this.setCurrentService(service);
        if (!this.isWritten(context)) {
            // empty if block
        }
        ServiceInfo serviceInfo = service.getServiceInfo();
        String clsName = this.getClassName(context, service);
        log.info((Object)("Creating class " + clsName));
        File classFile = new File(context.getOutputDirectory(), clsName.replace('.', File.separatorChar) + ".java");
        if (classFile.exists() && !this.overwriteClass(context, service, clsName, classFile)) {
            return;
        }
        JDefinedClass jc = context.getCodeModel()._class(clsName, this.getClassType());
        SchemaSupport schema = context.getSchemaGenerator();
        this.annotate(context, service, jc);
        for (OperationInfo op : serviceInfo.getOperations()) {
            JType returnType = this.getReturnType(context, schema, op);
            String name = this.javify(op.getName());
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            JMethod method = jc.method(1, returnType, name);
            this.annotate(context, op, method);
            this.generateOperation(context, op, method);
        }
    }

    protected boolean overwriteClass(GenerationContext context, Service service, String clsName, File classFile) {
        return true;
    }

    public Service getCurrentService() {
        return this.currentService;
    }

    public void setCurrentService(Service currentService) {
        this.currentService = currentService;
    }

    protected boolean isWritten(GenerationContext context) {
        return false;
    }

    private void generateOperation(GenerationContext context, OperationInfo op, JMethod method) throws GenerationException {
        Collection bindings = this.getCurrentService().getBindings();
        SchemaSupport schema = context.getSchemaGenerator();
        ArrayList<String> partNames = new ArrayList<String>();
        MessageInfo inputMsg = op.getInputMessage();
        for (MessagePartInfo part : inputMsg.getMessageParts()) {
            String varName = this.getUniqueName(this.javify(part.getName().getLocalPart()), partNames);
            partNames.add(varName);
            JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
            JVar jvar = method.param(0, paramType, varName);
            this.annotate(part, jvar);
        }
        for (Binding binding : bindings) {
            this.annotate(context, op, method, binding);
            List headers = binding.getHeaders(inputMsg).getMessageParts();
            for (MessagePartInfo part : headers) {
                String varName = this.getUniqueName(this.javify(part.getName().getLocalPart()), partNames);
                partNames.add(varName);
                JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
                JVar jvar = method.param(0, paramType, varName);
                this.annotate(part, jvar, binding);
            }
        }
        if (op.hasOutput() && op.getOutputMessage().size() > 0) {
            MessageInfo outputMsg = op.getOutputMessage();
            Iterator rtitr = outputMsg.getMessageParts().iterator();
            MessagePartInfo returnPart = (MessagePartInfo)rtitr.next();
            this.annotateReturnType(method, returnPart);
            Iterator itr = bindings.iterator();
            while (itr.hasNext()) {
                this.annotateReturnType(method, returnPart, (Binding)itr.next());
            }
            while (rtitr.hasNext()) {
                MessagePartInfo part = (MessagePartInfo)rtitr.next();
                String varName = this.getUniqueName(this.javify(part.getName().getLocalPart()), partNames);
                partNames.add(varName);
                JType paramType = this.getHolderType(context, part);
                JVar jvar = method.param(0, paramType, varName);
                this.annotateOutParam(part, jvar);
            }
            for (Binding binding : bindings) {
                List headers = binding.getHeaders(outputMsg).getMessageParts();
                for (MessagePartInfo part : headers) {
                    String varName = this.getUniqueName(this.javify(part.getName().getLocalPart()), partNames);
                    partNames.add(varName);
                    JType paramType = this.getHolderType(context, part);
                    JVar jvar = method.param(0, paramType, varName);
                    this.annotateOutParam(part, jvar, binding);
                }
            }
        } else if (!op.hasOutput()) {
            this.annotateOneWay(method);
        }
        this.generateFaults(context, op, method);
    }

    protected void annotateOneWay(JMethod method) {
    }

    protected JType getHolderType(GenerationContext context, MessagePartInfo part) throws GenerationException {
        JType genericType = context.getSchemaGenerator().getType(context, part.getName(), part.getSchemaType().getSchemaType());
        try {
            JClass holder = context.getCodeModel().ref("javax.xml.ws.Holder");
            holder = holder.narrow((JClass)genericType);
            return holder;
        }
        catch (Exception e) {
            throw new GenerationException("Could not find holder type.", e);
        }
    }

    protected void generateFaults(GenerationContext context, OperationInfo op, JMethod method) throws GenerationException {
        for (FaultInfo faultInfo : op.getFaults()) {
            List messageParts = faultInfo.getMessageParts();
            MessagePartInfo part = (MessagePartInfo)messageParts.get(0);
            JClass exCls = this.generateExceptionClass(context, part, method);
            method._throws(exCls);
        }
    }

    protected JClass generateExceptionClass(GenerationContext context, MessagePartInfo part, JMethod method) throws GenerationException {
        JDefinedClass exCls;
        JCodeModel model = context.getCodeModel();
        SchemaSupport schema = context.getSchemaGenerator();
        String name = this.javify(((FaultInfo)part.getContainer()).getName());
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
        String clsName = this.getPackage(part.getName(), context) + "." + name + "_Exception";
        try {
            exCls = model._class(clsName);
        }
        catch (JClassAlreadyExistsException e) {
            return model.ref(clsName);
        }
        exCls._extends(FaultInfoException.class);
        JFieldVar faultInfoVar = exCls.field(4, paramType, "faultInfo");
        JMethod getFaultInfo = exCls.method(1, paramType, "getFaultInfo");
        getFaultInfo.body()._return((JExpression)JExpr.ref((String)"faultInfo"));
        JMethod cons = exCls.constructor(1);
        cons.param(String.class, "message");
        cons.param(paramType, "faultInfo");
        cons.body().invoke("super").arg((JExpression)JExpr.ref((String)"message"));
        cons.body().assign((JAssignmentTarget)JExpr.refthis((String)"faultInfo"), (JExpression)JExpr.ref((String)"faultInfo"));
        cons = exCls.constructor(1);
        cons.param(String.class, "message");
        cons.param(Throwable.class, "t");
        cons.param(paramType, "faultInfo");
        cons.body().invoke("super").arg((JExpression)JExpr.ref((String)"message")).arg((JExpression)JExpr.ref((String)"t"));
        cons.body().assign((JAssignmentTarget)JExpr.refthis((String)"faultInfo"), (JExpression)JExpr.ref((String)"faultInfo"));
        JClass qType = model.ref(QName.class);
        JMethod getName = exCls.method(17, (JType)qType, "getFaultName");
        getName.body()._return((JExpression)JExpr._new((JClass)qType).arg(part.getName().getNamespaceURI()).arg(part.getName().getLocalPart()));
        return exCls;
    }

    private String getUniqueName(String varName, List<String> partNames) {
        if (!partNames.contains(varName)) {
            return varName;
        }
        int i = 2;
        String v2;
        while (partNames.contains(v2 = varName + i)) {
            ++i;
        }
        return v2;
    }

    protected abstract String getClassName(GenerationContext var1, Service var2);

    protected abstract ClassType getClassType();

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method) {
    }

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method, Binding binding) {
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar) {
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar, Binding binding) {
    }

    protected void annotateReturnType(JMethod method, MessagePartInfo returnPart) {
    }

    protected void annotateReturnType(JMethod method, MessagePartInfo returnPart, Binding binding) {
    }

    protected void annotate(MessagePartInfo part, JVar jvar) {
    }

    protected void annotate(MessagePartInfo part, JVar jvar, Binding binding) {
    }

    protected JType getReturnType(GenerationContext context, SchemaSupport schema, OperationInfo op) throws GenerationException {
        JPrimitiveType returnType;
        if (op.hasOutput() && op.getOutputMessage().size() > 0) {
            MessagePartInfo returnPart = (MessagePartInfo)op.getOutputMessage().getMessageParts().iterator().next();
            returnType = schema.getType(context, returnPart.getName(), returnPart.getSchemaType().getSchemaType());
        } else {
            returnType = context.getCodeModel().VOID;
        }
        return returnType;
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc) {
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc, Binding binding) {
    }
}

