/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;

public abstract class AbstractMessageSender {
    private OutMessage message;
    private MessageContext context;

    public AbstractMessageSender(OutMessage message, MessageContext context) {
        this.message = message;
        this.context = context;
    }

    public abstract void open() throws IOException, XFireException;

    public abstract void send() throws IOException, XFireException;

    public abstract void close() throws XFireException;

    public abstract boolean hasResponse();

    public abstract int getStatusCode();

    public abstract InMessage getInMessage() throws IOException;

    public MessageContext getMessageContext() {
        return this.context;
    }

    public void setMessageContext(MessageContext context) {
        this.context = context;
    }

    public OutMessage getMessage() {
        return this.message;
    }

    public void setMessage(OutMessage message) {
        this.message = message;
    }

    public String getEncoding() {
        return this.message.getEncoding();
    }

    public String getSoapAction() {
        return (String)this.message.getProperty("SOAPAction");
    }

    public String getQuotedSoapAction() {
        String action = this.getSoapAction();
        if (action == null) {
            action = "";
        }
        return "\"" + action + "\"";
    }

    public String getUri() {
        return this.message.getUri();
    }
}

