/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.AbstractWSDL;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderExtension;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class WSDLBuilder
extends AbstractWSDL
implements WSDLWriter {
    public static final String OVERRIDING_TYPES = "overridingTypes";
    private PortType portType;
    private Map wsdlOps = new HashMap();
    private TransportManager transportManager;
    private Map declaredParameters = new HashMap();
    private List extensions;
    private Definition def;

    public WSDLBuilder(Service service, TransportManager transportManager) throws WSDLException {
        super(service);
        this.setDefinition(WSDLFactory.newInstance().newDefinition());
        this.getDefinition().setTargetNamespace(this.getTargetNamespace());
        this.transportManager = transportManager;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    protected void writeComplexTypes() {
        List l = (List)this.getService().getProperty(OVERRIDING_TYPES);
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                SchemaType t = (SchemaType)it.next();
                this.addDependency(t);
            }
        }
        if (this.getSchemaTypes().getContentSize() > 0) {
            org.jdom.Element schemaTypes = this.getSchemaTypes();
            List addNs = schemaTypes.getAdditionalNamespaces();
            Iterator itr = addNs.iterator();
            while (itr.hasNext()) {
                Namespace ns = (Namespace)itr.next();
                if (this.getDefinition().getNamespace(ns.getPrefix()) != null) continue;
                this.addNamespace(ns.getPrefix(), ns.getURI());
            }
            try {
                Types types = this.getDefinition().createTypes();
                this.getDefinition().setTypes(types);
                List children = schemaTypes.getChildren();
                while (children.size() > 0) {
                    org.jdom.Element child = (org.jdom.Element)children.get(0);
                    child.detach();
                    Document inputDoc = new Document(child);
                    org.w3c.dom.Document doc = new DOMOutputter().output(inputDoc);
                    Element root = doc.getDocumentElement();
                    NamedNodeMap attributes = root.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Attr a = (Attr)attributes.item(i);
                        if (!a.getNodeName().startsWith("xmlns:") || !a.getNodeValue().equals("http://www.w3.org/2001/XMLSchema")) continue;
                        root.removeAttribute(a.getNodeName());
                    }
                    SchemaImpl uee = new SchemaImpl();
                    uee.setElement(doc.getDocumentElement());
                    uee.setRequired(Boolean.TRUE);
                    uee.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                    types.addExtensibilityElement((ExtensibilityElement)uee);
                }
            }
            catch (JDOMException e) {
                throw new XFireRuntimeException("Could write schemas to wsdl!", e);
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        try {
            this.initialize();
            PortType portType = this.createAbstractInterface();
            this.createConcreteInterface(portType);
            this.updateImports();
            this.writeComplexTypes();
            if (this.extensions != null) {
                Iterator itr = this.extensions.iterator();
                while (itr.hasNext()) {
                    WSDLBuilderExtension ex = (WSDLBuilderExtension)itr.next();
                    ex.extend(this.getDefinition(), this);
                }
            }
            javax.wsdl.xml.WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            writer.writeWSDL(this.getDefinition(), out);
        }
        catch (WSDLException e) {
            throw new XFireRuntimeException("Error creating wsdl", e);
        }
    }

    public PortType createAbstractInterface() throws WSDLException {
        Service service = this.getService();
        Definition def = this.getDefinition();
        QName portName = service.getServiceInfo().getPortType();
        if (portName == null) {
            portName = new QName(this.getTargetNamespace(), service.getSimpleName() + "PortType");
        }
        this.portType = def.createPortType();
        this.portType.setQName(portName);
        this.portType.setUndefined(false);
        def.addPortType(this.portType);
        Iterator itr = service.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            Message req = this.createInputMessage(op);
            def.addMessage(req);
            Message res = null;
            if (op.getMEP().equals("urn:xfire:mep:in-out")) {
                res = this.createOutputMessage(op);
                def.addMessage(res);
            }
            ArrayList<Fault> faultMessages = new ArrayList<Fault>();
            Iterator faultItr = op.getFaults().iterator();
            while (faultItr.hasNext()) {
                FaultInfo fault = (FaultInfo)faultItr.next();
                Fault faultMsg = this.createFault(op, fault);
                faultMessages.add(faultMsg);
            }
            Operation wsdlOp = this.createOperation(op, req, res, faultMessages);
            wsdlOp.setUndefined(false);
            this.portType.addOperation(wsdlOp);
            this.wsdlOps.put(op.getName(), wsdlOp);
        }
        return this.portType;
    }

    public void createConcreteInterface(PortType portType) {
        Service service = this.getService();
        Definition def = this.getDefinition();
        QName name = service.getName();
        javax.wsdl.Service wsdlService = def.createService();
        wsdlService.setQName(name);
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Collection endpoints;
            Binding wbinding;
            org.codehaus.xfire.service.Binding binding = (org.codehaus.xfire.service.Binding)itr.next();
            Port port = binding.createPort(this, wbinding = binding.createBinding(this, portType));
            if (port != null) {
                wsdlService.addPort(port);
            }
            if ((endpoints = service.getEndpoints(binding.getName())) == null) continue;
            Iterator eitr = endpoints.iterator();
            while (eitr.hasNext()) {
                Endpoint ep = (Endpoint)eitr.next();
                port = binding.createPort(ep, this, wbinding);
                if (port == null) continue;
                wsdlService.addPort(port);
            }
        }
        def.addService(wsdlService);
    }

    private Message createOutputMessage(OperationInfo op) {
        Message res = this.getDefinition().createMessage();
        res.setQName(new QName(this.getTargetNamespace(), op.getName() + "Response"));
        res.setUndefined(false);
        if (this.getService().getServiceInfo().isWrapped()) {
            this.createWrappedOutputParts(res, op);
        } else {
            this.createOutputParts(res, op);
        }
        return res;
    }

    private Message createInputMessage(OperationInfo op) {
        Message req = this.getDefinition().createMessage();
        req.setQName(new QName(this.getTargetNamespace(), op.getName() + "Request"));
        req.setUndefined(false);
        if (this.getService().getServiceInfo().isWrapped()) {
            this.createWrappedInputParts(req, op);
        } else {
            this.createInputParts(req, op);
        }
        return req;
    }

    private Fault createFault(OperationInfo op, FaultInfo faultInfo) {
        Message faultMsg = this.getDefinition().createMessage();
        faultMsg.setQName(new QName(this.getTargetNamespace(), faultInfo.getName()));
        faultMsg.setUndefined(false);
        this.getDefinition().addMessage(faultMsg);
        Fault fault = this.getDefinition().createFault();
        fault.setName(faultInfo.getName());
        fault.setMessage(faultMsg);
        Iterator itr = faultInfo.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo info = (MessagePartInfo)itr.next();
            String uri = info.getName().getNamespaceURI();
            this.addNamespace(this.getNamespacePrefix(uri), uri);
            Part part = this.createPart(info);
            faultMsg.addPart(part);
        }
        return fault;
    }

    public Part createPart(MessagePartInfo part) {
        String style = (String)this.getService().getProperty("objectServiceFactory.style");
        if (style != null && style.equals("rpc")) {
            return this.createRpcLitPart(part.getName(), part.getTypeClass(), part.getSchemaType());
        }
        return this.createDocLitPart(part.getName(), part.getTypeClass(), part.getSchemaType());
    }

    public Part createRpcLitPart(QName pName, Class clazz, SchemaType type) {
        this.addDependency(type);
        QName schemaTypeName = type.getSchemaType();
        Part part = this.getDefinition().createPart();
        part.setName(pName.getLocalPart());
        String prefix = this.getNamespacePrefix(schemaTypeName.getNamespaceURI());
        this.addNamespace(prefix, schemaTypeName.getNamespaceURI());
        if (!type.isAbstract()) {
            part.setElementName(schemaTypeName);
        } else {
            part.setTypeName(schemaTypeName);
        }
        return part;
    }

    public Part createDocLitPart(QName pName, Class clazz, SchemaType type) {
        this.addDependency(type);
        QName schemaTypeName = type.getSchemaType();
        Part part = this.getDefinition().createPart();
        part.setName(pName.getLocalPart());
        if (!type.isAbstract()) {
            String prefix = this.getNamespacePrefix(schemaTypeName.getNamespaceURI());
            this.addNamespace(prefix, schemaTypeName.getNamespaceURI());
            part.setElementName(schemaTypeName);
            return part;
        }
        SchemaType regdType = (SchemaType)this.declaredParameters.get(pName);
        if (regdType == null) {
            org.jdom.Element schemaEl = this.createSchemaType(pName.getNamespaceURI());
            org.jdom.Element element = new org.jdom.Element("element", XSD_NS);
            schemaEl.addContent((Content)element);
            String prefix = this.getNamespacePrefix(schemaTypeName.getNamespaceURI());
            this.addNamespace(prefix, schemaTypeName.getNamespaceURI());
            if (type.isAbstract()) {
                element.setAttribute(new Attribute("name", pName.getLocalPart()));
                element.setAttribute(new Attribute("type", prefix + ":" + schemaTypeName.getLocalPart()));
            }
            this.declaredParameters.put(pName, type);
        } else if (!regdType.equals(type)) {
            throw new XFireRuntimeException("Cannot create two schema elements with the same name and of different types: " + pName);
        }
        part.setElementName(pName);
        return part;
    }

    public Operation createOperation(OperationInfo op, Message req, Message res, List faultMessages) {
        Definition def = this.getDefinition();
        Operation wsdlOp = def.createOperation();
        Input input = def.createInput();
        input.setMessage(req);
        input.setName(req.getQName().getLocalPart());
        wsdlOp.setInput(input);
        if (res != null) {
            Output output = def.createOutput();
            output.setMessage(res);
            output.setName(res.getQName().getLocalPart());
            wsdlOp.setOutput(output);
        }
        Iterator itr = faultMessages.iterator();
        while (itr.hasNext()) {
            wsdlOp.addFault((Fault)itr.next());
        }
        wsdlOp.setName(op.getName());
        return wsdlOp;
    }

    public void createInputParts(Message req, OperationInfo op) {
        this.writeParameters(req, op.getInputMessage().getMessageParts());
    }

    public void createOutputParts(Message req, OperationInfo op) {
        this.writeParameters(req, op.getOutputMessage().getMessageParts());
    }

    private void writeParameters(Message message, Collection params) {
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            MessagePartInfo param = (MessagePartInfo)itr.next();
            this.addNamespaceImport(this.getService().getTargetNamespace(), param.getSchemaType().getSchemaType().getNamespaceURI());
            Part part = this.createPart(param);
            message.addPart(part);
        }
    }

    protected void createWrappedInputParts(Message req, OperationInfo op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createDocumentType(op.getInputMessage(), part, op.getName());
        part.setName("parameters");
        part.setElementName(typeQName);
        req.addPart(part);
    }

    protected void createWrappedOutputParts(Message req, OperationInfo op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createDocumentType(op.getOutputMessage(), part, op.getName() + "Response");
        part.setElementName(typeQName);
        part.setName("parameters");
        req.addPart(part);
    }

    protected QName createDocumentType(MessageInfo message, Part part, String opName) {
        org.jdom.Element element = new org.jdom.Element("element", AbstractWSDL.XSD_NS);
        element.setAttribute(new Attribute("name", opName));
        org.jdom.Element complex = new org.jdom.Element("complexType", AbstractWSDL.XSD_NS);
        element.addContent((Content)complex);
        if (message.getMessageParts().size() > 0) {
            org.jdom.Element sequence = this.createSequence(complex);
            this.writeParametersSchema(message.getMessageParts(), sequence);
        }
        org.jdom.Element schemaEl = this.createSchemaType(this.getTargetNamespace());
        schemaEl.addContent((Content)element);
        return new QName(this.getTargetNamespace(), opName);
    }

    protected void writeParametersSchema(Collection params, org.jdom.Element sequence) {
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            MessagePartInfo param = (MessagePartInfo)itr.next();
            QName pName = param.getName();
            SchemaType type = param.getSchemaType();
            this.addDependency(type);
            QName schemaType = type.getSchemaType();
            this.addNamespaceImport(this.getService().getTargetNamespace(), schemaType.getNamespaceURI());
            String uri = type.getSchemaType().getNamespaceURI();
            String prefix = this.getNamespacePrefix(uri);
            this.addNamespace(prefix, uri);
            org.jdom.Element element = new org.jdom.Element("element", AbstractWSDL.XSD_NS);
            sequence.addContent((Content)element);
            if (type.isAbstract()) {
                element.setAttribute(new Attribute("name", pName.getLocalPart()));
                element.setAttribute(new Attribute("type", prefix + ":" + schemaType.getLocalPart()));
                if (type.isNillable()) {
                    element.setAttribute(new Attribute("nillable", "true"));
                }
            } else {
                element.setAttribute(new Attribute("ref", prefix + ":" + schemaType.getLocalPart()));
            }
            element.setAttribute(new Attribute("minOccurs", "1"));
            element.setAttribute(new Attribute("maxOccurs", "1"));
        }
    }

    public void addNamespace(String prefix, String uri) {
        this.def.addNamespace(prefix, uri);
        super.addNamespace(prefix, uri);
    }

    protected org.jdom.Element createSequence(org.jdom.Element complex) {
        org.jdom.Element sequence = new org.jdom.Element("sequence", AbstractWSDL.XSD_NS);
        complex.addContent((Content)sequence);
        return sequence;
    }

    public List getWSDLBuilderExtensions() {
        return this.extensions;
    }

    public void setWSDLBuilderExtensions(List extensions) {
        this.extensions = extensions;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public void setDefinition(Definition definition) {
        this.def = definition;
    }
}

