/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.SoapFaultSerializer;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl11.parser.BindingAnnotator;
import org.codehaus.xfire.wsdl11.parser.SoapBindingAnnotator;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLServiceConfigurator {
    protected final Definition definition;
    private List bindingAnnotators = new ArrayList();
    private TransportManager transportManager = XFireFactory.newInstance().getXFire().getTransportManager();
    private ServiceInfo serviceInfo;
    private BindingProvider bindingProvider;
    private Service service;
    private javax.wsdl.Service wservice;
    private PortType portType;
    private Collection ports;
    private boolean initService = false;

    public WSDLServiceConfigurator(Service service, URL url, TransportManager transportManager) throws WSDLException, IOException {
        this(service, WSDLFactory.newInstance().newWSDLReader().readWSDL(null, new InputSource(url.openStream())), transportManager);
    }

    public WSDLServiceConfigurator(Service service, Definition def, TransportManager transportManager) {
        this.service = service;
        this.serviceInfo = service.getServiceInfo();
        this.bindingProvider = service.getBindingProvider();
        this.transportManager = transportManager;
        this.definition = def;
        this.wservice = this.definition.getService(service.getName());
        if (this.wservice == null) {
            throw new XFireRuntimeException("Could not find service in wsdl: " + service.getName());
        }
        this.setWrapped();
        this.ports = new ArrayList();
        Iterator itr = this.wservice.getPorts().values().iterator();
        while (itr.hasNext()) {
            Port p = (Port)itr.next();
            if (!p.getBinding().getPortType().getQName().equals(this.serviceInfo.getPortType())) continue;
            this.ports.add(p);
        }
        this.bindingAnnotators.add(new SoapBindingAnnotator());
    }

    private void setWrapped() {
        XmlSchemaCollection schemas = new XmlSchemaCollection();
        Iterator itr = this.definition.getTypes().getExtensibilityElements().iterator();
        while (itr.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)itr.next();
            if (ee instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement uee = (UnknownExtensibilityElement)ee;
                schemas.read(uee.getElement());
                continue;
            }
            try {
                Method mth = ee.getClass().getMethod("getElement", new Class[0]);
                Object val = mth.invoke((Object)ee, new Object[0]);
                schemas.read((Element)val);
            }
            catch (Exception e) {}
        }
        boolean wrapped = true;
        PortType portType = this.definition.getPortType(this.service.getServiceInfo().getPortType());
        if (portType == null) {
            throw new XFireRuntimeException("Could not find port type " + this.service.getServiceInfo().getPortType());
        }
        Iterator itr2 = portType.getOperations().iterator();
        while (itr2.hasNext()) {
            Operation op = (Operation)itr2.next();
            if (WSDLServiceBuilder.isWrapped(op, schemas)) continue;
            wrapped = false;
            break;
        }
        this.service.getServiceInfo().setWrapped(wrapped);
    }

    public WSDLServiceConfigurator(ServiceInfo serviceInfo, Definition definition, javax.wsdl.Service wservice, PortType portType, Collection ports, BindingProvider bindingProvider, TransportManager transportManager) {
        this.definition = definition;
        this.ports = ports;
        this.wservice = wservice;
        this.portType = portType;
        this.bindingProvider = bindingProvider;
        this.transportManager = transportManager;
        this.serviceInfo = serviceInfo;
        this.initService = true;
        this.bindingAnnotators.add(new SoapBindingAnnotator());
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void configure() throws Exception {
        this.begin(this.wservice, this.portType);
        Iterator iterator1 = this.ports.iterator();
        while (iterator1.hasNext()) {
            Port port = (Port)iterator1.next();
            Binding binding = port.getBinding();
            this.visit(binding);
            this.visit(port);
        }
        this.end(this.wservice, this.portType);
    }

    protected void visit(Binding binding) {
        BindingAnnotator ann = this.getBindingAnnotator(binding);
        if (ann != null) {
            ann.setBindingProvider(this.bindingProvider);
            ann.setDefinition(this.definition);
            ann.setService(this.service);
            ann.setTransportManager(this.transportManager);
            ann.visit(binding);
            List bindingOperations = binding.getBindingOperations();
            for (int i = 0; i < bindingOperations.size(); ++i) {
                BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(i);
                OperationInfo opInfo = this.serviceInfo.getOperation(bindingOperation.getName());
                ann.visit(bindingOperation, opInfo);
                ann.visit(bindingOperation.getBindingInput(), bindingOperation.getOperation().getInput(), opInfo.getInputMessage());
                if (opInfo.hasOutput()) {
                    ann.visit(bindingOperation.getBindingOutput(), bindingOperation.getOperation().getOutput(), opInfo.getOutputMessage());
                }
                Collection bindingFaults = bindingOperation.getBindingFaults().values();
                Iterator iterator2 = bindingFaults.iterator();
                while (iterator2.hasNext()) {
                    BindingFault bindingFault = (BindingFault)iterator2.next();
                    Fault fault = bindingOperation.getOperation().getFault(bindingFault.getName());
                    FaultInfo faultInfo = opInfo.getFault(fault.getName());
                    ann.visit(bindingFault, fault, faultInfo);
                }
            }
        }
    }

    protected BindingAnnotator getBindingAnnotator(Binding binding) {
        Iterator itr = this.bindingAnnotators.iterator();
        while (itr.hasNext()) {
            BindingAnnotator ann = (BindingAnnotator)itr.next();
            if (!ann.isUnderstood(binding)) continue;
            ann.setService(this.service);
            return ann;
        }
        return null;
    }

    protected void begin(javax.wsdl.Service wservice, PortType portType) {
        if (this.initService) {
            this.service = new Service(this.serviceInfo);
            this.service.setName(wservice.getQName());
        }
    }

    protected void end(javax.wsdl.Service wservice, PortType portType) {
        if (this.initService) {
            this.service.setFaultSerializer(new SoapFaultSerializer());
            this.service.setBindingProvider(this.bindingProvider);
        }
    }

    protected void visit(Port port) {
        BindingAnnotator ann = this.getBindingAnnotator(port.getBinding());
        if (ann != null) {
            ann.visit(port);
        }
    }

    public Service getService() {
        return this.service;
    }
}

