/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SDeclaration
extends AStatement {
    private final String type;
    private final String name;
    private AExpression expression;
    private Locals.Variable variable = null;

    public SDeclaration(Location location, String type, String name, AExpression expression) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.expression = expression;
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
        if (this.expression != null) {
            this.expression.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Definition.Type type;
        try {
            type = Definition.getType(this.type);
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        if (this.expression != null) {
            this.expression.expected = type;
            this.expression.analyze(locals);
            this.expression = this.expression.cast(locals);
        }
        this.variable = locals.addVariable(this.location, type, this.name, false);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        if (this.expression == null) {
            switch (this.variable.type.sort) {
                case VOID: {
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                case BOOL: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: {
                    writer.push(0);
                    break;
                }
                case LONG: {
                    writer.push(0L);
                    break;
                }
                case FLOAT: {
                    writer.push(0.0f);
                    break;
                }
                case DOUBLE: {
                    writer.push(0.0);
                    break;
                }
                default: {
                    writer.visitInsn(1);
                    break;
                }
            }
        } else {
            this.expression.write(writer, globals);
        }
        writer.visitVarInsn(this.variable.type.type.getOpcode(54), this.variable.getSlot());
    }

    @Override
    public String toString() {
        if (this.expression == null) {
            return this.singleLineToString(this.type, this.name);
        }
        return this.singleLineToString(this.type, this.name, this.expression);
    }
}

