/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.ChannelId;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux,
TransportListener {
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    private final Logger logger = Log.getLogger((String)this.getClass().getName());
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final Queue<Message.Mutable> messageQueue = new ConcurrentLinkedQueue<Message.Mutable>();
    private Map<String, ExpirableCookie> cookies = new ConcurrentHashMap<String, ExpirableCookie>();
    private final TransportListener listener = new Listener();
    private final HttpURI url;
    private volatile Map<String, Object> handshakeFields;
    private volatile ScheduledExecutorService scheduler;
    private volatile boolean shutdownScheduler;
    private volatile boolean handshakeBatch;
    private volatile ClientTransport transport;
    private volatile String clientId;
    private volatile Map<String, Object> advice;
    private volatile int backoffTries;
    private volatile long backoffIncrement;
    private volatile long maxBackoff;
    private volatile State state = State.UNCONNECTED;

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        if (transport == null) {
            throw new IllegalArgumentException("Transport cannot be null");
        }
        this.url = new HttpURI(url);
        this.scheduler = scheduler;
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public String getCookie(String name) {
        ExpirableCookie cookie = this.cookies.get(name);
        if (cookie != null && cookie.isExpired()) {
            this.cookies.remove(cookie.getName());
            cookie = null;
        }
        return cookie == null ? null : cookie.getValue();
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, -1);
    }

    public void setCookie(String name, String value, int maxAge) {
        long expirationTime = System.currentTimeMillis();
        expirationTime = maxAge < 0 ? -1L : (expirationTime += TimeUnit.SECONDS.toMillis(maxAge));
        ExpirableCookie expirableCookie = new ExpirableCookie(name, value, expirationTime);
        this.cookies.put(name, expirableCookie);
    }

    public String getId() {
        return this.clientId;
    }

    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    public boolean isHandshook() {
        return this.state == State.CONNECTED || this.state == State.CONNECTING;
    }

    public boolean isDisconnected() {
        return this.state == State.DISCONNECTING || this.state == State.DISCONNECTED;
    }

    protected State getState() {
        return this.state;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> handshakeFields) {
        this.initialize();
        this.handshakeFields = handshakeFields;
        List<String> allowedTransport = this.getAllowedTransports();
        Message.Mutable message = this.newMessage();
        if (handshakeFields != null) {
            message.putAll(handshakeFields);
        }
        message.setChannel("/meta/handshake");
        message.put((Object)"supportedConnectionTypes", allowedTransport);
        message.put((Object)"version", (Object)BAYEUX_VERSION);
        message.setId(this.newMessageId());
        ClientTransport initialTransport = this.transportRegistry.getTransport(allowedTransport.get(0));
        this.updateTransport(initialTransport);
        this.updateState(State.HANDSHAKING);
        this.logger.debug("Handshaking with extra fields {}, transport {}", new Object[]{handshakeFields, initialTransport});
        this.handshakeBatch = true;
        this.send(message);
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTED, State.CONNECTING, State.DISCONNECTED, State.UNCONNECTED);
        return this.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State state, State ... states) {
        long start = System.currentTimeMillis();
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(Arrays.asList(states));
        BayeuxClient bayeuxClient = this;
        synchronized (bayeuxClient) {
            State currentState;
            while (System.currentTimeMillis() - start < waitMs) {
                currentState = this.getState();
                for (State s : waitForStates) {
                    if (s != currentState) continue;
                    return true;
                }
                try {
                    this.wait(waitMs);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
            currentState = this.getState();
            for (State s : waitForStates) {
                if (s != currentState) continue;
                return true;
            }
            return false;
        }
    }

    protected void connect() {
        Message.Mutable message = this.newMessage();
        message.setChannel("/meta/connect");
        message.put((Object)"connectionType", (Object)this.transport.getName());
        this.updateState(State.CONNECTED);
        this.logger.debug("Connecting, transport {}", new Object[]{this.transport});
        this.send(message);
    }

    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    protected void sendBatch() {
        if (this.handshakeBatch) {
            return;
        }
        LinkedList<Message.Mutable> queue = new LinkedList<Message.Mutable>(this.messageQueue);
        this.messageQueue.removeAll(queue);
        if (!queue.isEmpty()) {
            this.logger.debug("Dequeued messages {}", new Object[]{queue});
            this.send(queue.toArray(new Message.Mutable[queue.size()]));
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.updateState(State.DISCONNECTING);
            Message.Mutable message = this.newMessage();
            message.setChannel("/meta/disconnect");
            this.send(message);
        } else {
            this.terminate();
        }
    }

    public void abort() {
        this.transport.abort();
        this.terminate();
    }

    public void receive(Message message, Message.Mutable mutable) {
        this.logger.debug("Received message {} by {}", new Object[]{message, this});
        this.updateAdvice(message);
        String channelName = message.getChannel();
        if ("/meta/handshake".equals(channelName)) {
            this.processHandshake(message);
        } else if ("/meta/connect".equals(channelName)) {
            this.processConnect(message);
        } else if ("/meta/disconnect".equals(channelName)) {
            this.processDisconnect(message);
        }
        super.receive(message, mutable);
    }

    protected Map<String, Object> getAdvice() {
        return this.advice;
    }

    private void updateAdvice(Message message) {
        Map advice = message.getAdvice();
        if (advice != null) {
            this.advice = advice;
            this.logger.debug("Updated advice to {}", new Object[]{advice});
        }
    }

    protected void followAdvice() {
        String action = "retry";
        long interval = 0L;
        Map<String, Object> advice = this.getAdvice();
        if (advice != null) {
            if (advice.containsKey("reconnect")) {
                action = (String)advice.get("reconnect");
            }
            if (advice.containsKey("interval")) {
                interval = ((Number)advice.get("interval")).longValue();
            }
        }
        if ("none".equals(action)) {
            this.terminate();
            return;
        }
        if ("handshake".equals(action)) {
            this.updateState(State.HANDSHAKING);
        }
        State state = this.getState();
        switch (state) {
            case HANDSHAKING: {
                this.scheduleAction(new Runnable(){

                    @Override
                    public void run() {
                        BayeuxClient.this.handshake(BayeuxClient.this.handshakeFields);
                    }
                }, interval);
                break;
            }
            case CONNECTING: 
            case CONNECTED: 
            case UNCONNECTED: {
                this.scheduleAction(new Runnable(){

                    @Override
                    public void run() {
                        BayeuxClient.this.connect();
                    }
                }, interval);
                break;
            }
            case DISCONNECTING: 
            case DISCONNECTED: {
                this.terminate();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)state));
            }
        }
    }

    protected void processHandshake(Message handshake) {
        this.logger.debug("Processing handshake {}", new Object[]{handshake});
        if (handshake.isSuccessful()) {
            ClientTransport newTransport;
            this.resetBackoff();
            Object[] serverTransports = (Object[])handshake.get((Object)"supportedConnectionTypes");
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            ClientTransport clientTransport = newTransport = negotiatedTransports.isEmpty() ? null : negotiatedTransports.get(0);
            if (newTransport == null) {
                throw new UnsupportedOperationException();
            }
            this.clientId = handshake.getClientId();
            this.updateTransport(newTransport);
            this.updateState(State.CONNECTING);
            this.handshakeBatch = false;
            this.sendBatch();
        } else {
            this.increaseBackoff();
        }
        this.followAdvice();
    }

    protected void processConnect(Message connect) {
        this.logger.debug("Processing connect {}", new Object[]{connect});
        if (!connect.isSuccessful()) {
            this.updateState(State.UNCONNECTED);
            this.increaseBackoff();
        }
        this.followAdvice();
    }

    protected void processDisconnect(Message disconnect) {
        this.logger.debug("Processing disconnect {}", new Object[]{disconnect});
        this.terminate();
    }

    protected boolean scheduleAction(Runnable action, long interval) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            long backoff = this.calculateBackoff();
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.debug((Throwable)x);
            }
        }
        return false;
    }

    private void increaseBackoff() {
        ++this.backoffTries;
    }

    private void resetBackoff() {
        this.backoffTries = 0;
    }

    private long calculateBackoff() {
        return Math.min((long)this.backoffTries * this.getBackoffIncrement(), this.getMaxBackoff());
    }

    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    public Transport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    protected void initialize() {
        Long backoffIncrement = (Long)this.getOption(BACKOFF_INCREMENT_OPTION);
        if (backoffIncrement == null) {
            backoffIncrement = 1000L;
        }
        this.backoffIncrement = backoffIncrement;
        Long maxBackoff = (Long)this.getOption(MAX_BACKOFF_OPTION);
        if (maxBackoff == null) {
            maxBackoff = 30000L;
        }
        this.maxBackoff = maxBackoff;
        this.resetBackoff();
        this.advice = null;
        this.handshakeBatch = false;
        this.messageQueue.clear();
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.shutdownScheduler = true;
        }
    }

    protected void terminate() {
        this.updateState(State.DISCONNECTED);
        this.resetBackoff();
        this.advice = null;
        this.handshakeBatch = false;
        this.messageQueue.clear();
        if (this.shutdownScheduler) {
            this.shutdownScheduler = false;
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
    }

    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    protected Message.Mutable newMessage() {
        if (this.transport != null) {
            return this.transport.newMessage();
        }
        return new HashMapMessage();
    }

    protected void updateTransport(ClientTransport newTransport) {
        if (this.transport == newTransport) {
            return;
        }
        if (this.transport != null) {
            this.transport.reset();
        }
        newTransport.init(this, this.url);
        ClientTransport oldTransport = this.transport;
        this.transport = newTransport;
        this.logger.debug("Updated transport: {} -> {}", new Object[]{oldTransport, newTransport});
    }

    protected void send(Message.Mutable ... messages) {
        List<Message.Mutable> messageList = Arrays.asList(messages);
        Iterator<Message.Mutable> iterator = messageList.iterator();
        while (iterator.hasNext()) {
            Message.Mutable message = iterator.next();
            if (message.getId() == null) {
                message.setId(this.newMessageId());
            }
            if (this.clientId != null) {
                message.setClientId(this.clientId);
            }
            if (this.extendSend(message)) continue;
            iterator.remove();
        }
        if (!messageList.isEmpty()) {
            this.logger.debug("Sending messages {}", new Object[]{messageList});
            this.transport.send(this.listener, messageList.toArray(new Message.Mutable[messageList.size()]));
        }
    }

    protected void enqueueSend(Message.Mutable message) {
        boolean batching = this.isBatching();
        if (batching || this.handshakeBatch) {
            this.messageQueue.offer(message);
            this.logger.debug("Enqueued message {}, batching {}", new Object[]{message, batching});
        } else {
            this.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(State newState) {
        State oldState = this.state;
        this.state = newState;
        this.logger.debug("Updated state: {} -> {}", new Object[]{oldState, newState});
        BayeuxClient bayeuxClient = this;
        synchronized (bayeuxClient) {
            this.notifyAll();
        }
    }

    @Override
    public void onSending(Message[] messages) {
    }

    @Override
    public void onMessages(List<Message.Mutable> messages) {
    }

    @Override
    public void onConnectException(Throwable x) {
    }

    @Override
    public void onException(Throwable x) {
    }

    @Override
    public void onExpire() {
    }

    @Override
    public void onProtocolError(String info) {
    }

    public void customize(HttpExchange exchange) {
        StringBuilder builder = null;
        for (String cookieName : this.cookies.keySet()) {
            String value;
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append("; ");
            }
            if ((value = this.getCookie(cookieName)) == null) continue;
            builder.append(QuotedStringTokenizer.quote((String)cookieName));
            builder.append("=");
            builder.append(QuotedStringTokenizer.quote((String)value));
        }
        if (builder != null) {
            exchange.setRequestHeader("Cookie", builder.toString());
        }
    }

    public String toString() {
        return super.toString() + ":" + this.url + ":" + (Object)((Object)this.getState());
    }

    private static class ExpirableCookie {
        private final String name;
        private final String value;
        private final long expirationTime;

        private ExpirableCookie(String name, String value, long expirationTime) {
            this.name = name;
            this.value = value;
            this.expirationTime = expirationTime;
        }

        private boolean isExpired() {
            long expire = this.getExpirationTime();
            if (expire < 0L) {
                return false;
            }
            return System.currentTimeMillis() >= expire;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }
    }

    private class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        private BayeuxClientChannel(ChannelId channelId) {
            super(channelId);
        }

        public ClientSession getSession() {
            return BayeuxClient.this;
        }

        protected void sendSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this.getId());
            BayeuxClient.this.enqueueSend(message);
        }

        protected void sendUnSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this.getId());
            BayeuxClient.this.enqueueSend(message);
        }

        public void publish(Object data) {
            this.publish(data, null);
        }

        public void publish(Object data, String messageId) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel(this.getId());
            message.setData(data);
            if (messageId != null) {
                message.setId(String.valueOf(messageId));
            }
            BayeuxClient.this.enqueueSend(message);
        }
    }

    private class Listener
    implements TransportListener {
        private Listener() {
        }

        @Override
        public void onSending(Message[] messages) {
            BayeuxClient.this.onSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            for (Message.Mutable message : messages) {
                BayeuxClient.this.receive((Message)message, message);
            }
        }

        @Override
        public void onConnectException(Throwable x) {
            BayeuxClient.this.onConnectException(x);
            this.onFailure();
        }

        @Override
        public void onException(Throwable x) {
            BayeuxClient.this.onException(x);
            this.onFailure();
        }

        @Override
        public void onExpire() {
            BayeuxClient.this.onExpire();
            this.onFailure();
        }

        @Override
        public void onProtocolError(String info) {
            BayeuxClient.this.onProtocolError(info);
            this.onFailure();
        }

        private void onFailure() {
            if (BayeuxClient.this.getState() == State.CONNECTED) {
                BayeuxClient.this.updateState(State.UNCONNECTED);
            }
            BayeuxClient.this.increaseBackoff();
            BayeuxClient.this.followAdvice();
        }
    }

    public static enum State {
        UNCONNECTED,
        HANDSHAKING,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

