/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.ajax.JSON;

public class LongPollingTransport
extends ClientTransport {
    private final HttpClient _httpClient;
    private final List<HttpExchange> _exchanges = new ArrayList<HttpExchange>();
    private volatile boolean _aborted;
    private volatile BayeuxClient _bayeuxClient;
    private volatile HttpURI _uri;
    private volatile boolean _appendMessageType;

    public static LongPollingTransport create(Map<String, Object> options) {
        HttpClient httpClient = new HttpClient();
        httpClient.setIdleTimeout(5000L);
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(32768);
        return LongPollingTransport.create(options, httpClient);
    }

    public static LongPollingTransport create(Map<String, Object> options, HttpClient httpClient) {
        LongPollingTransport transport = new LongPollingTransport(options, httpClient);
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        super("long-polling", options);
        this._httpClient = httpClient;
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init(BayeuxClient bayeux, HttpURI uri) {
        this._aborted = false;
        this._bayeuxClient = bayeux;
        this._uri = uri;
        Pattern uriRegexp = Pattern.compile("(^https?://(([^:/\\?#]+)(:(\\d+))?))?([^\\?#]*)(.*)?");
        Matcher uriMatcher = uriRegexp.matcher(uri.toString());
        if (uriMatcher.matches()) {
            String afterPath = uriMatcher.group(7);
            this._appendMessageType = afterPath == null || afterPath.trim().length() == 0;
        }
        super.init(bayeux, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        LongPollingTransport longPollingTransport = this;
        synchronized (longPollingTransport) {
            this._aborted = true;
            for (HttpExchange exchange : this._exchanges) {
                exchange.cancel();
            }
        }
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TransportListener listener, Message.Mutable ... messages) {
        Object url;
        TransportExchange httpExchange = new TransportExchange(listener, (Message[])messages);
        httpExchange.setMethod("POST");
        httpExchange.setURL(this._uri.toString());
        if (this._appendMessageType && messages.length == 1 && messages[0].isMeta()) {
            String type = messages[0].getChannel().substring("/meta".length());
            url = this._uri.toString();
            if (((String)url).endsWith("/")) {
                url = ((String)url).substring(0, ((String)url).length() - 1);
            }
            url = (String)url + type;
            httpExchange.setURL((String)url);
        }
        String content = JSON.toString((Object[])messages);
        httpExchange.setRequestContentType("application/json;charset=UTF-8");
        try {
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
            if (this._bayeuxClient != null) {
                this._bayeuxClient.customize((HttpExchange)httpExchange);
            }
            url = this;
            synchronized (url) {
                if (this._aborted) {
                    throw new IllegalStateException("Aborted");
                }
                this._exchanges.add((HttpExchange)httpExchange);
            }
            this._httpClient.send((HttpExchange)httpExchange);
        }
        catch (Exception x) {
            listener.onException(x);
        }
    }

    private class TransportExchange
    extends ContentExchange {
        private final TransportListener _listener;
        private final Message[] _messages;

        private TransportExchange(TransportListener listener, Message ... messages) {
            super(true);
            this._listener = listener;
            this._messages = messages;
        }

        protected void onRequestCommitted() throws IOException {
            this._listener.onSending(this._messages);
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            int headerName = HttpHeaders.CACHE.getOrdinal(name);
            if (headerName == 53) {
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tokenizer.setSingle(false);
                String cookieName = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieName = tokenizer.nextToken();
                }
                String cookieValue = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieValue = tokenizer.nextToken();
                }
                int maxAge = -1;
                if (cookieName != null && cookieValue != null) {
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if ("Expires".equalsIgnoreCase(token)) {
                            try {
                                Date date = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss 'GMT'").parse(tokenizer.nextToken());
                                Long maxAgeValue = TimeUnit.MILLISECONDS.toSeconds(date.getTime() - System.currentTimeMillis());
                                maxAge = maxAgeValue > 0L ? maxAgeValue.intValue() : 0;
                            }
                            catch (ParseException ignored) {}
                            continue;
                        }
                        if (!"Max-Age".equalsIgnoreCase(token)) continue;
                        try {
                            maxAge = Integer.parseInt(tokenizer.nextToken());
                        }
                        catch (NumberFormatException ignored) {}
                    }
                    LongPollingTransport.this._bayeuxClient.setCookie(cookieName, cookieValue, maxAge);
                }
            }
        }

        protected void onResponseComplete() throws IOException {
            this.complete();
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content != null && content.length() > 0) {
                    List<Message.Mutable> messages = LongPollingTransport.this.toMessages(this.getResponseContent());
                    this._listener.onMessages(messages);
                } else {
                    this._listener.onProtocolError("Empty response: " + (Object)((Object)this));
                }
            } else {
                this._listener.onProtocolError("Unexpected response " + this.getResponseStatus() + ": " + (Object)((Object)this));
            }
        }

        protected void onConnectionFailed(Throwable x) {
            this.complete();
            this._listener.onConnectException(x);
        }

        protected void onException(Throwable x) {
            this.complete();
            this._listener.onException(x);
        }

        protected void onExpire() {
            this.complete();
            this._listener.onExpire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() {
            LongPollingTransport longPollingTransport = LongPollingTransport.this;
            synchronized (longPollingTransport) {
                LongPollingTransport.this._exchanges.remove((Object)this);
            }
        }
    }
}

