/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.HashMapMessage;
import org.cometd.common.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux {
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    protected final Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Integer.toHexString(System.identityHashCode((Object)this))));
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final AtomicReference<BayeuxClientState> bayeuxClientState = new AtomicReference();
    private final List<Message.Mutable> messageQueue = new ArrayList<Message.Mutable>(32);
    private final CookieStore cookieStore = new CookieManager().getCookieStore();
    private final TransportListener handshakeListener = new HandshakeTransportListener();
    private final TransportListener connectListener = new ConnectTransportListener();
    private final TransportListener disconnectListener = new DisconnectTransportListener();
    private final TransportListener publishListener = new PublishTransportListener();
    private final String url;
    private volatile ScheduledExecutorService scheduler;
    private volatile boolean shutdownScheduler;
    private volatile long backoffIncrement;
    private volatile long maxBackoff;
    private int stateUpdaters;

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        this.url = Objects.requireNonNull(url);
        this.scheduler = scheduler;
        transport = Objects.requireNonNull(transport);
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
        for (String transportName : this.transportRegistry.getKnownTransports()) {
            ClientTransport clientTransport = this.transportRegistry.getTransport(transportName);
            if (clientTransport instanceof MessageClientTransport) {
                ((MessageClientTransport)((Object)clientTransport)).setMessageTransportListener(this.publishListener);
            }
            if (!(clientTransport instanceof HttpClientTransport)) continue;
            HttpClientTransport httpTransport = (HttpClientTransport)clientTransport;
            httpTransport.setURL(url);
            httpTransport.setCookieStore(this.cookieStore);
        }
        this.bayeuxClientState.set(new DisconnectedState(null));
    }

    public String getURL() {
        return this.url;
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpCookie getCookie(String name) {
        for (HttpCookie cookie : this.getCookieStore().get(URI.create(this.getURL()))) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void putCookie(HttpCookie cookie) {
        URI uri = URI.create(this.getURL());
        if (cookie.getPath() == null) {
            String path = uri.getPath();
            path = path == null || !path.contains("/") ? "/" : path.substring(0, path.lastIndexOf("/") + 1);
            cookie.setPath(path);
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(uri.getHost());
        }
        this.getCookieStore().add(uri, cookie);
    }

    public String getId() {
        return this.bayeuxClientState.get().clientId;
    }

    public boolean isHandshook() {
        return this.isHandshook(this.bayeuxClientState.get());
    }

    private boolean isHandshook(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.CONNECTING || bayeuxClientState.type == State.CONNECTED || bayeuxClientState.type == State.UNCONNECTED;
    }

    private boolean isHandshaking(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.HANDSHAKING || bayeuxClientState.type == State.REHANDSHAKING;
    }

    private boolean isConnecting(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.CONNECTING;
    }

    public boolean isConnected() {
        return this.isConnected(this.bayeuxClientState.get());
    }

    private boolean isConnected(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.CONNECTED;
    }

    private boolean isDisconnecting(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.DISCONNECTING;
    }

    private boolean isDisconnected(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.DISCONNECTED;
    }

    public boolean isDisconnected() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        return this.isDisconnecting(bayeuxClientState) || this.isDisconnected(bayeuxClientState);
    }

    protected State getState() {
        return this.bayeuxClientState.get().type;
    }

    public void handshake() {
        this.handshake(null, null);
    }

    public void handshake(Map<String, Object> handshakeFields) {
        this.handshake(handshakeFields, null);
    }

    public void handshake(ClientSessionChannel.MessageListener callback) {
        this.handshake(null, callback);
    }

    public void handshake(final Map<String, Object> template, final ClientSessionChannel.MessageListener callback) {
        this.initialize();
        List<String> allowedTransports = this.getAllowedTransports();
        final ClientTransport initialTransport = this.transportRegistry.negotiate(allowedTransports.toArray(), BAYEUX_VERSION).get(0);
        this.prepareTransport(null, initialTransport);
        this.logger.debug("Using initial transport {} from {}", (Object)initialTransport.getName(), allowedTransports);
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                return new HandshakingState(template, callback, initialTransport);
            }
        });
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTING, State.CONNECTED, State.DISCONNECTED);
        return this.getState();
    }

    protected boolean sendHandshake() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        if (this.isHandshaking(bayeuxClientState)) {
            Message.Mutable message = this.newMessage();
            if (bayeuxClientState.handshakeFields != null) {
                message.putAll(bayeuxClientState.handshakeFields);
            }
            message.setChannel("/meta/handshake");
            List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
            ArrayList<String> transportNames = new ArrayList<String>(transports.size());
            for (ClientTransport transport : transports) {
                transportNames.add(transport.getName());
            }
            message.put((Object)"supportedConnectionTypes", transportNames);
            message.put((Object)"version", (Object)BAYEUX_VERSION);
            if (bayeuxClientState.callback != null) {
                message.put((Object)"org.cometd.client.callback", (Object)bayeuxClientState.callback);
            }
            this.logger.debug("Handshaking on transport {}: {}", (Object)bayeuxClientState.transport, (Object)message);
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            return bayeuxClientState.send(this.handshakeListener, messages);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State state, State ... states) {
        long start = System.nanoTime();
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(Arrays.asList(states));
        BayeuxClient bayeuxClient = this;
        synchronized (bayeuxClient) {
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            while (elapsed < waitMs) {
                if (this.stateUpdaters == 0) {
                    State currentState = this.getState();
                    for (State s : waitForStates) {
                        if (!currentState.implies(s)) continue;
                        return true;
                    }
                }
                try {
                    ((Object)((Object)this)).wait(waitMs - elapsed);
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                    break;
                }
                elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            }
            return false;
        }
    }

    protected boolean sendConnect() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        if (this.isHandshook(bayeuxClientState)) {
            Message.Mutable message = this.newMessage();
            message.setChannel("/meta/connect");
            message.put((Object)"connectionType", (Object)bayeuxClientState.transport.getName());
            if (this.isConnecting(bayeuxClientState) || bayeuxClientState.type == State.UNCONNECTED) {
                message.getAdvice(true).put("timeout", 0);
            }
            this.logger.debug("Connecting, transport {}", (Object)bayeuxClientState.transport);
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            return bayeuxClientState.send(this.connectListener, messages);
        }
        return false;
    }

    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    protected void sendBatch() {
        List<Message.Mutable> messages;
        if (this.canSend() && !(messages = this.takeMessages()).isEmpty()) {
            this.sendMessages(messages);
        }
    }

    protected boolean sendMessages(List<Message.Mutable> messages) {
        return this.bayeuxClientState.get().send(this.publishListener, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message.Mutable> takeMessages() {
        ArrayList<Message.Mutable> messages;
        List<Message.Mutable> list = this.messageQueue;
        synchronized (list) {
            messages = new ArrayList<Message.Mutable>(this.messageQueue);
            this.messageQueue.clear();
        }
        return messages;
    }

    public void disconnect() {
        this.disconnect(null);
    }

    public void disconnect(final ClientSessionChannel.MessageListener callback) {
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                if (BayeuxClient.this.isConnecting(oldState) || BayeuxClient.this.isConnected(oldState)) {
                    return new DisconnectingState(callback, oldState.transport, oldState.clientId);
                }
                if (BayeuxClient.this.isDisconnecting(oldState)) {
                    return new DisconnectingState(callback, oldState.transport, oldState.clientId);
                }
                return new DisconnectedState(oldState.transport);
            }
        });
    }

    public boolean disconnect(long timeout) {
        if (this.isDisconnected(this.bayeuxClientState.get())) {
            return true;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        ClientSessionChannel.MessageListener lastConnectListener = new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Map advice = message.getAdvice();
                if (!message.isSuccessful() || advice != null && "none".equals(advice.get("reconnect"))) {
                    latch.countDown();
                }
            }
        };
        this.getChannel("/meta/connect").addListener((ClientSessionChannel.ClientSessionChannelListener)lastConnectListener);
        this.disconnect();
        boolean disconnected = this.waitFor(timeout, State.DISCONNECTED, new State[0]);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.getChannel("/meta/connect").removeListener((ClientSessionChannel.ClientSessionChannelListener)lastConnectListener);
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                return new DisconnectedState(oldState.transport);
            }
        });
        return disconnected;
    }

    public void abort() {
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                return new AbortedState(oldState.transport);
            }
        });
    }

    protected void processHandshake(final Message.Mutable handshake) {
        this.logger.debug("Processing meta handshake {}", (Object)handshake);
        if (handshake.isSuccessful()) {
            Object field = handshake.get((Object)"supportedConnectionTypes");
            Object[] serverTransports = field instanceof List ? ((List)field).toArray() : (Object[])field;
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            if (negotiatedTransports.isEmpty()) {
                String error = "405:c" + this.getAllowedTransports() + ",s" + Arrays.toString(serverTransports) + ":no transport";
                handshake.setSuccessful(false);
                handshake.put((Object)"error", (Object)error);
                this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    @Override
                    public BayeuxClientState create(BayeuxClientState oldState) {
                        BayeuxClient.this.onTransportFailure(oldState.transport.getName(), null, (Throwable)new TransportException(null));
                        return new DisconnectedState(oldState.transport);
                    }

                    @Override
                    public void postCreate() {
                        BayeuxClient.this.receive(handshake);
                    }
                });
            } else {
                final ClientTransport newTransport = negotiatedTransports.get(0);
                this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    @Override
                    public BayeuxClientState create(BayeuxClientState oldState) {
                        String action;
                        if (newTransport != oldState.transport) {
                            BayeuxClient.this.prepareTransport(oldState.transport, newTransport);
                        }
                        if ("retry".equals(action = BayeuxClient.this.getAdviceAction(handshake.getAdvice(), "retry"))) {
                            return new ConnectingState(oldState.handshakeFields, oldState.callback, handshake.getAdvice(), newTransport, handshake.getClientId());
                        }
                        if ("none".equals(action)) {
                            return new DisconnectedState(oldState.transport);
                        }
                        return null;
                    }

                    @Override
                    public void postCreate() {
                        BayeuxClient.this.receive(handshake);
                    }
                });
            }
        } else {
            this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                @Override
                public BayeuxClientState create(BayeuxClientState oldState) {
                    String action = BayeuxClient.this.getAdviceAction(handshake.getAdvice(), "handshake");
                    if ("handshake".equals(action) || "retry".equals(action)) {
                        return new RehandshakingState(oldState.handshakeFields, oldState.callback, oldState.transport, oldState.nextBackoff());
                    }
                    if ("none".equals(action)) {
                        return new DisconnectedState(oldState.transport);
                    }
                    return null;
                }

                @Override
                public void postCreate() {
                    BayeuxClient.this.receive(handshake);
                }
            });
        }
    }

    protected void processConnect(final Message.Mutable connect) {
        this.logger.debug("Processing meta connect {}", (Object)connect);
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                Map<String, Object> advice = connect.getAdvice();
                if (advice == null) {
                    advice = oldState.advice;
                }
                String action = BayeuxClient.this.getAdviceAction(advice, "retry");
                if (connect.isSuccessful()) {
                    if ("retry".equals(action)) {
                        return new ConnectedState(oldState.handshakeFields, oldState.callback, advice, oldState.transport, oldState.clientId);
                    }
                    if ("none".equals(action)) {
                        return new DisconnectingState(null, oldState.transport, oldState.clientId);
                    }
                } else {
                    if ("handshake".equals(action)) {
                        return new RehandshakingState(oldState.handshakeFields, oldState.callback, oldState.transport, 0L);
                    }
                    if ("retry".equals(action)) {
                        return new UnconnectedState(oldState.handshakeFields, oldState.callback, advice, oldState.transport, oldState.clientId, oldState.nextBackoff());
                    }
                    if ("none".equals(action)) {
                        return new DisconnectedState(oldState.transport);
                    }
                }
                return null;
            }

            @Override
            public void postCreate() {
                BayeuxClient.this.receive(connect);
            }
        });
    }

    protected void processDisconnect(final Message.Mutable disconnect) {
        this.logger.debug("Processing meta disconnect {}", (Object)disconnect);
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            @Override
            public BayeuxClientState create(BayeuxClientState oldState) {
                return new DisconnectedState(oldState.transport);
            }

            @Override
            public void postCreate() {
                BayeuxClient.this.receive(disconnect);
            }
        });
    }

    protected void processMessage(Message.Mutable message) {
        this.logger.debug("Processing message {}", (Object)message);
        this.receive(message);
    }

    private String getAdviceAction(Map<String, Object> advice, String defaultResult) {
        String action = defaultResult;
        if (advice != null && advice.containsKey("reconnect")) {
            action = (String)advice.get("reconnect");
        }
        return action;
    }

    protected boolean scheduleHandshake(long interval, long backoff) {
        return this.scheduleAction(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sendHandshake();
            }
        }, interval, backoff);
    }

    protected boolean scheduleConnect(long interval, long backoff) {
        return this.scheduleAction(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sendConnect();
            }
        }, interval, backoff);
    }

    private boolean scheduleAction(Runnable action, long interval, long backoff) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.trace("", (Throwable)x);
            }
        }
        this.logger.debug("Could not schedule action {} to scheduler {}", (Object)action, (Object)scheduler);
        return false;
    }

    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    public ClientTransport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    public ClientTransport getTransport() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        return bayeuxClientState == null ? null : bayeuxClientState.transport;
    }

    protected void initialize() {
        long maxBackoff;
        long backoffIncrement;
        Number value = (Number)this.getOption(BACKOFF_INCREMENT_OPTION);
        long l = backoffIncrement = value == null ? -1L : value.longValue();
        if (backoffIncrement < 0L) {
            backoffIncrement = 1000L;
        }
        this.backoffIncrement = backoffIncrement;
        value = (Number)this.getOption(MAX_BACKOFF_OPTION);
        long l2 = maxBackoff = value == null ? -1L : value.longValue();
        if (maxBackoff <= 0L) {
            maxBackoff = 30000L;
        }
        this.maxBackoff = maxBackoff;
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.shutdownScheduler = true;
        }
    }

    protected void terminate() {
        List<Message.Mutable> messages = this.takeMessages();
        this.failMessages(null, messages);
        this.cookieStore.removeAll();
        if (this.shutdownScheduler) {
            this.shutdownScheduler = false;
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
        for (String name : this.transportRegistry.getKnownTransports()) {
            ClientTransport transport = this.transportRegistry.getTransport(name);
            transport.setOption(qualifiedName, value);
        }
    }

    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    protected Message.Mutable newMessage() {
        return new HashMapMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueSend(Message.Mutable message) {
        if (this.canSend()) {
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            boolean sent = this.sendMessages(messages);
            this.logger.debug("{} message {}", (Object)(sent ? "Sent" : "Failed"), (Object)message);
        } else {
            List<Message.Mutable> list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(message);
            }
            this.logger.debug("Enqueued message {} (batching: {})", (Object)message, (Object)this.isBatching());
        }
    }

    private boolean canSend() {
        return !this.isBatching() && !this.isHandshaking(this.bayeuxClientState.get());
    }

    protected void failMessages(Throwable x, List<? extends Message> messages) {
        for (Message message : messages) {
            this.failMessage(message, x);
        }
    }

    protected void failMessage(Message message, Throwable x) {
        Map fields;
        Message.Mutable failed = this.newMessage();
        failed.setId(message.getId());
        failed.setSuccessful(false);
        failed.setChannel(message.getChannel());
        failed.put((Object)"subscription", message.get((Object)"subscription"));
        failed.put((Object)"org.cometd.client.callback", message.remove((Object)"org.cometd.client.callback"));
        HashMap<String, Object> failure = new HashMap<String, Object>();
        failed.put((Object)"failure", failure);
        failure.put("message", message);
        if (x != null) {
            failure.put("exception", x);
        }
        if (x instanceof TransportException && (fields = ((TransportException)x).getFields()) != null) {
            failure.putAll(fields);
        }
        failure.put("connectionType", this.getTransport().getName());
        this.receive(failed);
    }

    protected void notifyListeners(Message.Mutable message) {
        ClientSessionChannel.MessageListener callback = (ClientSessionChannel.MessageListener)message.remove((Object)"org.cometd.client.callback");
        if (message.isMeta() || message.isPublishReply()) {
            String messageId = message.getId();
            ClientSessionChannel.MessageListener messageListener = callback = messageId == null ? callback : this.unregisterCallback(messageId);
            if (callback != null) {
                this.notifyListener(callback, message);
            }
        }
        super.notifyListeners(message);
    }

    public void onSending(List<? extends Message> messages) {
    }

    public void onMessages(List<Message.Mutable> messages) {
    }

    public void onFailure(Throwable failure, List<? extends Message> messages) {
        this.logger.debug("Messages failed " + messages, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBayeuxClientState(BayeuxClientStateUpdater updater) {
        BayeuxClient bayeuxClient = this;
        synchronized (bayeuxClient) {
            ++this.stateUpdaters;
        }
        try {
            BayeuxClientState newState = null;
            BayeuxClientState oldState = this.bayeuxClientState.get();
            boolean updated = false;
            while (!updated) {
                newState = updater.create(oldState);
                if (newState == null) {
                    throw new IllegalStateException();
                }
                if (!oldState.isUpdateableTo(newState)) {
                    this.logger.debug("State not updateable: {} -> {}", (Object)oldState, (Object)newState);
                    break;
                }
                updated = this.bayeuxClientState.compareAndSet(oldState, newState);
                this.logger.debug("State update: {} -> {}{}", new Object[]{oldState, newState, updated ? "" : " failed (concurrent update)"});
                if (updated) continue;
                oldState = this.bayeuxClientState.get();
            }
            updater.postCreate();
            if (updated) {
                if (!oldState.getType().equals((Object)newState.getType())) {
                    newState.enter(oldState.getType());
                }
                newState.execute();
            }
        }
        finally {
            bayeuxClient = this;
            synchronized (bayeuxClient) {
                --this.stateUpdaters;
                if (this.stateUpdaters == 0) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        this.dump(b, "");
        return b.toString();
    }

    private void prepareTransport(ClientTransport oldTransport, ClientTransport newTransport) {
        if (oldTransport != null) {
            oldTransport.terminate();
        }
        newTransport.init();
    }

    protected void onTransportFailure(String oldTransportName, String newTransportName, Throwable failure) {
    }

    private class DisconnectingState
    extends BayeuxClientState {
        private DisconnectingState(ClientSessionChannel.MessageListener callback, ClientTransport transport, String clientId) {
            super(State.DISCONNECTING, null, callback, null, transport, clientId, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/disconnect");
            if (this.callback != null) {
                message.put((Object)"org.cometd.client.callback", (Object)this.callback);
            }
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            this.send(BayeuxClient.this.disconnectListener, messages);
        }
    }

    private class UnconnectedState
    extends BayeuxClientState {
        private UnconnectedState(Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, Map<String, Object> advice, ClientTransport transport, String clientId, long backoff) {
            super(State.UNCONNECTED, handshakeFields, callback, advice, transport, clientId, backoff);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    private class ConnectedState
    extends BayeuxClientState {
        private ConnectedState(Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, Map<String, Object> advice, ClientTransport transport, String clientId) {
            super(State.CONNECTED, handshakeFields, callback, advice, transport, clientId, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    private class ConnectingState
    extends BayeuxClientState {
        private ConnectingState(Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, Map<String, Object> advice, ClientTransport transport, String clientId) {
            super(State.CONNECTING, handshakeFields, callback, advice, transport, clientId, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.sendBatch();
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    private class RehandshakingState
    extends BayeuxClientState {
        public RehandshakingState(Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, ClientTransport transport, long backoff) {
            super(State.REHANDSHAKING, handshakeFields, callback, null, transport, null, backoff);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTING || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void enter(State oldState) {
            if (oldState != State.HANDSHAKING) {
                BayeuxClient.this.resetSubscriptions();
            }
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleHandshake(this.getInterval(), this.backoff);
        }
    }

    private class HandshakingState
    extends BayeuxClientState {
        private HandshakingState(Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, ClientTransport transport) {
            super(State.HANDSHAKING, handshakeFields, callback, null, transport, null, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTING || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void enter(State oldState) {
            BayeuxClient.this.resetSubscriptions();
        }

        @Override
        protected void execute() {
            BayeuxClient.this.sendHandshake();
        }
    }

    private class AbortedState
    extends DisconnectedState {
        private AbortedState(ClientTransport transport) {
            super(transport);
        }

        @Override
        protected void execute() {
            this.transport.abort();
            BayeuxClient.this.terminate();
        }
    }

    private class DisconnectedState
    extends BayeuxClientState {
        private DisconnectedState(ClientTransport transport) {
            super(State.DISCONNECTED, null, null, null, transport, null, 0L);
        }

        @Override
        protected boolean transportSend(TransportListener listener, List<Message.Mutable> messages) {
            BayeuxClient.this.failMessages((Throwable)new TransportException(null), messages);
            return false;
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.HANDSHAKING;
        }

        @Override
        protected void execute() {
            this.transport.terminate();
            BayeuxClient.this.terminate();
        }
    }

    private abstract class BayeuxClientState {
        protected final State type;
        protected final Map<String, Object> handshakeFields;
        protected final ClientSessionChannel.MessageListener callback;
        protected final Map<String, Object> advice;
        protected final ClientTransport transport;
        protected final String clientId;
        protected final long backoff;

        private BayeuxClientState(State type, Map<String, Object> handshakeFields, ClientSessionChannel.MessageListener callback, Map<String, Object> advice, ClientTransport transport, String clientId, long backoff) {
            this.type = type;
            this.handshakeFields = handshakeFields;
            this.callback = callback;
            this.advice = advice;
            this.transport = transport;
            this.clientId = clientId;
            this.backoff = backoff;
        }

        protected long getInterval() {
            long result = 0L;
            if (this.advice != null && this.advice.containsKey("interval")) {
                result = ((Number)this.advice.get("interval")).longValue();
            }
            return result;
        }

        protected boolean send(TransportListener listener, List<Message.Mutable> messages) {
            Iterator<Message.Mutable> iterator = messages.iterator();
            while (iterator.hasNext()) {
                Message.Mutable message = iterator.next();
                String messageId = BayeuxClient.this.newMessageId();
                message.setId(messageId);
                if (this.clientId != null) {
                    message.setClientId(this.clientId);
                }
                ClientSessionChannel.MessageListener subscriber = (ClientSessionChannel.MessageListener)message.remove((Object)"org.cometd.client.subscriber");
                ClientSessionChannel.MessageListener callback = (ClientSessionChannel.MessageListener)message.remove((Object)"org.cometd.client.callback");
                if (BayeuxClient.this.extendSend(message)) {
                    message.setId(messageId);
                    BayeuxClient.this.registerSubscriber(messageId, subscriber);
                    BayeuxClient.this.registerCallback(messageId, callback);
                    continue;
                }
                iterator.remove();
            }
            if (messages.isEmpty()) {
                return false;
            }
            BayeuxClient.this.logger.debug("Sending messages {}", messages);
            return this.transportSend(listener, messages);
        }

        protected boolean transportSend(TransportListener listener, List<Message.Mutable> messages) {
            this.transport.send(listener, messages);
            return true;
        }

        private long nextBackoff() {
            return Math.min(this.backoff + BayeuxClient.this.getBackoffIncrement(), BayeuxClient.this.getMaxBackoff());
        }

        protected abstract boolean isUpdateableTo(BayeuxClientState var1);

        protected void enter(State oldState) {
        }

        protected abstract void execute();

        public State getType() {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private abstract class BayeuxClientStateUpdater {
        private BayeuxClientStateUpdater() {
        }

        public abstract BayeuxClientState create(BayeuxClientState var1);

        public void postCreate() {
        }
    }

    protected class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected BayeuxClientChannel(ChannelId channelId) {
            super((AbstractClientSession)BayeuxClient.this, channelId);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return BayeuxClient.this;
        }

        public void publish(Object data, ClientSessionChannel.MessageListener callback) {
            this.throwIfReleased();
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel(this.getId());
            message.setData(data);
            if (callback != null) {
                message.put((Object)"org.cometd.client.callback", (Object)callback);
            }
            BayeuxClient.this.enqueueSend(message);
        }

        protected void sendSubscribe(ClientSessionChannel.MessageListener listener, ClientSessionChannel.MessageListener callback) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this.getId());
            if (listener != null) {
                message.put((Object)"org.cometd.client.subscriber", (Object)listener);
            }
            if (callback != null) {
                message.put((Object)"org.cometd.client.callback", (Object)callback);
            }
            BayeuxClient.this.enqueueSend(message);
        }

        protected void sendUnSubscribe(ClientSessionChannel.MessageListener callback) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this.getId());
            if (callback != null) {
                message.put((Object)"org.cometd.client.callback", (Object)callback);
            }
            BayeuxClient.this.enqueueSend(message);
        }
    }

    private class DisconnectTransportListener
    extends PublishTransportListener {
        private DisconnectTransportListener() {
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                @Override
                public BayeuxClientState create(BayeuxClientState oldState) {
                    return new DisconnectedState(oldState.transport);
                }
            });
            super.onFailure(failure, messages);
        }

        @Override
        protected void processMessage(Message.Mutable message) {
            if ("/meta/disconnect".equals(message.getChannel())) {
                BayeuxClient.this.processDisconnect(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    private class ConnectTransportListener
    extends PublishTransportListener {
        private ConnectTransportListener() {
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                @Override
                public BayeuxClientState create(BayeuxClientState oldState) {
                    return new UnconnectedState(oldState.handshakeFields, oldState.callback, oldState.advice, oldState.transport, oldState.clientId, oldState.nextBackoff());
                }
            });
            super.onFailure(failure, messages);
        }

        @Override
        protected void processMessage(Message.Mutable message) {
            if ("/meta/connect".equals(message.getChannel())) {
                BayeuxClient.this.processConnect(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    private class HandshakeTransportListener
    extends PublishTransportListener {
        private HandshakeTransportListener() {
        }

        @Override
        public void onFailure(final Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.logger.debug("Handshake failed: " + messages, failure);
            List<ClientTransport> transports = BayeuxClient.this.transportRegistry.negotiate(BayeuxClient.this.getAllowedTransports().toArray(), BayeuxClient.BAYEUX_VERSION);
            if (transports.isEmpty()) {
                BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    @Override
                    public BayeuxClientState create(BayeuxClientState oldState) {
                        BayeuxClient.this.onTransportFailure(oldState.transport.getName(), null, failure);
                        return new DisconnectedState(oldState.transport);
                    }
                });
            } else {
                final ClientTransport newTransport = transports.get(0);
                BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    @Override
                    public BayeuxClientState create(BayeuxClientState oldState) {
                        if (newTransport != oldState.transport) {
                            BayeuxClient.this.prepareTransport(oldState.transport, newTransport);
                        }
                        BayeuxClient.this.onTransportFailure(oldState.transport.getName(), newTransport.getName(), failure);
                        return new RehandshakingState(oldState.handshakeFields, oldState.callback, newTransport, oldState.nextBackoff());
                    }
                });
            }
            super.onFailure(failure, messages);
        }

        @Override
        protected void processMessage(Message.Mutable message) {
            if ("/meta/handshake".equals(message.getChannel())) {
                BayeuxClient.this.processHandshake(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    private class PublishTransportListener
    implements TransportListener {
        private PublishTransportListener() {
        }

        @Override
        public void onSending(List<? extends Message> messages) {
            BayeuxClient.this.onSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            for (Message.Mutable message : messages) {
                this.processMessage(message);
            }
        }

        protected void processMessage(Message.Mutable message) {
            BayeuxClient.this.processMessage(message);
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.onFailure(failure, messages);
            BayeuxClient.this.failMessages(failure, messages);
        }
    }

    public static enum State {
        UNCONNECTED(new State[0]),
        HANDSHAKING(new State[0]),
        REHANDSHAKING(new State[0]),
        CONNECTING(HANDSHAKING),
        CONNECTED(HANDSHAKING, CONNECTING),
        DISCONNECTING(new State[0]),
        DISCONNECTED(DISCONNECTING);

        private final State[] implieds;

        private State(State ... implieds) {
            this.implieds = implieds;
        }

        private boolean implies(State state) {
            if (state == this) {
                return true;
            }
            for (State implied : this.implieds) {
                if (state != implied) continue;
                return true;
            }
            return false;
        }
    }
}

