/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.cometd.client.transport.ClientTransport;

public abstract class HttpClientTransport
extends ClientTransport {
    private volatile CookieStore cookieStore;

    protected HttpClientTransport(String name, String url, Map<String, Object> options) {
        super(name, url, options);
    }

    protected CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    protected List<HttpCookie> getCookies(URI uri) {
        return this.getCookieStore().get(uri);
    }

    protected void storeCookies(URI uri, Map<String, List<String>> cookies) {
        block2: {
            try {
                CookieManager cookieManager = new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
                cookieManager.put(uri, cookies);
            }
            catch (IOException x) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Could not parse cookies", (Throwable)x);
            }
        }
    }
}

