/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;

public class OortServlet
implements Servlet {
    private ServletConfig _config;

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getServletInfo() {
        return OortServlet.class.toString();
    }

    public void init(ServletConfig config) throws ServletException {
        String cloud;
        System.err.println("INIT " + config);
        this._config = config;
        BayeuxServer bayeux = (BayeuxServer)config.getServletContext().getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            this._config.getServletContext().log("No org.cometd.bayeux initialized");
            throw new UnavailableException("org.cometd.bayeux");
        }
        String url = this._config.getInitParameter("oort.url");
        if (url == null) {
            this._config.getServletContext().log("No oort.url init parameter");
            throw new UnavailableException("oort.url");
        }
        Oort oort = new Oort(url, bayeux);
        this._config.getServletContext().setAttribute("org.cometd.oort.Oort", (Object)oort);
        String channels = this._config.getInitParameter("oort.channels");
        if (channels != null) {
            String[] patterns;
            for (String channel : patterns = channels.split("[, ]")) {
                oort.observeChannel(channel);
            }
        }
        if ((cloud = this._config.getInitParameter("oort.cloud")) != null && cloud.length() > 0) {
            String[] urls;
            for (String comet : urls = cloud.split("[, ]")) {
                if (comet.length() <= 0) continue;
                oort.observeComet(comet);
            }
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        response.sendError(503);
    }
}

