/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.client.BayeuxClient;
import org.cometd.common.HashMapMessage;
import org.cometd.oort.OortComet;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oort
extends AbstractLifeCycle {
    public static final String OORT_ATTRIBUTE = Oort.class.getName();
    public static final String EXT_OORT_FIELD = "org.cometd.oort";
    public static final String EXT_OORT_URL_FIELD = "oortURL";
    public static final String EXT_OORT_SECRET_FIELD = "oortSecret";
    public static final String EXT_COMET_URL_FIELD = "cometURL";
    public static final String OORT_CLOUD_CHANNEL = "/oort/cloud";
    private static final String COMET_URL_ATTRIBUTE = "org.cometd.oort.cometURL";
    private final ConcurrentMap<String, OortComet> _knownComets = new ConcurrentHashMap<String, OortComet>();
    private final Map<String, ServerSession> _incomingComets = new ConcurrentHashMap<String, ServerSession>();
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private final BayeuxServer.Extension _oortExtension = new OortExtension();
    private ServerChannel.MessageListener _cloudListener = new CloudListener();
    private final BayeuxServer _bayeux;
    private final String _url;
    private final Logger _logger;
    private final String _secret;
    private final HttpClient _httpClient;
    private final LocalSession _oortSession;
    private boolean _clientDebugEnabled;

    public Oort(BayeuxServer bayeux, String url) {
        this._bayeux = bayeux;
        this._url = url;
        this._logger = Log.getLogger((String)(((Object)((Object)this)).getClass().getName() + "-" + this._url));
        this._logger.setDebugEnabled(String.valueOf(3).equals(bayeux.getOption("logLevel")));
        this._secret = Long.toHexString(new SecureRandom().nextLong());
        this._httpClient = new HttpClient();
        this._oortSession = bayeux.newLocalSession("oort");
    }

    protected void doStart() throws Exception {
        this._httpClient.start();
        this._bayeux.addExtension(this._oortExtension);
        this._bayeux.createIfAbsent(OORT_CLOUD_CHANNEL, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
                Oort.this._cloudListener = new CloudListener();
                channel.addListener((ServerChannel.ServerChannelListener)Oort.this._cloudListener);
            }
        }});
        this._oortSession.handshake();
    }

    protected void doStop() throws Exception {
        this._oortSession.disconnect();
        for (OortComet comet : this._knownComets.values()) {
            comet.disconnect();
            comet.waitFor(1000L, BayeuxClient.State.DISCONNECTED, new BayeuxClient.State[0]);
        }
        this._knownComets.clear();
        this._incomingComets.clear();
        this._channels.clear();
        ServerChannel oortCloudChannel = this._bayeux.getChannel(OORT_CLOUD_CHANNEL);
        if (oortCloudChannel != null) {
            oortCloudChannel.removeListener((ServerChannel.ServerChannelListener)this._cloudListener);
            oortCloudChannel.removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        }
        this._bayeux.removeExtension(this._oortExtension);
        this._httpClient.stop();
    }

    public BayeuxServer getBayeuxServer() {
        return this._bayeux;
    }

    public String getURL() {
        return this._url;
    }

    public String getSecret() {
        return this._secret;
    }

    public boolean isClientDebugEnabled() {
        return this._clientDebugEnabled;
    }

    public void setClientDebugEnabled(boolean clientDebugEnabled) {
        this._clientDebugEnabled = clientDebugEnabled;
        for (OortComet comet : this._knownComets.values()) {
            comet.setDebugEnabled(clientDebugEnabled);
        }
    }

    public OortComet observeComet(String cometURL) {
        try {
            URI uri = new URI(cometURL);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Missing protocol in comet URL " + cometURL);
            }
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Missing host in comet URL " + cometURL);
            }
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = new OortComet(this, cometURL);
        OortComet existing = this._knownComets.putIfAbsent(cometURL, comet);
        if (existing != null) {
            return existing;
        }
        this._logger.debug("Connecting to comet {}", new Object[]{cometURL});
        Message.Mutable fields = (Message.Mutable)HashMapMessage.parseMessages((String)("{    \"ext\": {        \"org.cometd.oort\": {            \"oortURL\": \"" + this.getURL() + "\"," + "            \"" + EXT_OORT_SECRET_FIELD + "\": \"" + this.getSecret() + "\"," + "            \"" + EXT_COMET_URL_FIELD + "\": \"" + cometURL + "\"" + "        }" + "    }" + "}")).get(0);
        comet.handshake((Map)fields);
        return comet;
    }

    public OortComet deobserveComet(String cometURL) {
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = (OortComet)((Object)this._knownComets.remove(cometURL));
        if (comet != null) {
            this._logger.debug("Disconnecting from comet {}", new Object[]{cometURL});
            comet.disconnect();
        }
        return comet;
    }

    protected void cometsJoined(Set<String> comets) {
        for (String comet : comets) {
            if (this._url.equals(comet) || this._knownComets.containsKey(comet)) continue;
            this.observeComet(comet);
        }
    }

    public Set<String> getKnownComets() {
        return new HashSet<String>(this._knownComets.keySet());
    }

    public OortComet getComet(String cometURL) {
        return (OortComet)((Object)this._knownComets.get(cometURL));
    }

    public void observeChannel(String channelName) {
        ChannelId channelId = new ChannelId(channelName);
        if (channelId.isMeta() || channelId.isService()) {
            throw new IllegalArgumentException("Channel " + channelName + " cannot be observed because is not a broadcast channel");
        }
        if (this._channels.putIfAbsent(channelName, Boolean.TRUE) == null) {
            Set<String> observedChannels = this.getObservedChannels();
            for (OortComet comet : this._knownComets.values()) {
                comet.subscribe(observedChannels);
            }
        }
    }

    public void deobserveChannel(String channelId) {
        if (this._channels.remove(channelId) != null) {
            for (OortComet comet : this._knownComets.values()) {
                comet.unsubscribe(channelId);
            }
        }
    }

    public boolean isOort(ServerSession session) {
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        if (this._incomingComets.containsKey(id)) {
            return true;
        }
        for (OortComet oc : this._knownComets.values()) {
            if (!id.equals(oc.getId())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._url;
    }

    protected void incomingCometHandshake(String cometURL, String cometSecret, ServerSession session) {
        this._logger.debug("Incoming comet handshake from comet {} with {}", new Object[]{cometURL, session.getId()});
        if (!this._knownComets.containsKey(cometURL)) {
            this._logger.debug("Comet {} is unknown, establishing connection", new Object[]{cometURL});
            this.observeComet(cometURL);
        } else {
            this._logger.debug("Comet {} is already known", new Object[]{cometURL});
        }
        session.setAttribute(COMET_URL_ATTRIBUTE, (Object)cometURL);
        this._incomingComets.put(session.getId(), session);
        session.addListener((ServerSession.ServerSessionListener)new OortCometDisconnectListener(cometURL));
        session.addListener((ServerSession.ServerSessionListener)new OortCometLoopListener());
    }

    protected void joinComets(String cometURL, Message message) {
        Object[] array = (Object[])message.getData();
        HashSet<String> comets = new HashSet<String>();
        for (Object o : array) {
            comets.add(o.toString());
        }
        this._logger.debug("Received comets {} from {}", new Object[]{comets, cometURL});
        this.cometsJoined(comets);
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public Set<String> getObservedChannels() {
        return new HashSet<String>(this._channels.keySet());
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    private class OortCometLoopListener
    implements ServerSession.MessageListener {
        private OortCometLoopListener() {
        }

        public boolean onMessage(ServerSession to, ServerSession from, ServerMessage message) {
            if (to.getId().equals(from.getId()) || Oort.this.isOort(from)) {
                Oort.this._logger.debug("{} --| {} {}", new Object[]{from, to, message});
                return false;
            }
            Oort.this._logger.debug("{} --> {} {}", new Object[]{from, to, message});
            return true;
        }
    }

    private class OortCometDisconnectListener
    implements ServerSession.RemoveListener {
        private final String cometURL;

        public OortCometDisconnectListener(String cometURL) {
            this.cometURL = cometURL;
        }

        public void removed(ServerSession session, boolean timeout) {
            ServerSession removed = (ServerSession)Oort.this._incomingComets.remove(session.getId());
            if (removed != null) {
                Oort.this._logger.info("Disconnected from comet {} with session {}", new Object[]{this.cometURL, removed});
                OortComet oortComet = (OortComet)((Object)Oort.this._knownComets.remove(this.cometURL));
                if (oortComet != null) {
                    oortComet.disconnect();
                }
            }
        }
    }

    protected class CloudListener
    implements ServerChannel.MessageListener {
        protected CloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable msg) {
            if (!from.isLocalSession()) {
                String cometURL = (String)from.getAttribute(Oort.COMET_URL_ATTRIBUTE);
                Oort.this.joinComets(cometURL, (Message)msg);
            }
            return true;
        }
    }

    protected class OortExtension
    implements BayeuxServer.Extension {
        protected OortExtension() {
        }

        public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
            return true;
        }

        public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
            Map oortExtensionIn;
            Map extensionIn;
            if (to != null && "/meta/handshake".equals(message.getChannel()) && message.isSuccessful() && (extensionIn = message.getAssociated().getExt()) != null && (oortExtensionIn = (Map)extensionIn.get(Oort.EXT_OORT_FIELD)) != null) {
                String cometURL = (String)oortExtensionIn.get(Oort.EXT_COMET_URL_FIELD);
                if (Oort.this.getURL().equals(cometURL)) {
                    String remoteOortURL = (String)oortExtensionIn.get(Oort.EXT_OORT_URL_FIELD);
                    String remoteOortSecret = (String)oortExtensionIn.get(Oort.EXT_OORT_SECRET_FIELD);
                    Oort.this.incomingCometHandshake(remoteOortURL, remoteOortSecret, to);
                    HashMap<String, String> oortExtensionOut = new HashMap<String, String>();
                    oortExtensionOut.put(Oort.EXT_OORT_SECRET_FIELD, Oort.this.getSecret());
                    Map extensionOut = message.getExt(true);
                    extensionOut.put(Oort.EXT_OORT_FIELD, oortExtensionOut);
                }
            }
            return true;
        }
    }
}

