/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;
import org.cometd.oort.OortContainer;
import org.cometd.oort.OortObject;

public abstract class OortMap<K, V>
extends OortContainer<ConcurrentMap<K, V>> {
    private static final String TYPE_FIELD_ENTRY_VALUE = "oort.map.entry";
    private static final String ACTION_FIELD_PUT_VALUE = "oort.map.put";
    private static final String ACTION_FIELD_PUT_ABSENT_VALUE = "oort.map.put.absent";
    private static final String ACTION_FIELD_REMOVE_VALUE = "oort.map.remove";
    private static final String KEY_FIELD = "oort.map.key";
    private static final String VALUE_FIELD = "oort.map.value";
    private final List<EntryListener<K, V>> listeners = new CopyOnWriteArrayList<EntryListener<K, V>>();

    protected OortMap(Oort oort, String name, OortObject.Factory<ConcurrentMap<K, V>> factory) {
        super(oort, name, factory);
    }

    public void addEntryListener(EntryListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public void removeEntryListeners() {
        this.listeners.clear();
    }

    public void putAndShare(K key, V value, OortObject.Result<V> callback) {
        HashMap<String, Object> entry = new HashMap<String, Object>(2);
        entry.put(KEY_FIELD, key);
        entry.put(VALUE_FIELD, value);
        OortObject.Data<Object> data = new OortObject.Data<Object>(6, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_PUT_VALUE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing map put {}", data);
        }
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data, Promise.noop());
    }

    public void putIfAbsentAndShare(K key, V value, OortObject.Result<V> callback) {
        HashMap<String, Object> entry = new HashMap<String, Object>(2);
        entry.put(KEY_FIELD, key);
        entry.put(VALUE_FIELD, value);
        OortObject.Data<Object> data = new OortObject.Data<Object>(6, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_PUT_ABSENT_VALUE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing map putIfAbsent {}", data);
        }
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data, Promise.noop());
    }

    public void removeAndShare(K key, OortObject.Result<V> callback) {
        HashMap<String, K> entry = new HashMap<String, K>(1);
        entry.put(KEY_FIELD, key);
        OortObject.Data<Object> data = new OortObject.Data<Object>(6, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_REMOVE_VALUE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing map remove {}", data);
        }
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data, Promise.noop());
    }

    public V get(K key) {
        return ((ConcurrentMap)this.getInfo(this.getOort().getURL()).getObject()).get(key);
    }

    public V find(K key) {
        for (OortObject.Info info : this) {
            Object result = ((ConcurrentMap)info.getObject()).get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public OortObject.Info<ConcurrentMap<K, V>> findInfo(K key) {
        for (OortObject.Info<ConcurrentMap<K, V>> info : this) {
            if (((ConcurrentMap)info.getObject()).get(key) == null) continue;
            return info;
        }
        return null;
    }

    @Override
    protected boolean isItemUpdate(Map<String, Object> data) {
        return TYPE_FIELD_ENTRY_VALUE.equals(data.get("oort.info.type"));
    }

    @Override
    protected void onItem(OortObject.Info<ConcurrentMap<K, V>> info, Map<String, Object> data) {
        Object result;
        String action;
        Map object = (Map)data.get("oort.info.object");
        Object key = object.get(KEY_FIELD);
        Object value = object.get(VALUE_FIELD);
        ConcurrentMap map = info.getObject();
        switch (action = (String)data.get("oort.info.action")) {
            case "oort.map.put": {
                result = map.put(key, value);
                break;
            }
            case "oort.map.put.absent": {
                result = map.putIfAbsent(key, value);
                break;
            }
            case "oort.map.remove": {
                result = map.remove(key);
                break;
            }
            default: {
                throw new IllegalArgumentException(action);
            }
        }
        info.put("oort.info.version", data.get("oort.info.version"));
        Entry entry = new Entry(key, result, value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} map {} of {}", new Object[]{info.isLocal() ? "Local" : "Remote", action, entry});
        }
        switch (action) {
            case "oort.map.put": {
                this.notifyEntryPut(info, entry);
                break;
            }
            case "oort.map.put.absent": {
                if (result != null) break;
                this.notifyEntryPut(info, entry);
                break;
            }
            case "oort.map.remove": {
                this.notifyEntryRemoved(info, entry);
            }
        }
        if (data instanceof OortObject.Data) {
            ((OortObject.Data)data).setResult(result);
        }
    }

    private void notifyEntryPut(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
        for (EntryListener<K, V> listener : this.listeners) {
            try {
                listener.onPut(info, entry);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyEntryRemoved(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> elements) {
        for (EntryListener<K, V> listener : this.listeners) {
            try {
                listener.onRemoved(info, elements);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public static class DeltaListener<K, V>
    implements OortObject.Listener<ConcurrentMap<K, V>> {
        private final OortMap<K, V> oortMap;

        public DeltaListener(OortMap<K, V> oortMap) {
            this.oortMap = oortMap;
        }

        @Override
        public void onUpdated(OortObject.Info<ConcurrentMap<K, V>> oldInfo, OortObject.Info<ConcurrentMap<K, V>> newInfo) {
            Map oldMap = oldInfo == null ? Collections.emptyMap() : (Map)oldInfo.getObject();
            HashMap newMap = new HashMap(newInfo.getObject());
            for (Map.Entry oldEntry : oldMap.entrySet()) {
                Object key = oldEntry.getKey();
                Object oldValue = oldEntry.getValue();
                Object newValue = newMap.remove(key);
                Entry entry = new Entry(key, oldValue, newValue);
                if (newValue == null) {
                    ((OortMap)this.oortMap).notifyEntryRemoved(newInfo, entry);
                    continue;
                }
                if (newValue.equals(oldValue)) continue;
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
            for (Map.Entry newEntry : newMap.entrySet()) {
                Entry entry = new Entry(newEntry.getKey(), null, newEntry.getValue());
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
        }

        @Override
        public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> info) {
            for (Map.Entry oldEntry : info.getObject().entrySet()) {
                Entry entry = new Entry(oldEntry.getKey(), oldEntry.getValue(), null);
                ((OortMap)this.oortMap).notifyEntryRemoved(info, entry);
            }
        }
    }

    public static class Entry<K, V> {
        private final K key;
        private final V oldValue;
        private final V newValue;

        protected Entry(K key, V oldValue, V newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public K getKey() {
            return this.key;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return String.format("(%s=%s->%s)", this.getKey(), this.getOldValue(), this.getNewValue());
        }
    }

    public static interface EntryListener<K, V>
    extends EventListener {
        public void onPut(OortObject.Info<ConcurrentMap<K, V>> var1, Entry<K, V> var2);

        public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> var1, Entry<K, V> var2);

        public static class Adapter<K, V>
        implements EntryListener<K, V> {
            @Override
            public void onPut(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
            }

            @Override
            public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
            }
        }
    }
}

