/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;

public class AsyncMultiDataSetIterator
implements MultiDataSetIterator {
    private final MultiDataSetIterator iterator;
    private final LinkedBlockingQueue<MultiDataSet> queue;
    private IteratorRunnable runnable;
    private Thread thread;

    public AsyncMultiDataSetIterator(MultiDataSetIterator iterator, int queueLength) {
        if (queueLength <= 0) {
            throw new IllegalArgumentException("Queue size must be > 0");
        }
        if (queueLength < 2) {
            queueLength = 2;
        }
        this.iterator = iterator;
        if (this.iterator.resetSupported()) {
            this.iterator.reset();
        }
        this.queue = new LinkedBlockingQueue(queueLength);
        this.runnable = new IteratorRunnable(iterator.hasNext());
        this.thread = new Thread(this.runnable);
        Integer deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        Nd4j.getAffinityManager().attachThreadToDevice(this.thread, deviceId);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public MultiDataSet next(int num) {
        throw new UnsupportedOperationException("Next(int) not supported for AsyncDataSetIterator");
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.iterator.setPreProcessor(preProcessor);
    }

    public boolean resetSupported() {
        return this.iterator.resetSupported();
    }

    public boolean asyncSupported() {
        return false;
    }

    public void reset() {
        if (!this.resetSupported()) {
            throw new UnsupportedOperationException("Cannot reset Async iterator wrapping iterator that does not support reset");
        }
        this.runnable.killRunnable = true;
        if (this.runnable.isAlive) {
            this.thread.interrupt();
        }
        try {
            this.runnable.runCompletedSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.queue.clear();
        this.iterator.reset();
        this.runnable = new IteratorRunnable(this.iterator.hasNext());
        this.thread = new Thread(this.runnable);
        Integer deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        Nd4j.getAffinityManager().attachThreadToDevice(this.thread, deviceId);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.runnable.isAlive) {
            return this.runnable.hasLatch();
        }
        if (!this.runnable.killRunnable && this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        return this.runnable.hasLatch();
    }

    public MultiDataSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        if (!this.queue.isEmpty()) {
            this.runnable.feeder.decrementAndGet();
            return this.queue.poll();
        }
        try {
            while (this.runnable.exception == null) {
                MultiDataSet ds = this.queue.poll(5L, TimeUnit.SECONDS);
                if (ds != null) {
                    this.runnable.feeder.decrementAndGet();
                    return ds;
                }
                if (this.runnable.killRunnable) {
                    throw new ConcurrentModificationException("Reset while next() is waiting for element?");
                }
                if (this.runnable.isAlive || !this.queue.isEmpty()) continue;
                if (this.runnable.exception != null) {
                    throw new RuntimeException("Exception thrown in base iterator", this.runnable.exception);
                }
                throw new IllegalStateException("Unexpected state occurred for AsyncMultiDataSetIterator: runnable died or no data available");
            }
            throw this.runnable.exception;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
    }

    public void shutdown() {
        if (this.thread.isAlive()) {
            this.runnable.killRunnable = true;
            this.thread.interrupt();
        }
    }

    private class IteratorRunnable
    implements Runnable {
        private volatile boolean killRunnable = false;
        private volatile boolean isAlive = true;
        private volatile RuntimeException exception;
        private Semaphore runCompletedSemaphore = new Semaphore(0);
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private AtomicLong feeder = new AtomicLong(0L);

        public IteratorRunnable(boolean hasNext) {
            this.isAlive = hasNext;
        }

        public boolean hasLatch() {
            if (this.feeder.get() > 0L || !AsyncMultiDataSetIterator.this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean result;
                this.lock.readLock().lock();
                boolean bl = result = AsyncMultiDataSetIterator.this.iterator.hasNext() || this.feeder.get() != 0L || !AsyncMultiDataSetIterator.this.queue.isEmpty();
                if (!this.isAlive) {
                    boolean bl2 = result;
                    return bl2;
                }
                while (this.isAlive) {
                    result = this.feeder.get() != 0L || !AsyncMultiDataSetIterator.this.queue.isEmpty() || AsyncMultiDataSetIterator.this.iterator.hasNext();
                    if (!result) continue;
                    boolean bl3 = true;
                    return bl3;
                }
                boolean bl4 = result;
                return bl4;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void run() {
            try {
                while (!this.killRunnable && AsyncMultiDataSetIterator.this.iterator.hasNext()) {
                    this.feeder.incrementAndGet();
                    this.lock.writeLock().lock();
                    MultiDataSet ds = (MultiDataSet)AsyncMultiDataSetIterator.this.iterator.next();
                    if (Nd4j.getExecutioner() instanceof GridExecutioner) {
                        ((GridExecutioner)Nd4j.getExecutioner()).flushQueueBlocking();
                    }
                    this.lock.writeLock().unlock();
                    AsyncMultiDataSetIterator.this.queue.put(ds);
                }
                this.isAlive = false;
            }
            catch (InterruptedException e) {
                if (this.killRunnable) {
                    return;
                }
                this.exception = new RuntimeException("Runnable interrupted unexpectedly", e);
            }
            catch (RuntimeException e) {
                this.exception = e;
                if (this.lock.writeLock().isHeldByCurrentThread()) {
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.isAlive = false;
                this.runCompletedSemaphore.release();
            }
        }
    }
}

