/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;

public abstract class BaseOutputLayer
extends FeedForwardLayer {
    protected ILossFunction lossFn;

    protected BaseOutputLayer(Builder builder) {
        super(builder);
        this.lossFn = builder.lossFn;
    }

    @Deprecated
    public LossFunctions.LossFunction getLossFunction() {
        if (this.lossFn instanceof LossNegativeLogLikelihood) {
            return LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD;
        }
        if (this.lossFn instanceof LossMCXENT) {
            return LossFunctions.LossFunction.MCXENT;
        }
        if (this.lossFn instanceof LossMSE) {
            return LossFunctions.LossFunction.MSE;
        }
        if (this.lossFn instanceof LossBinaryXENT) {
            return LossFunctions.LossFunction.XENT;
        }
        return null;
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    public BaseOutputLayer() {
    }

    @Override
    public String toString() {
        return "BaseOutputLayer(super=" + super.toString() + ", lossFn=" + this.getLossFn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayer)) {
            return false;
        }
        BaseOutputLayer other = (BaseOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        return !(this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 43 : $lossFn.hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected ILossFunction lossFn = new LossMCXENT();

        public Builder() {
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
        }

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(lossFunction.getILossFunction());
        }

        public T lossFunction(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
            return (T)this;
        }
    }
}

