/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public abstract class BasePretrainNetwork
extends FeedForwardLayer {
    protected LossFunctions.LossFunction lossFunction;
    @Deprecated
    protected String customLossFunction;
    protected double visibleBiasInit;
    private int preTrainIterations;

    public BasePretrainNetwork(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.customLossFunction = builder.customLossFunction;
        this.visibleBiasInit = builder.visibleBiasInit;
        this.preTrainIterations = builder.preTrainIterations;
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return 0.0;
            }
            case "vb": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return 0.0;
            }
            case "vb": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
            case "vb": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    @Deprecated
    public String getCustomLossFunction() {
        return this.customLossFunction;
    }

    public double getVisibleBiasInit() {
        return this.visibleBiasInit;
    }

    public int getPreTrainIterations() {
        return this.preTrainIterations;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    @Deprecated
    public void setCustomLossFunction(String customLossFunction) {
        this.customLossFunction = customLossFunction;
    }

    public void setVisibleBiasInit(double visibleBiasInit) {
        this.visibleBiasInit = visibleBiasInit;
    }

    public void setPreTrainIterations(int preTrainIterations) {
        this.preTrainIterations = preTrainIterations;
    }

    public BasePretrainNetwork() {
    }

    @Override
    public String toString() {
        return "BasePretrainNetwork(super=" + super.toString() + ", lossFunction=" + this.getLossFunction() + ", customLossFunction=" + this.getCustomLossFunction() + ", visibleBiasInit=" + this.getVisibleBiasInit() + ", preTrainIterations=" + this.getPreTrainIterations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePretrainNetwork)) {
            return false;
        }
        BasePretrainNetwork other = (BasePretrainNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LossFunctions.LossFunction this$lossFunction = this.getLossFunction();
        LossFunctions.LossFunction other$lossFunction = other.getLossFunction();
        if (this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction)) {
            return false;
        }
        String this$customLossFunction = this.getCustomLossFunction();
        String other$customLossFunction = other.getCustomLossFunction();
        if (this$customLossFunction == null ? other$customLossFunction != null : !this$customLossFunction.equals(other$customLossFunction)) {
            return false;
        }
        if (Double.compare(this.getVisibleBiasInit(), other.getVisibleBiasInit()) != 0) {
            return false;
        }
        return this.getPreTrainIterations() == other.getPreTrainIterations();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BasePretrainNetwork;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        LossFunctions.LossFunction $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 43 : $lossFunction.hashCode());
        String $customLossFunction = this.getCustomLossFunction();
        result = result * 59 + ($customLossFunction == null ? 43 : $customLossFunction.hashCode());
        long $visibleBiasInit = Double.doubleToLongBits(this.getVisibleBiasInit());
        result = result * 59 + (int)($visibleBiasInit >>> 32 ^ $visibleBiasInit);
        result = result * 59 + this.getPreTrainIterations();
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        protected String customLossFunction = null;
        protected double visibleBiasInit = 0.0;
        protected int preTrainIterations = 1;

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return (T)this;
        }

        @Deprecated
        public T customLossFunction(String customLossFunction) {
            this.customLossFunction = customLossFunction;
            return (T)this;
        }

        public T visibleBiasInit(double visibleBiasInit) {
            this.visibleBiasInit = visibleBiasInit;
            return (T)this;
        }

        public T preTrainIterations(int preTrainIterations) {
            this.preTrainIterations = preTrainIterations;
            return (T)this;
        }
    }
}

