/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.EmbeddingLayer;
import org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoEncoder.class, name="autoEncoder"), @JsonSubTypes.Type(value=ConvolutionLayer.class, name="convolution"), @JsonSubTypes.Type(value=GravesLSTM.class, name="gravesLSTM"), @JsonSubTypes.Type(value=GravesBidirectionalLSTM.class, name="gravesBidirectionalLSTM"), @JsonSubTypes.Type(value=OutputLayer.class, name="output"), @JsonSubTypes.Type(value=RnnOutputLayer.class, name="rnnoutput"), @JsonSubTypes.Type(value=LossLayer.class, name="loss"), @JsonSubTypes.Type(value=RBM.class, name="RBM"), @JsonSubTypes.Type(value=DenseLayer.class, name="dense"), @JsonSubTypes.Type(value=SubsamplingLayer.class, name="subsampling"), @JsonSubTypes.Type(value=BatchNormalization.class, name="batchNormalization"), @JsonSubTypes.Type(value=LocalResponseNormalization.class, name="localResponseNormalization"), @JsonSubTypes.Type(value=EmbeddingLayer.class, name="embedding"), @JsonSubTypes.Type(value=ActivationLayer.class, name="activation"), @JsonSubTypes.Type(value=VariationalAutoencoder.class, name="VariationalAutoencoder")})
public abstract class Layer
implements Serializable,
Cloneable {
    protected String layerName;
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected double biasInit;
    protected Distribution dist;
    protected double learningRate;
    protected double biasLearningRate;
    protected Map<Integer, Double> learningRateSchedule;
    protected double momentum;
    protected Map<Integer, Double> momentumSchedule;
    protected double l1;
    protected double l2;
    protected double biasL1;
    protected double biasL2;
    protected double dropOut;
    protected Updater updater;
    protected double rho;
    protected double epsilon;
    protected double rmsDecay;
    protected double adamMeanDecay;
    protected double adamVarDecay;
    protected GradientNormalization gradientNormalization = GradientNormalization.None;
    protected double gradientNormalizationThreshold = 1.0;

    public Layer(Builder builder) {
        this.layerName = builder.layerName;
        this.activationFn = builder.activationFn;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateSchedule = builder.learningRateSchedule;
        this.momentum = builder.momentum;
        this.momentumSchedule = builder.momentumAfter;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.dropOut = builder.dropOut;
        this.updater = builder.updater;
        this.rho = builder.rho;
        this.epsilon = builder.epsilon;
        this.rmsDecay = builder.rmsDecay;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    public Layer clone() {
        try {
            Layer clone = (Layer)super.clone();
            if (clone.dist != null) {
                clone.dist = clone.dist.clone();
            }
            if (clone.learningRateSchedule != null) {
                clone.learningRateSchedule = new HashMap<Integer, Double>(clone.learningRateSchedule);
            }
            if (clone.momentumSchedule != null) {
                clone.momentumSchedule = new HashMap<Integer, Double>(clone.momentumSchedule);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration var1, Collection<IterationListener> var2, int var3, INDArray var4, boolean var5);

    public abstract ParamInitializer initializer();

    public abstract InputType getOutputType(int var1, InputType var2);

    public abstract void setNIn(InputType var1, boolean var2);

    public abstract InputPreProcessor getPreProcessorForInputType(InputType var1);

    public abstract double getL1ByParam(String var1);

    public abstract double getL2ByParam(String var1);

    public abstract double getLearningRateByParam(String var1);

    public Updater getUpdaterByParam(String paramName) {
        return this.updater;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getBiasLearningRate() {
        return this.biasLearningRate;
    }

    public Map<Integer, Double> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public Map<Integer, Double> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getBiasL1() {
        return this.biasL1;
    }

    public double getBiasL2() {
        return this.biasL2;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public double getRho() {
        return this.rho;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    public double getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    public double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setBiasLearningRate(double biasLearningRate) {
        this.biasLearningRate = biasLearningRate;
    }

    public void setLearningRateSchedule(Map<Integer, Double> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setBiasL1(double biasL1) {
        this.biasL1 = biasL1;
    }

    public void setBiasL2(double biasL2) {
        this.biasL2 = biasL2;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setAdamMeanDecay(double adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    public void setAdamVarDecay(double adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$layerName = this.getLayerName();
        String other$layerName = other.getLayerName();
        if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBiasLearningRate(), other.getBiasLearningRate()) != 0) {
            return false;
        }
        Map<Integer, Double> this$learningRateSchedule = this.getLearningRateSchedule();
        Map<Integer, Double> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !((Object)this$learningRateSchedule).equals(other$learningRateSchedule)) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
        Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
        if (this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getBiasL1(), other.getBiasL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBiasL2(), other.getBiasL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
            return false;
        }
        Updater this$updater = this.getUpdater();
        Updater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $layerName = this.getLayerName();
        result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $biasLearningRate = Double.doubleToLongBits(this.getBiasLearningRate());
        result = result * 59 + (int)($biasLearningRate >>> 32 ^ $biasLearningRate);
        Map<Integer, Double> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : ((Object)$learningRateSchedule).hashCode());
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $biasL1 = Double.doubleToLongBits(this.getBiasL1());
        result = result * 59 + (int)($biasL1 >>> 32 ^ $biasL1);
        long $biasL2 = Double.doubleToLongBits(this.getBiasL2());
        result = result * 59 + (int)($biasL2 >>> 32 ^ $biasL2);
        long $dropOut = Double.doubleToLongBits(this.getDropOut());
        result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
        Updater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : ((Object)((Object)$updater)).hashCode());
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
        result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
        long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
        result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
        long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
        result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
        return result;
    }

    public String toString() {
        return "Layer(layerName=" + this.getLayerName() + ", activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", biasLearningRate=" + this.getBiasLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", biasL1=" + this.getBiasL1() + ", biasL2=" + this.getBiasL2() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", rho=" + this.getRho() + ", epsilon=" + this.getEpsilon() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String layerName = null;
        protected IActivation activationFn = null;
        protected WeightInit weightInit = null;
        protected double biasInit = Double.NaN;
        protected Distribution dist = null;
        protected double learningRate = Double.NaN;
        protected double biasLearningRate = Double.NaN;
        protected Map<Integer, Double> learningRateSchedule = null;
        protected double momentum = Double.NaN;
        protected Map<Integer, Double> momentumAfter = null;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double dropOut = Double.NaN;
        protected Updater updater = null;
        protected double rho = Double.NaN;
        protected double epsilon = Double.NaN;
        protected double rmsDecay = Double.NaN;
        protected double adamMeanDecay = Double.NaN;
        protected double adamVarDecay = Double.NaN;
        protected GradientNormalization gradientNormalization = null;
        protected double gradientNormalizationThreshold = Double.NaN;
        protected LearningRatePolicy learningRatePolicy = null;

        public T name(String layerName) {
            this.layerName = layerName;
            return (T)this;
        }

        @Deprecated
        public T activation(String activationFunction) {
            return this.activation(Activation.fromString((String)activationFunction));
        }

        public T activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return (T)this;
        }

        public T activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return (T)this;
        }

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T momentum(double momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            this.updater = updater;
            return (T)this;
        }

        public T rho(double rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T epsilon(double epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return (T)this;
        }

        public T learningRateDecayPolicy(LearningRatePolicy policy) {
            this.learningRatePolicy = policy;
            return (T)this;
        }

        public abstract <E extends Layer> E build();
    }
}

