/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class Dl4jReflection {
    private Dl4jReflection() {
    }

    public static Constructor<?> getEmptyConstructor(Class<?> clazz) {
        Constructor<?> c = clazz.getDeclaredConstructors()[0];
        for (int i = 0; i < clazz.getDeclaredConstructors().length; ++i) {
            if (clazz.getDeclaredConstructors()[i].getParameterTypes().length >= 1) continue;
            c = clazz.getDeclaredConstructors()[i];
            break;
        }
        return c;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        Class<?> targetClass = clazz;
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return fields.toArray(new Field[fields.size()]);
    }

    public static void setProperties(Object obj, Properties props) throws Exception {
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!props.containsKey(field.getName())) continue;
            Dl4jReflection.set(field, obj, props.getProperty(field.getName()));
        }
    }

    private static void set(Field field, Object obj, String value) throws Exception {
        Class<?> clazz = field.getType();
        field.setAccessible(true);
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            double val = Double.valueOf(value);
            field.set(obj, val);
        } else if (clazz.equals(String.class)) {
            field.set(obj, value);
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            int val = Integer.parseInt(value);
            field.set(obj, val);
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            float f = Float.parseFloat(value);
            field.set(obj, Float.valueOf(f));
        }
    }

    public static Properties getFieldsAsProperties(Object obj, Class<?>[] clazzes) throws Exception {
        Properties props = new Properties();
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object val;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (clazzes != null && !Dl4jReflection.contains(type, clazzes) || (val = field.get(obj)) == null) continue;
            props.put(field.getName(), val.toString());
        }
        return props;
    }

    private static boolean contains(Class<?> test, Class<?>[] arr) {
        for (Class<?> c : arr) {
            if (!c.equals(test)) continue;
            return true;
        }
        return false;
    }
}

