/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonCreator;

public class ComposableInputPreProcessor
extends BaseInputPreProcessor {
    private InputPreProcessor[] inputPreProcessors;

    @JsonCreator
    public ComposableInputPreProcessor(InputPreProcessor ... inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        for (InputPreProcessor preProcessor : this.inputPreProcessors) {
            input = preProcessor.preProcess(input, miniBatchSize, workspaceMgr);
        }
        return input;
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        for (int i = this.inputPreProcessors.length - 1; i >= 0; --i) {
            output = this.inputPreProcessors[i].backprop(output, miniBatchSize, workspaceMgr);
        }
        return output;
    }

    @Override
    public ComposableInputPreProcessor clone() {
        ComposableInputPreProcessor clone = (ComposableInputPreProcessor)super.clone();
        if (clone.inputPreProcessors != null) {
            InputPreProcessor[] processors = new InputPreProcessor[clone.inputPreProcessors.length];
            for (int i = 0; i < clone.inputPreProcessors.length; ++i) {
                processors[i] = clone.inputPreProcessors[i].clone();
            }
            clone.inputPreProcessors = processors;
        }
        return clone;
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        for (InputPreProcessor p : this.inputPreProcessors) {
            inputType = p.getOutputType(inputType);
        }
        return inputType;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        for (InputPreProcessor preproc : this.inputPreProcessors) {
            Pair<INDArray, MaskState> p = preproc.feedForwardMaskArray(maskArray, currentMaskState, minibatchSize);
            maskArray = (INDArray)p.getFirst();
            currentMaskState = (MaskState)((Object)p.getSecond());
        }
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    public InputPreProcessor[] getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public void setInputPreProcessors(InputPreProcessor[] inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public String toString() {
        return "ComposableInputPreProcessor(inputPreProcessors=" + Arrays.deepToString(this.getInputPreProcessors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposableInputPreProcessor)) {
            return false;
        }
        ComposableInputPreProcessor other = (ComposableInputPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getInputPreProcessors(), other.getInputPreProcessors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComposableInputPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getInputPreProcessors());
        return result;
    }
}

