/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.serde.BaseNetConfigDeserializer;
import org.deeplearning4j.nn.conf.weightnoise.DropConnect;
import org.nd4j.shade.jackson.core.JsonLocation;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public class ComputationGraphConfigurationDeserializer
extends BaseNetConfigDeserializer<ComputationGraphConfiguration> {
    public ComputationGraphConfigurationDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer, ComputationGraphConfiguration.class);
    }

    @Override
    public ComputationGraphConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        long charOffsetStart = jp.getCurrentLocation().getCharOffset();
        ComputationGraphConfiguration conf = (ComputationGraphConfiguration)this.defaultDeserializer.deserialize(jp, ctxt);
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Map<String, GraphVertex> vertices = conf.getVertices();
        for (Map.Entry<String, GraphVertex> entry : vertices.entrySet()) {
            if (!(entry.getValue() instanceof LayerVertex)) continue;
            LayerVertex lv = (LayerVertex)entry.getValue();
            layerList.add(lv.getLayerConf().getLayer());
        }
        Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
        boolean attemptIUpdaterFromLegacy = this.requiresIUpdaterFromLegacy(layers);
        if (attemptIUpdaterFromLegacy) {
            JsonLocation endLocation = jp.getCurrentLocation();
            long charOffsetEnd = endLocation.getCharOffset();
            String jsonSubString = endLocation.getSourceRef().toString().substring((int)charOffsetStart - 1, (int)charOffsetEnd);
            ObjectMapper om = NeuralNetConfiguration.mapper();
            JsonNode rootNode = om.readTree(jsonSubString);
            ObjectNode verticesNode = (ObjectNode)rootNode.get("vertices");
            Iterator iter = verticesNode.elements();
            int layerIdx = 0;
            while (iter.hasNext()) {
                double d;
                JsonNode next = (JsonNode)iter.next();
                ObjectNode confNode = null;
                if (!next.has("LayerVertex") || !(next = next.get("LayerVertex")).has("layerConf")) continue;
                confNode = (ObjectNode)next.get("layerConf");
                next = (JsonNode)confNode.get("layer").elements().next();
                if (layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getIUpdater() == null) {
                    this.handleUpdaterBackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                }
                if (layers[layerIdx].getIDropout() == null && next.has("dropOut") && !Double.isNaN(d = next.get("dropOut").asDouble())) {
                    if (layers[layerIdx] instanceof BaseLayer && confNode.has("useDropConnect") && confNode.get("useDropConnect").asBoolean(false)) {
                        ((BaseLayer)layers[layerIdx]).setWeightNoise(new DropConnect(d));
                    } else {
                        layers[layerIdx].setIDropout(new Dropout(d));
                    }
                }
                ++layerIdx;
            }
        }
        return conf;
    }
}

