/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.objdetect;

import org.nd4j.linalg.api.ndarray.INDArray;

public class DetectedObject {
    private final int exampleNumber;
    private final double centerX;
    private final double centerY;
    private final double width;
    private final double height;
    private final INDArray classPredictions;
    private int predictedClass = -1;
    private final double confidence;

    public DetectedObject(int exampleNumber, double centerX, double centerY, double width, double height, INDArray classPredictions, double confidence) {
        this.exampleNumber = exampleNumber;
        this.centerX = centerX;
        this.centerY = centerY;
        this.width = width;
        this.height = height;
        this.classPredictions = classPredictions;
        this.confidence = confidence;
    }

    public double[] getTopLeftXY() {
        return new double[]{this.centerX - this.width / 2.0, this.centerY - this.height / 2.0};
    }

    public double[] getBottomRightXY() {
        return new double[]{this.centerX + this.width / 2.0, this.centerY + this.height / 2.0};
    }

    public int getPredictedClass() {
        if (this.predictedClass == -1) {
            this.predictedClass = this.classPredictions.ravel().argMax(new int[]{1}).getInt(new int[]{0});
        }
        return this.predictedClass;
    }

    public String toString() {
        return "DetectedObject(exampleNumber=" + this.exampleNumber + ", centerX=" + this.centerX + ", centerY=" + this.centerY + ", width=" + this.width + ", height=" + this.height + ", confidence=" + this.confidence + ", classPredictions=" + this.classPredictions + ", predictedClass=" + this.getPredictedClass() + ")";
    }

    public int getExampleNumber() {
        return this.exampleNumber;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public INDArray getClassPredictions() {
        return this.classPredictions;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setPredictedClass(int predictedClass) {
        this.predictedClass = predictedClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectedObject)) {
            return false;
        }
        DetectedObject other = (DetectedObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExampleNumber() != other.getExampleNumber()) {
            return false;
        }
        if (Double.compare(this.getCenterX(), other.getCenterX()) != 0) {
            return false;
        }
        if (Double.compare(this.getCenterY(), other.getCenterY()) != 0) {
            return false;
        }
        if (Double.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        INDArray this$classPredictions = this.getClassPredictions();
        INDArray other$classPredictions = other.getClassPredictions();
        if (this$classPredictions == null ? other$classPredictions != null : !this$classPredictions.equals(other$classPredictions)) {
            return false;
        }
        if (this.getPredictedClass() != other.getPredictedClass()) {
            return false;
        }
        return Double.compare(this.getConfidence(), other.getConfidence()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetectedObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExampleNumber();
        long $centerX = Double.doubleToLongBits(this.getCenterX());
        result = result * 59 + (int)($centerX >>> 32 ^ $centerX);
        long $centerY = Double.doubleToLongBits(this.getCenterY());
        result = result * 59 + (int)($centerY >>> 32 ^ $centerY);
        long $width = Double.doubleToLongBits(this.getWidth());
        result = result * 59 + (int)($width >>> 32 ^ $width);
        long $height = Double.doubleToLongBits(this.getHeight());
        result = result * 59 + (int)($height >>> 32 ^ $height);
        INDArray $classPredictions = this.getClassPredictions();
        result = result * 59 + ($classPredictions == null ? 43 : $classPredictions.hashCode());
        result = result * 59 + this.getPredictedClass();
        long $confidence = Double.doubleToLongBits(this.getConfidence());
        result = result * 59 + (int)($confidence >>> 32 ^ $confidence);
        return result;
    }
}

