/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.primitives.Pair;

public class Subsampling1DLayer
extends SubsamplingLayer {
    public Subsampling1DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        if (epsilon.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + epsilon.rank() + " array as epsilon for Subsampling1DLayer backprop with shape " + Arrays.toString(epsilon.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length]. " + this.layerId());
        }
        if (this.maskArray != null) {
            INDArray maskOut = (INDArray)this.feedForwardMaskArray(this.maskArray, MaskState.Active, (int)epsilon.size(0)).getFirst();
            Preconditions.checkState((epsilon.size(0) == maskOut.size(0) && epsilon.size(2) == maskOut.size(1) ? 1 : 0) != 0, (String)"Activation gradients dimensions (0,2) and mask dimensions (0,1) don't match: Activation gradients %s, Mask %s", (Object)epsilon.shape(), (Object)maskOut.shape());
            Broadcast.mul((INDArray)epsilon, (INDArray)maskOut, (INDArray)epsilon, (int[])new int[]{0, 2});
        }
        INDArray origInput = this.input;
        this.input = this.input.castTo(this.dataType).reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        epsilon = epsilon.reshape(new long[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1L});
        Pair<Gradient, INDArray> gradientEpsNext = super.backpropGradient(epsilon, workspaceMgr);
        INDArray epsNext = (INDArray)gradientEpsNext.getSecond();
        this.input = origInput;
        epsNext = epsNext.reshape(new long[]{epsNext.size(0), epsNext.size(1), epsNext.size(2)});
        return new Pair(gradientEpsNext.getFirst(), (Object)epsNext);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (this.input.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling1DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length]. " + this.layerId());
        }
        INDArray origInput = this.input;
        this.input = this.input.castTo(this.dataType).reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        INDArray acts = super.activate(training, workspaceMgr);
        this.input = origInput;
        acts = acts.reshape(new long[]{acts.size(0), acts.size(1), acts.size(2)});
        if (this.maskArray != null) {
            INDArray maskOut = (INDArray)this.feedForwardMaskArray(this.maskArray, MaskState.Active, (int)acts.size(0)).getFirst();
            Preconditions.checkState((acts.size(0) == maskOut.size(0) && acts.size(2) == maskOut.size(1) ? 1 : 0) != 0, (String)"Activations dimensions (0,2) and mask dimensions (0,1) don't match: Activations %s, Mask %s", (Object)acts.shape(), (Object)maskOut.shape());
            Broadcast.mul((INDArray)acts, (INDArray)maskOut, (INDArray)acts, (int[])new int[]{0, 2});
        }
        return acts;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        INDArray reduced = ConvolutionUtils.cnn1dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getConvolutionMode());
        return new Pair((Object)reduced, (Object)currentMaskState);
    }
}

