/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.List;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.primitives.Pair;

public class RnnLossLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.RnnLossLayer>
implements IOutputLayer {
    protected INDArray labels;

    public RnnLossLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input is not rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        if (this.labels == null) {
            throw new IllegalStateException("Labels are not set (null)");
        }
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.BP_WORKING_MEM);
        INDArray labels2d = TimeSeriesUtils.reshape3dTo2d(this.labels, workspaceMgr, ArrayType.BP_WORKING_MEM);
        INDArray maskReshaped = this.maskArray != null ? (this.maskArray.rank() == 3 ? TimeSeriesUtils.reshapePerOutputTimeSeriesMaskTo2d(this.maskArray, workspaceMgr, ArrayType.BP_WORKING_MEM) : TimeSeriesUtils.reshapeTimeSeriesMaskToVector(this.maskArray, workspaceMgr, ArrayType.BP_WORKING_MEM)) : null;
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getLossFn();
        INDArray delta2d = lossFunction.computeGradient(labels2d, input2d.dup(input2d.ordering()), ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        INDArray delta3d = TimeSeriesUtils.reshape2dTo3d(delta2d, (int)this.input.size(0), workspaceMgr, ArrayType.ACTIVATION_GRAD);
        DefaultGradient gradient = new DefaultGradient();
        return new Pair((Object)gradient, (Object)delta3d);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double f1Score(DataSet data) {
        return 0.0;
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        INDArray out = this.activate(examples, false, null);
        Evaluation eval = new Evaluation();
        eval.evalTimeSeries(labels, out, this.maskArray);
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return (int)this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int[] predict(INDArray examples) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, INDArray labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(DataSet data) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input must be rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray as2d = TimeSeriesUtils.reshape3dTo2d(this.input);
        INDArray out2d = ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getActivationFn().getActivation(workspaceMgr.dup(ArrayType.ACTIVATIONS, as2d, as2d.ordering()), training);
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, TimeSeriesUtils.reshape2dTo3d(out2d, (int)this.input.size(0), workspaceMgr, ArrayType.ACTIVATIONS));
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.maskArray = maskArray;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return null;
        }
        this.maskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspaces(), ArrayType.INPUT);
        this.maskState = currentMaskState;
        return null;
    }

    @Override
    public boolean needsLabels() {
        return true;
    }

    @Override
    public double computeScore(double fullNetRegTerm, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = TimeSeriesUtils.reshape3dTo2d(this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = this.maskArray != null ? (this.maskArray.rank() == 3 ? TimeSeriesUtils.reshapePerOutputTimeSeriesMaskTo2d(this.maskArray, workspaceMgr, ArrayType.FF_WORKING_MEM) : TimeSeriesUtils.reshapeTimeSeriesMaskToVector(this.maskArray, workspaceMgr, ArrayType.FF_WORKING_MEM)) : null;
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(labels2d, input2d.dup(), ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped, false);
        score /= (double)this.getInputMiniBatchSize();
        this.score = score += fullNetRegTerm;
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetRegTerm, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = TimeSeriesUtils.reshape3dTo2d(this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = this.maskArray != null ? (this.maskArray.rank() == 3 ? TimeSeriesUtils.reshapePerOutputTimeSeriesMaskTo2d(this.maskArray, workspaceMgr, ArrayType.FF_WORKING_MEM) : TimeSeriesUtils.reshapeTimeSeriesMaskToVector(this.maskArray, workspaceMgr, ArrayType.FF_WORKING_MEM)) : null;
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(labels2d, input2d, ((org.deeplearning4j.nn.conf.layers.RnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        INDArray scoreArrayTs = TimeSeriesUtils.reshapeVectorToTimeSeriesMask(scoreArray, (int)this.input.size(0));
        INDArray summedScores = scoreArrayTs.sum(new int[]{1});
        if (fullNetRegTerm != 0.0) {
            summedScores.addi((Number)fullNetRegTerm);
        }
        return summedScores;
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }
}

