/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.params.ConvolutionParamInitializer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class Convolution3DParamInitializer
extends ConvolutionParamInitializer {
    private static final Convolution3DParamInitializer INSTANCE = new Convolution3DParamInitializer();
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    public static Convolution3DParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public long numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public long numParams(Layer l) {
        Convolution3D layerConf = (Convolution3D)l;
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        long nOut = layerConf.getNOut();
        return nIn * nOut * (long)kernel[0] * (long)kernel[1] * (long)kernel[2] + (layerConf.hasBias() ? nOut : 0L);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        Convolution3D layer = (Convolution3D)conf.getLayer();
        if (layer.getKernelSize().length != 3) {
            throw new IllegalArgumentException("Filter size must be == 3");
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        long nOut = layerConf.getNOut();
        if (layer.hasBias()) {
            INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)0L, (long)nOut)});
            INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)nOut, (long)this.numParams(conf))});
            params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
            conf.addVariable(BIAS_KEY);
        } else {
            INDArray weightView = paramsView;
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
        }
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        long nOut = layerConf.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        if (layerConf.hasBias()) {
            INDArray biasGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)0L, (long)nOut)});
            INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)nOut, (long)this.numParams(conf))}).reshape('c', new long[]{nOut, nIn, kernel[0], kernel[1], kernel[2]});
            out.put(BIAS_KEY, biasGradientView);
            out.put(WEIGHT_KEY, weightGradientView);
        } else {
            INDArray weightGradientView = gradientView.reshape('c', new long[]{nOut, nIn, kernel[0], kernel[1], kernel[2]});
            out.put(WEIGHT_KEY, weightGradientView);
        }
        return out;
    }

    @Override
    protected INDArray createWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        if (initializeParams) {
            int[] kernel = layerConf.getKernelSize();
            int[] stride = layerConf.getStride();
            long inputDepth = layerConf.getNIn();
            long outputDepth = layerConf.getNOut();
            double fanIn = inputDepth * (long)kernel[0] * (long)kernel[1] * (long)kernel[2];
            double fanOut = (double)(outputDepth * (long)kernel[0] * (long)kernel[1] * (long)kernel[2]) / ((double)stride[0] * (double)stride[1] * (double)stride[2]);
            long[] weightsShape = new long[]{outputDepth, inputDepth, kernel[0], kernel[1], kernel[2]};
            return layerConf.getWeightInitFn().init(fanIn, fanOut, weightsShape, 'c', weightView);
        }
        int[] kernel = layerConf.getKernelSize();
        return WeightInitUtil.reshapeWeights(new long[]{layerConf.getNOut(), layerConf.getNIn(), kernel[0], kernel[1], kernel[2]}, weightView, 'c');
    }
}

