/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;

public class WeightInitConstant
implements IWeightInit {
    private final double value;

    public WeightInitConstant() {
        this(0.0);
    }

    public WeightInitConstant(double value) {
        this.value = value;
    }

    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        paramView.assign((Number)this.value);
        return paramView.reshape(order, shape);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitConstant)) {
            return false;
        }
        WeightInitConstant other = (WeightInitConstant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.value, other.value) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }
}

