/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.adapters;

import java.util.List;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.ModelAdapter;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.layers.objdetect.DetectedObject;
import org.deeplearning4j.nn.layers.objdetect.Yolo2OutputLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class YoloModelAdapter
implements ModelAdapter<List<DetectedObject>> {
    private int outputLayerIndex;
    private int outputIndex;
    private double detectionThreshold;

    @Override
    public List<DetectedObject> apply(Model model, INDArray[] inputs, INDArray[] masks, INDArray[] labelsMasks) {
        if (model instanceof ComputationGraph) {
            Layer blindLayer = ((ComputationGraph)model).getOutputLayer(this.outputLayerIndex);
            if (blindLayer instanceof Yolo2OutputLayer) {
                INDArray[] output = ((ComputationGraph)model).output(false, inputs, masks, labelsMasks);
                return ((Yolo2OutputLayer)blindLayer).getPredictedObjects(output[this.outputIndex], this.detectionThreshold);
            }
            throw new ND4JIllegalStateException("Output layer with index [" + this.outputLayerIndex + "] is NOT Yolo2OutputLayer");
        }
        throw new ND4JIllegalStateException("Yolo2 model must be ComputationGraph");
    }

    @Override
    public List<DetectedObject> apply(INDArray ... outputs) {
        throw new UnsupportedOperationException("Please use apply(Model, INDArray[], INDArray[]) signature");
    }

    private static int $default$outputLayerIndex() {
        return 0;
    }

    private static int $default$outputIndex() {
        return 0;
    }

    private static double $default$detectionThreshold() {
        return 0.5;
    }

    public static YoloModelAdapterBuilder builder() {
        return new YoloModelAdapterBuilder();
    }

    public YoloModelAdapter(int outputLayerIndex, int outputIndex, double detectionThreshold) {
        this.outputLayerIndex = outputLayerIndex;
        this.outputIndex = outputIndex;
        this.detectionThreshold = detectionThreshold;
    }

    public YoloModelAdapter() {
        this.outputLayerIndex = YoloModelAdapter.$default$outputLayerIndex();
        this.outputIndex = YoloModelAdapter.$default$outputIndex();
        this.detectionThreshold = YoloModelAdapter.$default$detectionThreshold();
    }

    public static class YoloModelAdapterBuilder {
        private boolean outputLayerIndex$set;
        private int outputLayerIndex;
        private boolean outputIndex$set;
        private int outputIndex;
        private boolean detectionThreshold$set;
        private double detectionThreshold;

        YoloModelAdapterBuilder() {
        }

        public YoloModelAdapterBuilder outputLayerIndex(int outputLayerIndex) {
            this.outputLayerIndex = outputLayerIndex;
            this.outputLayerIndex$set = true;
            return this;
        }

        public YoloModelAdapterBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            this.outputIndex$set = true;
            return this;
        }

        public YoloModelAdapterBuilder detectionThreshold(double detectionThreshold) {
            this.detectionThreshold = detectionThreshold;
            this.detectionThreshold$set = true;
            return this;
        }

        public YoloModelAdapter build() {
            int outputLayerIndex = this.outputLayerIndex;
            if (!this.outputLayerIndex$set) {
                outputLayerIndex = YoloModelAdapter.$default$outputLayerIndex();
            }
            int outputIndex = this.outputIndex;
            if (!this.outputIndex$set) {
                outputIndex = YoloModelAdapter.$default$outputIndex();
            }
            double detectionThreshold = this.detectionThreshold;
            if (!this.detectionThreshold$set) {
                detectionThreshold = YoloModelAdapter.$default$detectionThreshold();
            }
            return new YoloModelAdapter(outputLayerIndex, outputIndex, detectionThreshold);
        }

        public String toString() {
            return "YoloModelAdapter.YoloModelAdapterBuilder(outputLayerIndex=" + this.outputLayerIndex + ", outputIndex=" + this.outputIndex + ", detectionThreshold=" + this.detectionThreshold + ")";
        }
    }
}

