/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph.rnn;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ReverseTimeSeriesVertex
extends GraphVertex {
    private final String maskArrayInputName;

    public ReverseTimeSeriesVertex() {
        this(null);
    }

    public ReverseTimeSeriesVertex(String maskArrayInputName) {
        this.maskArrayInputName = maskArrayInputName;
    }

    @Override
    public ReverseTimeSeriesVertex clone() {
        return new ReverseTimeSeriesVertex(this.maskArrayInputName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ReverseTimeSeriesVertex)) {
            return false;
        }
        ReverseTimeSeriesVertex rsgv = (ReverseTimeSeriesVertex)o;
        if (this.maskArrayInputName == null && rsgv.maskArrayInputName != null || this.maskArrayInputName != null && rsgv.maskArrayInputName == null) {
            return false;
        }
        return this.maskArrayInputName == null || this.maskArrayInputName.equals(rsgv.maskArrayInputName);
    }

    @Override
    public int hashCode() {
        return this.maskArrayInputName != null ? this.maskArrayInputName.hashCode() : 0;
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.impl.rnn.ReverseTimeSeriesVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.rnn.ReverseTimeSeriesVertex(graph, name, idx, this.maskArrayInputName, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("Invalid input type: cannot revert more than 1 input");
        }
        if (vertexInputs[0].getType() != InputType.Type.RNN) {
            throw new InvalidInputTypeException("Invalid input type: cannot revert non RNN input (got: " + vertexInputs[0] + ")");
        }
        return vertexInputs[0];
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        return new LayerMemoryReport.Builder(null, this.getClass(), inputTypes[0], this.getOutputType(-1, inputTypes)).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public String toString() {
        String paramStr = this.maskArrayInputName == null ? "" : "inputName=" + this.maskArrayInputName;
        return "ReverseTimeSeriesVertex(" + paramStr + ")";
    }

    public String getMaskArrayInputName() {
        return this.maskArrayInputName;
    }
}

