/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.CenterLossParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.NoOp;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class CenterLossOutputLayer
extends BaseOutputLayer {
    protected double alpha;
    protected double lambda;
    protected boolean gradientCheck;

    protected CenterLossOutputLayer(Builder builder) {
        super(builder);
        this.alpha = builder.alpha;
        this.lambda = builder.lambda;
        this.gradientCheck = builder.gradientCheck;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("CenterLossOutputLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.training.CenterLossOutputLayer ret = new org.deeplearning4j.nn.layers.training.CenterLossOutputLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return CenterLossParamInitializer.getInstance();
    }

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        switch (paramName) {
            case "cL": {
                return new NoOp();
            }
        }
        return this.iUpdater;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public boolean getGradientCheck() {
        return this.gradientCheck;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        long nParamsW = this.nIn * this.nOut;
        long nParamsB = this.nOut;
        long nParamsCenter = this.nIn * this.nOut;
        long numParams = nParamsW + nParamsB + nParamsCenter;
        int updaterStateSize = (int)(this.getUpdaterByParam("W").stateSize(nParamsW) + this.getUpdaterByParam("b").stateSize(nParamsB) + this.getUpdaterByParam("cL").stateSize(nParamsCenter));
        int trainSizeFixed = 0;
        int trainSizeVariable = 0;
        if (this.getIDropout() != null) {
            trainSizeVariable = (int)((long)trainSizeVariable + inputType.arrayElementsPerExample());
        }
        trainSizeVariable = (int)((long)trainSizeVariable + outputType.arrayElementsPerExample());
        return new LayerMemoryReport.Builder(this.layerName, CenterLossOutputLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, trainSizeFixed, trainSizeVariable).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public void setGradientCheck(boolean gradientCheck) {
        this.gradientCheck = gradientCheck;
    }

    public CenterLossOutputLayer() {
    }

    @Override
    public String toString() {
        return "CenterLossOutputLayer(super=" + super.toString() + ", alpha=" + this.getAlpha() + ", lambda=" + this.getLambda() + ", gradientCheck=" + this.getGradientCheck() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CenterLossOutputLayer)) {
            return false;
        }
        CenterLossOutputLayer other = (CenterLossOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (Double.compare(this.getLambda(), other.getLambda()) != 0) {
            return false;
        }
        return this.getGradientCheck() == other.getGradientCheck();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CenterLossOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        long $lambda = Double.doubleToLongBits(this.getLambda());
        result = result * 59 + (int)($lambda >>> 32 ^ $lambda);
        result = result * 59 + (this.getGradientCheck() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        protected double alpha = 0.05;
        protected double lambda = 2.0E-4;
        protected boolean gradientCheck = false;

        public Builder() {
            this.setActivationFn((IActivation)new ActivationSoftmax());
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            super.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.setLossFn(lossFunction);
        }

        public Builder alpha(double alpha) {
            this.setAlpha(alpha);
            return this;
        }

        public Builder lambda(double lambda) {
            this.setLambda(lambda);
            return this;
        }

        public Builder gradientCheck(boolean isGradientCheck) {
            this.setGradientCheck(isGradientCheck);
            return this;
        }

        @Override
        public CenterLossOutputLayer build() {
            return new CenterLossOutputLayer(this);
        }

        public double getAlpha() {
            return this.alpha;
        }

        public double getLambda() {
            return this.lambda;
        }

        public boolean isGradientCheck() {
            return this.gradientCheck;
        }

        public void setAlpha(double alpha) {
            this.alpha = alpha;
        }

        public void setLambda(double lambda) {
            this.lambda = lambda;
        }

        public void setGradientCheck(boolean gradientCheck) {
            this.gradientCheck = gradientCheck;
        }
    }
}

