/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class RnnToCnnPreProcessor
implements InputPreProcessor {
    private int inputHeight;
    private int inputWidth;
    private int numChannels;
    private int product;

    public RnnToCnnPreProcessor(@JsonProperty(value="inputHeight") int inputHeight, @JsonProperty(value="inputWidth") int inputWidth, @JsonProperty(value="numChannels") int numChannels) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
        this.product = inputHeight * inputWidth * numChannels;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        INDArray in2d;
        long[] shape;
        if (input.ordering() != 'f' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = input.dup('f');
        }
        if ((shape = input.shape())[0] == 1L) {
            in2d = input.tensorAlongDimension(0L, new int[]{1, 2}).permutei(new int[]{1, 0});
        } else if (shape[2] == 1L) {
            in2d = input.tensorAlongDimension(0L, new int[]{1, 0});
        } else {
            INDArray permuted = input.permute(new int[]{0, 2, 1});
            in2d = permuted.reshape('f', new long[]{shape[0] * shape[2], shape[1]});
        }
        return workspaceMgr.dup(ArrayType.ACTIVATIONS, in2d, 'c').reshape('c', new long[]{shape[0] * shape[2], this.numChannels, this.inputHeight, this.inputWidth});
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (output.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)output)) {
            output = output.dup('c');
        }
        long[] shape = output.shape();
        INDArray twod = output.reshape('c', new long[]{output.size(0), (long)ArrayUtil.prod((long[])output.shape()) / output.size(0)});
        INDArray reshaped = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, twod, 'f').reshape('f', new long[]{miniBatchSize, shape[0] / (long)miniBatchSize, this.product});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public RnnToCnnPreProcessor clone() {
        return new RnnToCnnPreProcessor(this.inputHeight, this.inputWidth, this.numChannels);
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input type: Expected input of type RNN, got " + inputType);
        }
        InputType.InputTypeRecurrent c = (InputType.InputTypeRecurrent)inputType;
        int expSize = this.inputHeight * this.inputWidth * this.numChannels;
        if (c.getSize() != (long)expSize) {
            throw new IllegalStateException("Invalid input: expected RNN input of size " + expSize + " = (d=" + this.numChannels + " * w=" + this.inputWidth + " * h=" + this.inputHeight + "), got " + inputType);
        }
        return InputType.convolutional(this.inputHeight, this.inputWidth, this.numChannels);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        if (maskArray.rank() == 2) {
            return new Pair((Object)TimeSeriesUtils.reshapeTimeSeriesMaskToCnn4dMask(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT), (Object)currentMaskState);
        }
        throw new IllegalArgumentException("Received mask array of rank " + maskArray.rank() + "; expected rank 2 mask array. Mask array shape: " + Arrays.toString(maskArray.shape()));
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setInputHeight(int inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(int inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public String toString() {
        return "RnnToCnnPreProcessor(inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", product=" + this.product + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnToCnnPreProcessor)) {
            return false;
        }
        RnnToCnnPreProcessor other = (RnnToCnnPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        return this.getNumChannels() == other.getNumChannels();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RnnToCnnPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInputHeight();
        result = result * 59 + this.getInputWidth();
        result = result * 59 + this.getNumChannels();
        return result;
    }
}

