/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.primitives.Pair;

public class Cnn3DLossLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer>
implements IOutputLayer {
    protected INDArray labels;

    public Cnn3DLossLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        int c;
        int w;
        int h;
        int d;
        this.assertInputSet(true);
        if (this.input.rank() != 5) {
            throw new UnsupportedOperationException("Input is not rank 5. Got input with rank " + this.input.rank() + " " + this.layerId() + " with shape " + Arrays.toString(this.input.shape()) + " - expected shape [minibatch,channels,depth,height,width]");
        }
        if (this.labels == null) {
            throw new IllegalStateException("Labels are not set (null)");
        }
        INDArray input2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeCnn3dMask(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.maskArray, this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getLossFn();
        INDArray delta2d = lossFunction.computeGradient(labels2d, input2d.dup(input2d.ordering()), ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        delta2d = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, delta2d);
        int n = (int)this.input.size(0);
        if (((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NDHWC) {
            d = (int)this.input.size(1);
            h = (int)this.input.size(2);
            w = (int)this.input.size(3);
            c = (int)this.input.size(4);
        } else {
            d = (int)this.input.size(2);
            h = (int)this.input.size(3);
            w = (int)this.input.size(4);
            c = (int)this.input.size(1);
        }
        INDArray delta5d = ConvolutionUtils.reshape2dTo5d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), delta2d, n, d, h, w, c, workspaceMgr, ArrayType.ACTIVATION_GRAD);
        DefaultGradient gradient = new DefaultGradient();
        return new Pair((Object)gradient, (Object)delta5d);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double f1Score(DataSet data) {
        return 0.0;
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        INDArray out = this.activate(examples, false, null);
        Evaluation eval = new Evaluation();
        eval.evalTimeSeries(labels, out, this.maskArray);
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return (int)this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int[] predict(INDArray examples) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, INDArray labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(DataSet data) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL3D;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        int c;
        int w;
        int h;
        int d;
        this.assertInputSet(false);
        if (this.input.rank() != 5) {
            throw new UnsupportedOperationException("Input must be rank 5. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray in = workspaceMgr.dup(ArrayType.ACTIVATIONS, this.input, this.input.ordering());
        INDArray input2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), in, workspaceMgr, ArrayType.ACTIVATIONS);
        INDArray out2d = ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getActivationFn().getActivation(input2d, training);
        int n = (int)this.input.size(0);
        if (((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NDHWC) {
            d = (int)this.input.size(1);
            h = (int)this.input.size(2);
            w = (int)this.input.size(3);
            c = (int)this.input.size(4);
        } else {
            d = (int)this.input.size(2);
            h = (int)this.input.size(3);
            w = (int)this.input.size(4);
            c = (int)this.input.size(1);
        }
        return ConvolutionUtils.reshape2dTo5d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), out2d, n, d, h, w, c, workspaceMgr, ArrayType.ACTIVATIONS);
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.maskArray = maskArray;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        return null;
    }

    @Override
    public boolean needsLabels() {
        return true;
    }

    @Override
    public double computeScore(double fullNetRegTerm, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray input2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeCnn3dMask(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.maskArray, this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(labels2d, input2d.dup(), ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getActivationFn(), maskReshaped, false);
        score /= (double)this.getInputMiniBatchSize();
        this.score = score += fullNetRegTerm;
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetRegTerm, LayerWorkspaceMgr workspaceMgr) {
        int c;
        int w;
        int h;
        int d;
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray input2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape5dTo2d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeCnn3dMask(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), this.maskArray, this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(labels2d, input2d, ((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        long[] newShape = (long[])this.input.shape().clone();
        newShape[1] = 1L;
        int n = (int)this.input.size(0);
        if (((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NDHWC) {
            d = (int)this.input.size(1);
            h = (int)this.input.size(2);
            w = (int)this.input.size(3);
            c = (int)this.input.size(4);
        } else {
            d = (int)this.input.size(2);
            h = (int)this.input.size(3);
            w = (int)this.input.size(4);
            c = (int)this.input.size(1);
        }
        INDArray scoreArrayTs = ConvolutionUtils.reshape2dTo5d(((org.deeplearning4j.nn.conf.layers.Cnn3DLossLayer)this.layerConf()).getDataFormat(), scoreArray, n, d, h, w, c, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray summedScores = scoreArrayTs.sum(new int[]{1, 2, 3, 4});
        if (fullNetRegTerm != 0.0) {
            summedScores.addi((Number)fullNetRegTerm);
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, summedScores);
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }
}

