/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.Serializable;
import java.util.Arrays;

public class Checkpoint
implements Serializable {
    private int checkpointNum;
    private long timestamp;
    private int iteration;
    private int epoch;
    private String modelType;
    private String filename;

    public static String getFileHeader() {
        return "checkpointNum,timestamp,iteration,epoch,modelType,filename";
    }

    public static Checkpoint fromFileString(String str) {
        Object[] split = str.split(",");
        if (split.length != 6) {
            throw new IllegalStateException("Cannot parse checkpoint entry: expected 6 entries, got " + split.length + " - values = " + Arrays.toString(split));
        }
        return new Checkpoint(Integer.parseInt(split[0]), Long.parseLong(split[1]), Integer.parseInt(split[2]), Integer.parseInt((String)split[3]), (String)split[4], (String)split[5]);
    }

    public String toFileString() {
        return this.checkpointNum + "," + this.timestamp + "," + this.iteration + "," + this.epoch + "," + this.modelType + "," + this.filename;
    }

    public Checkpoint(int checkpointNum, long timestamp, int iteration, int epoch, String modelType, String filename) {
        this.checkpointNum = checkpointNum;
        this.timestamp = timestamp;
        this.iteration = iteration;
        this.epoch = epoch;
        this.modelType = modelType;
        this.filename = filename;
    }

    public int getCheckpointNum() {
        return this.checkpointNum;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setCheckpointNum(int checkpointNum) {
        this.checkpointNum = checkpointNum;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCheckpointNum() != other.getCheckpointNum()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getIteration() != other.getIteration()) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Checkpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCheckpointNum();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getIteration();
        result = result * 59 + this.getEpoch();
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    public String toString() {
        return "Checkpoint(checkpointNum=" + this.getCheckpointNum() + ", timestamp=" + this.getTimestamp() + ", iteration=" + this.getIteration() + ", epoch=" + this.getEpoch() + ", modelType=" + this.getModelType() + ", filename=" + this.getFilename() + ")";
    }
}

