/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.filter;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.demoiselle.jee.security.DemoiselleSecurityConfig;
import org.demoiselle.jee.security.annotation.Cors;

@Provider
@Priority(value=2000)
public class CorsFilter
implements ContainerResponseFilter {
    @Inject
    private DemoiselleSecurityConfig config;
    @Context
    private ResourceInfo info;

    public void filter(ContainerRequestContext req, ContainerResponseContext res) throws IOException {
        Method method = this.info.getResourceMethod();
        Class classe = this.info.getResourceClass();
        boolean corsEnable = this.config.isCorsEnabled();
        res.getHeaders().putSingle((Object)"Demoiselle-security", (Object)"Enable");
        this.config.getParamsHeaderSecuriry().entrySet().parallelStream().forEach(entry -> res.getHeaders().putSingle(entry.getKey(), entry.getValue()));
        if (method != null && classe != null && method.getAnnotation(Cors.class) != null) {
            corsEnable = method.getAnnotation(Cors.class).enable();
        }
        if (this.config.isCorsEnabled() && corsEnable) {
            this.config.getParamsHeaderCors().entrySet().parallelStream().forEach(entry -> res.getHeaders().putSingle(entry.getKey(), entry.getValue()));
        } else {
            res.getHeaders().remove((Object)"Access-Control-Allow-Origin");
            res.getHeaders().remove((Object)"Access-Control-Allow-Methods");
        }
    }
}

