/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.filter;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.demoiselle.jee.core.api.security.Token;
import org.demoiselle.jee.core.api.security.TokenType;
import org.demoiselle.jee.security.DemoiselleSecurityConfig;

@Provider
@PreMatching
@Priority(value=2000)
public class SecurityFilter
implements ContainerRequestFilter {
    private static final Logger logger = Logger.getLogger(SecurityFilter.class.getName());
    @Inject
    private DemoiselleSecurityConfig config;
    @Inject
    private Token token;

    public void filter(ContainerRequestContext req) throws IOException {
        if (req.getMethod().equals("OPTIONS")) {
            Response.ResponseBuilder responseBuilder = Response.ok();
            if (this.config.isCorsEnabled()) {
                this.config.getParamsHeaderSecuriry().entrySet().parallelStream().forEach(entry -> responseBuilder.header((String)entry.getKey(), entry.getValue()));
            }
            req.abortWith(responseBuilder.build());
        }
        try {
            String chave;
            if (req.getHeaders().containsKey((Object)"Authorization") && !(chave = ((List)req.getHeaders().get((Object)"Authorization")).toString().replace("[", "").replace("]", "")).isEmpty()) {
                this.token.setType(TokenType.valueOf((String)chave.split(" ")[0].toUpperCase()));
                this.token.setKey(chave.split(" ")[1]);
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }
}

