/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.api.security.DemoiselleUser;
import org.demoiselle.jee.security.exception.DemoiselleSecurityException;

@RequestScoped
public class DemoiselleUserImpl
implements DemoiselleUser,
Cloneable {
    private String identity;
    private String name;
    private List<String> roles;
    private Map<String, String> params;
    private Map<String, List<String>> permissions;

    @PostConstruct
    public void init() {
        this.roles = new ArrayList<String>();
        this.permissions = new ConcurrentHashMap<String, List<String>>();
        this.params = new ConcurrentHashMap<String, String>();
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public Map<String, List<String>> getPermissions() {
        return Collections.unmodifiableMap(this.permissions);
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public void addRole(String role) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
    }

    public void removeRole(String role) {
        this.roles.remove(role);
    }

    public List<String> getPermissions(String resource) {
        return this.permissions.get(resource);
    }

    public void addPermission(String resource, String operation) {
        List<String> operations = this.permissions.get(resource);
        if (operations != null && !operations.isEmpty()) {
            if (!this.permissions.get(resource).contains(operation)) {
                this.permissions.get(resource).add(operation);
            }
        } else {
            ArrayList<String> newoperations = new ArrayList<String>();
            newoperations.add(operation);
            this.permissions.putIfAbsent(resource, newoperations);
        }
    }

    public void removePermission(String resource, String operation) {
        List<String> operations = this.permissions.get(resource);
        if (operations != null && !operations.isEmpty()) {
            if (this.permissions.get(resource).contains(operation)) {
                this.permissions.get(resource).remove(operation);
            }
            if (operations.isEmpty()) {
                this.permissions.remove(resource);
            }
        }
    }

    public String getParams(String key) {
        return this.params.get(key);
    }

    public void addParam(String key, String value) {
        this.params.putIfAbsent(key, value);
    }

    public void removeParam(String key) {
        this.params.remove(key);
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + Objects.hashCode(this.identity);
        hash = 19 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DemoiselleUserImpl other = (DemoiselleUserImpl)obj;
        return Objects.equals(this.identity, other.identity);
    }

    public String toString() {
        return "{\"identity\":\"" + this.identity + "\", \"name\":\"" + this.name + "\"}";
    }

    public DemoiselleUser clone() {
        try {
            return (DemoiselleUser)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new DemoiselleSecurityException("Erro ao clonar", Response.Status.UNAUTHORIZED.getStatusCode(), ex);
        }
    }
}

