/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.impl;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.demoiselle.jee.core.api.security.DemoiselleUser;
import org.demoiselle.jee.core.api.security.SecurityContext;
import org.demoiselle.jee.core.api.security.TokenManager;

@RequestScoped
public class SecurityContextImpl
implements SecurityContext {
    @Inject
    private TokenManager tm;

    public boolean hasPermission(String resource, String operation) {
        List list = (List)this.getUser().getPermissions().get(resource);
        if (list != null && !list.isEmpty()) {
            return list.contains(operation);
        }
        return false;
    }

    public boolean hasRole(String role) {
        return this.getUser().getRoles().contains(role);
    }

    public boolean isLoggedIn() {
        return this.tm.validate();
    }

    public DemoiselleUser getUser() {
        return this.tm.getUser();
    }

    public void setUser(DemoiselleUser loggedUser) {
        this.tm.setUser(loggedUser);
    }

    public DemoiselleUser getUser(String issuer, String audience) {
        return this.tm.getUser(issuer, audience);
    }

    public void setUser(DemoiselleUser loggedUser, String issuer, String audience) {
        this.tm.setUser(loggedUser, issuer, audience);
    }

    public void removeUser(DemoiselleUser loggedUser) {
        this.tm.removeUser(loggedUser);
    }
}

