/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.interceptor;

import java.io.Serializable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.api.security.SecurityContext;
import org.demoiselle.jee.security.annotation.Authenticated;
import org.demoiselle.jee.security.exception.DemoiselleSecurityException;
import org.demoiselle.jee.security.message.DemoiselleSecurityMessages;

@Authenticated
@Interceptor
@Priority(value=2000)
public class AuthenticatedInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private DemoiselleSecurityMessages bundle;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Authenticated logged = ic.getMethod().getAnnotation(Authenticated.class);
        if (logged != null && !logged.enable()) {
            return ic.proceed();
        }
        if (!this.securityContext.isLoggedIn()) {
            throw new DemoiselleSecurityException(this.bundle.userNotAuthenticated(), Response.Status.FORBIDDEN.getStatusCode());
        }
        return ic.proceed();
    }
}

