/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.interceptor;

import java.io.Serializable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.api.security.SecurityContext;
import org.demoiselle.jee.security.annotation.Authenticated;
import org.demoiselle.jee.security.annotation.RequiredPermission;
import org.demoiselle.jee.security.exception.DemoiselleSecurityException;
import org.demoiselle.jee.security.message.DemoiselleSecurityMessages;

@RequiredPermission
@Interceptor
@Priority(value=2000)
public class RequiredPermissionInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private DemoiselleSecurityMessages bundle;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Authenticated logged = ic.getMethod().getAnnotation(Authenticated.class);
        String resource = this.getResource(ic);
        String operation = this.getOperation(ic);
        if (logged != null && !logged.enable()) {
            return ic.proceed();
        }
        if (!this.securityContext.isLoggedIn()) {
            throw new DemoiselleSecurityException(this.bundle.doesNotHavePermission(operation, resource), Response.Status.FORBIDDEN.getStatusCode());
        }
        if (!this.securityContext.hasPermission(resource, operation)) {
            throw new DemoiselleSecurityException(this.bundle.doesNotHavePermission(operation, resource), Response.Status.FORBIDDEN.getStatusCode());
        }
        return ic.proceed();
    }

    private String getResource(InvocationContext ic) {
        RequiredPermission requiredPermission = ic.getMethod().getAnnotation(RequiredPermission.class);
        if (requiredPermission == null) {
            requiredPermission = ic.getTarget().getClass().getAnnotation(RequiredPermission.class);
        }
        if (requiredPermission.resource() == null || requiredPermission.resource().trim().isEmpty()) {
            return ic.getTarget().getClass().getSimpleName();
        }
        return requiredPermission.resource();
    }

    private String getOperation(InvocationContext ic) {
        RequiredPermission requiredPermission = ic.getMethod().getAnnotation(RequiredPermission.class);
        if (requiredPermission == null) {
            requiredPermission = ic.getTarget().getClass().getAnnotation(RequiredPermission.class);
        }
        if (requiredPermission.operation() == null || requiredPermission.operation().trim().isEmpty()) {
            return ic.getMethod().getName();
        }
        return requiredPermission.operation();
    }
}

