/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.api.security.SecurityContext;
import org.demoiselle.jee.security.annotation.Authenticated;
import org.demoiselle.jee.security.annotation.RequiredRole;
import org.demoiselle.jee.security.exception.DemoiselleSecurityException;
import org.demoiselle.jee.security.message.DemoiselleSecurityMessages;

@RequiredRole(value={""})
@Interceptor
@Priority(value=2000)
public class RequiredRoleInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private DemoiselleSecurityMessages bundle;

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Authenticated logged = ic.getMethod().getAnnotation(Authenticated.class);
        List<String> roles = this.getRoles(ic);
        ArrayList userRoles = new ArrayList();
        if (logged != null && !logged.enable()) {
            return ic.proceed();
        }
        if (!this.securityContext.isLoggedIn()) {
            throw new DemoiselleSecurityException(this.bundle.userNotAuthenticated(), Response.Status.UNAUTHORIZED.getStatusCode());
        }
        roles.stream().filter(role -> this.securityContext.hasRole(role)).forEach(role -> userRoles.add(role));
        if (userRoles.isEmpty()) {
            throw new DemoiselleSecurityException(this.bundle.doesNotHaveRole(roles.toString()), Response.Status.FORBIDDEN.getStatusCode());
        }
        return ic.proceed();
    }

    private List<String> getRoles(InvocationContext ic) {
        String[] roles = new String[]{};
        roles = ic.getMethod().getAnnotation(RequiredRole.class) == null ? ic.getTarget().getClass().getAnnotation(RequiredRole.class).value() : ic.getMethod().getAnnotation(RequiredRole.class).value();
        return Arrays.asList(roles);
    }
}

