/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCContainerDiagnosticDataBuilder;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidator;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerValidator.class);
    protected ASiCContent asicContent;
    protected List<DocumentValidator> signatureValidators;
    protected List<DetachedTimestampValidator> timestampValidators;
    protected List<EvidenceRecordValidator> evidenceRecordValidators;
    private List<ManifestFile> manifestFiles;

    protected AbstractASiCContainerValidator() {
    }

    protected AbstractASiCContainerValidator(DSSDocument document) {
        this.document = document;
        this.asicContent = this.extractEntries();
    }

    protected AbstractASiCContainerValidator(ASiCContent asicContent) {
        this.document = asicContent.getAsicContainer();
        this.asicContent = asicContent;
    }

    @Deprecated
    protected AbstractASiCContainerValidator(DSSDocument document, SignatureScopeFinder<?> signatureScopeFinder) {
        this(document);
    }

    @Deprecated
    protected AbstractASiCContainerValidator(ASiCContent asicContent, SignatureScopeFinder<?> signatureScopeFinder) {
        this(asicContent);
    }

    public abstract boolean isSupported(ASiCContent var1);

    private ASiCContent extractEntries() {
        AbstractASiCContainerExtractor extractor = this.getContainerExtractor();
        return extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getContainerExtractor();

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures, List<EvidenceRecord> evidenceRecords) {
        ASiCContainerDiagnosticDataBuilder builder = (ASiCContainerDiagnosticDataBuilder)super.createDiagnosticDataBuilder(validationContext, signatures, evidenceRecords);
        builder.containerInfo(this.getContainerInfo());
        return builder;
    }

    protected ASiCContainerDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCContainerDiagnosticDataBuilder();
    }

    protected ContainerInfo getContainerInfo() {
        List<DSSDocument> originalSignedDocuments;
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.asicContent.getContainerType());
        containerInfo.setZipComment(this.asicContent.getZipComment());
        DSSDocument mimeTypeDocument = this.asicContent.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray((DSSDocument)mimeTypeDocument));
            containerInfo.setMimeTypeContent(mimeTypeContent);
        }
        if (Utils.isCollectionNotEmpty(originalSignedDocuments = this.asicContent.getSignedDocuments())) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : originalSignedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDescriptions();

    public List<AdvancedSignature> getAllSignatures() {
        List allSignatureList = super.getAllSignatures();
        this.attachExternalTimestamps(allSignatureList);
        return allSignatureList;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatureList = new ArrayList<AdvancedSignature>();
        for (DocumentValidator validator : this.getSignatureValidators()) {
            signatureList.addAll(validator.getSignatures());
        }
        return signatureList;
    }

    protected abstract List<DocumentValidator> getSignatureValidators();

    public ASiCContainerType getContainerType() {
        return this.asicContent.getContainerType();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.asicContent.getAllDocuments();
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.asicContent.getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.asicContent.getSignedDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.asicContent.getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.asicContent.getTimestampDocuments();
    }

    public List<DSSDocument> getEvidenceRecordDocuments() {
        return this.asicContent.getEvidenceRecordDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.asicContent.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getEvidenceRecordManifestDocuments() {
        return this.asicContent.getEvidenceRecordManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.asicContent.getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.asicContent.getContainerDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.asicContent.getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.asicContent.getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = this.getManifestFilesDescriptions();
        }
        return this.manifestFiles;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        List<DSSDocument> containerDocuments = this.asicContent.getContainerDocuments();
        if (Utils.isCollectionNotEmpty(containerDocuments)) {
            return containerDocuments;
        }
        return retrievedDocs;
    }

    protected List<EvidenceRecord> buildDetachedEvidenceRecords() {
        ArrayList<EvidenceRecord> embeddedEvidenceRecords = new ArrayList<EvidenceRecord>();
        for (EvidenceRecordValidator evidenceRecordValidator : this.getEvidenceRecordValidators()) {
            EvidenceRecord evidenceRecord = this.getEvidenceRecord(evidenceRecordValidator);
            if (evidenceRecord == null) continue;
            embeddedEvidenceRecords.add(evidenceRecord);
        }
        ArrayList<EvidenceRecord> detachedEvidenceRecords = new ArrayList<EvidenceRecord>(super.buildDetachedEvidenceRecords());
        this.attachExternalEvidenceRecords(embeddedEvidenceRecords, detachedEvidenceRecords);
        detachedEvidenceRecords.addAll(embeddedEvidenceRecords);
        return detachedEvidenceRecords;
    }

    protected void attachExternalEvidenceRecords(List<EvidenceRecord> embeddedEvidenceRecords, List<EvidenceRecord> detachedEvidenceRecords) {
        if (Utils.isCollectionNotEmpty(embeddedEvidenceRecords)) {
            for (EvidenceRecord coveredEvidenceRecord : embeddedEvidenceRecords) {
                for (EvidenceRecord coveringEvidenceRecord : embeddedEvidenceRecords) {
                    if (!this.coversEvidenceRecord(coveredEvidenceRecord, coveringEvidenceRecord)) continue;
                    coveredEvidenceRecord.addExternalEvidenceRecord(coveringEvidenceRecord);
                }
                for (EvidenceRecord coveringEvidenceRecord : detachedEvidenceRecords) {
                    coveredEvidenceRecord.addExternalEvidenceRecord(coveringEvidenceRecord);
                }
            }
        }
    }

    protected List<EvidenceRecordValidator> getEvidenceRecordValidators() {
        if (this.evidenceRecordValidators == null) {
            this.evidenceRecordValidators = new ArrayList<EvidenceRecordValidator>();
            for (DSSDocument evidenceRecordDocument : this.getEvidenceRecordDocuments()) {
                EvidenceRecordValidator evidenceRecordValidator = this.getEvidenceRecordValidator(evidenceRecordDocument);
                if (evidenceRecordValidator == null) continue;
                this.evidenceRecordValidators.add(evidenceRecordValidator);
            }
        }
        return this.evidenceRecordValidators;
    }

    private EvidenceRecordValidator getEvidenceRecordValidator(DSSDocument evidenceRecordDocument) {
        try {
            ManifestFile manifestFile = null;
            List<DSSDocument> detachedContents = this.getAllDocuments();
            DSSDocument evidenceRecordManifest = ASiCManifestParser.getLinkedManifest(this.getEvidenceRecordManifestDocuments(), evidenceRecordDocument.getName());
            if (evidenceRecordManifest != null) {
                manifestFile = this.getValidatedManifestFile(evidenceRecordManifest);
            }
            if (manifestFile == null) {
                List<DSSDocument> rootLevelSignedDocuments = ASiCUtils.getRootLevelSignedDocuments(this.asicContent);
                if (Utils.collectionSize(rootLevelSignedDocuments) == 1) {
                    detachedContents = rootLevelSignedDocuments;
                } else {
                    LOG.warn("A linked manifest is not found for an evidence record with name [{}]! Evidence record is skipped.", (Object)evidenceRecordDocument.getName());
                    return null;
                }
            }
            EvidenceRecordValidator evidenceRecordValidator = EvidenceRecordValidator.fromDocument((DSSDocument)evidenceRecordDocument);
            evidenceRecordValidator.setDetachedContents(detachedContents);
            evidenceRecordValidator.setManifestFile(manifestFile);
            evidenceRecordValidator.setCertificateVerifier(this.certificateVerifier);
            return evidenceRecordValidator;
        }
        catch (Exception e) {
            LOG.warn("Unable to load EvidenceRecordValidator for an evidence record document with name '{}' : {}", new Object[]{evidenceRecordDocument.getName(), e.getMessage(), e});
            return null;
        }
    }

    protected boolean coversSignature(AdvancedSignature signature, EvidenceRecord evidenceRecord) {
        ManifestFile evidenceRecordManifest = evidenceRecord.getManifestFile();
        if (evidenceRecordManifest == null) {
            return true;
        }
        return this.coversFile(evidenceRecordManifest, signature.getSignatureFilename());
    }

    private boolean coversEvidenceRecord(EvidenceRecord coveredEvidenceRecord, EvidenceRecord coveringEvidenceRecord) {
        ManifestFile evidenceRecordManifest = coveringEvidenceRecord.getManifestFile();
        if (evidenceRecordManifest == null) {
            return false;
        }
        return this.coversFile(evidenceRecordManifest, coveredEvidenceRecord.getFilename());
    }

    private boolean coversFile(ManifestFile manifestFile, String filename) {
        if (manifestFile != null) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!Utils.areStringsEqual((String)filename, (String)manifestEntry.getFileName())) continue;
                return true;
            }
        }
        return false;
    }

    protected ManifestFile getValidatedManifestFile(DSSDocument manifest) {
        List<ManifestFile> allManifestFiles = this.getManifestFiles();
        if (Utils.isCollectionNotEmpty(allManifestFiles)) {
            for (ManifestFile manifestFile : allManifestFiles) {
                if (!Utils.areStringsEqual((String)manifest.getName(), (String)manifestFile.getFilename())) continue;
                return manifestFile;
            }
        }
        return null;
    }

    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getDocumentName();
        return fileName == null || !ASiCUtils.isSignature(fileName) && !ASiCUtils.isTimestamp(fileName) && !ASiCUtils.isEvidenceRecord(fileName);
    }
}

