/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlByteRange;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDocMDP;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModificationDetection;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModifications;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFLockDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureField;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PDFRevisionWrapper {
    private final XmlPDFRevision pdfRevision;

    public PDFRevisionWrapper(XmlPDFRevision pdfRevision) {
        Objects.requireNonNull(pdfRevision, "XmlPDFRevision cannot be null!");
        this.pdfRevision = pdfRevision;
    }

    public boolean arePdfModificationsDetected() {
        XmlModificationDetection modificationDetection = this.pdfRevision.getModificationDetection();
        if (modificationDetection != null) {
            return !modificationDetection.getAnnotationOverlap().isEmpty() || !modificationDetection.getVisualDifference().isEmpty() || !modificationDetection.getPageDifference().isEmpty();
        }
        return false;
    }

    public List<BigInteger> getPdfAnnotationsOverlapConcernedPages() {
        XmlModificationDetection modificationDetection = this.pdfRevision.getModificationDetection();
        if (modificationDetection != null) {
            List<XmlModification> annotationOverlap = modificationDetection.getAnnotationOverlap();
            return this.getConcernedPages(annotationOverlap);
        }
        return Collections.emptyList();
    }

    public List<BigInteger> getPdfVisualDifferenceConcernedPages() {
        XmlModificationDetection modificationDetection = this.pdfRevision.getModificationDetection();
        if (modificationDetection != null) {
            List<XmlModification> visualDifference = modificationDetection.getVisualDifference();
            return this.getConcernedPages(visualDifference);
        }
        return Collections.emptyList();
    }

    public List<BigInteger> getPdfPageDifferenceConcernedPages() {
        XmlModificationDetection modificationDetection = this.pdfRevision.getModificationDetection();
        if (modificationDetection != null) {
            List<XmlModification> pageDifference = modificationDetection.getPageDifference();
            return this.getConcernedPages(pageDifference);
        }
        return Collections.emptyList();
    }

    public boolean arePdfObjectModificationsDetected() {
        return this.getPdfObjectModifications() != null;
    }

    public List<XmlObjectModification> getPdfExtensionChanges() {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications();
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getExtensionChanges();
        }
        return Collections.emptyList();
    }

    public List<XmlObjectModification> getPdfSignatureOrFormFillChanges() {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications();
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getSignatureOrFormFill();
        }
        return Collections.emptyList();
    }

    public List<XmlObjectModification> getPdfAnnotationChanges() {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications();
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getAnnotationChanges();
        }
        return Collections.emptyList();
    }

    public List<XmlObjectModification> getPdfUndefinedChanges() {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications();
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getUndefined();
        }
        return Collections.emptyList();
    }

    public List<String> getModifiedFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications();
        if (pdfObjectModifications != null) {
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getExtensionChanges()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getSignatureOrFormFill()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getAnnotationChanges()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getUndefined()));
        }
        return names;
    }

    public String getFirstFieldName() {
        List<XmlPDFSignatureField> fields = this.pdfRevision.getFields();
        if (fields != null && !fields.isEmpty()) {
            return fields.iterator().next().getName();
        }
        return null;
    }

    public List<String> getSignatureFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<XmlPDFSignatureField> fields = this.pdfRevision.getFields();
        if (fields != null && !fields.isEmpty()) {
            for (XmlPDFSignatureField signatureField : fields) {
                names.add(signatureField.getName());
            }
        }
        return names;
    }

    public String getSignerName() {
        return this.pdfRevision.getPDFSignatureDictionary().getSignerName();
    }

    public String getSignatureDictionaryType() {
        return this.pdfRevision.getPDFSignatureDictionary().getType();
    }

    public String getFilter() {
        return this.pdfRevision.getPDFSignatureDictionary().getFilter();
    }

    public String getSubFilter() {
        return this.pdfRevision.getPDFSignatureDictionary().getSubFilter();
    }

    public String getContactInfo() {
        return this.pdfRevision.getPDFSignatureDictionary().getContactInfo();
    }

    public String getLocation() {
        return this.pdfRevision.getPDFSignatureDictionary().getLocation();
    }

    public String getReason() {
        return this.pdfRevision.getPDFSignatureDictionary().getReason();
    }

    public List<BigInteger> getSignatureByteRange() {
        XmlByteRange byteRange = this.getXmlByteRange();
        if (byteRange != null) {
            return byteRange.getValue();
        }
        return Collections.emptyList();
    }

    public boolean isSignatureByteRangeValid() {
        XmlByteRange byteRange = this.getXmlByteRange();
        if (byteRange != null) {
            return byteRange.isValid();
        }
        return false;
    }

    private XmlByteRange getXmlByteRange() {
        return this.pdfRevision.getPDFSignatureDictionary().getSignatureByteRange();
    }

    public boolean isPdfSignatureDictionaryConsistent() {
        return this.pdfRevision.getPDFSignatureDictionary().isConsistent();
    }

    public CertificationPermission getDocMDPPermissions() {
        XmlDocMDP docMDP = this.pdfRevision.getPDFSignatureDictionary().getDocMDP();
        if (docMDP != null) {
            return docMDP.getPermissions();
        }
        return null;
    }

    public XmlPDFLockDictionary getFieldMDP() {
        return this.pdfRevision.getPDFSignatureDictionary().getFieldMDP();
    }

    public XmlPDFLockDictionary getSigFieldLock() {
        List<XmlPDFSignatureField> fields = this.pdfRevision.getFields();
        for (XmlPDFSignatureField field : fields) {
            XmlPDFLockDictionary sigFieldLock = field.getSigFieldLock();
            if (sigFieldLock == null) continue;
            return sigFieldLock;
        }
        return null;
    }

    private List<BigInteger> getConcernedPages(List<XmlModification> xmlModifications) {
        ArrayList<BigInteger> pages = new ArrayList<BigInteger>();
        for (XmlModification modification : xmlModifications) {
            pages.add(modification.getPage());
        }
        return pages;
    }

    private XmlObjectModifications getPdfObjectModifications() {
        XmlModificationDetection modificationDetection = this.pdfRevision.getModificationDetection();
        if (modificationDetection != null) {
            return modificationDetection.getObjectModifications();
        }
        return null;
    }

    private List<String> getModifiedFieldNames(List<XmlObjectModification> objectModifications) {
        ArrayList<String> names = new ArrayList<String>();
        for (XmlObjectModification objectModification : objectModifications) {
            String fieldName = objectModification.getFieldName();
            if (fieldName == null) continue;
            names.add(fieldName);
        }
        return names;
    }
}

