/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto;

import eu.europa.esig.dss.spi.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.tsl.dto.AbstractCacheDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DownloadCacheDTO
extends AbstractCacheDTO
implements DownloadInfoRecord {
    private static final long serialVersionUID = 514589372769360786L;

    public DownloadCacheDTO() {
    }

    public DownloadCacheDTO(AbstractCacheDTO cacheDTO) {
        super(cacheDTO);
    }

    public Date getLastDownloadAttemptTime() {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(this.getLastSuccessSynchronizationTime());
        dates.add(this.getExceptionLastOccurrenceTime());
        dates.add(this.getLastStateTransitionTime());
        return this.compareDates(dates);
    }

    private Date compareDates(List<Date> dates) {
        Optional<Date> maxDate = dates.stream().filter(Objects::nonNull).max(Date::compareTo);
        if (maxDate.isPresent()) {
            return maxDate.get();
        }
        throw new IllegalStateException("All dates are null");
    }
}

