/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.barcode.XEasyPdfBarCode;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

class XEasyPdfBarCodeParam
implements Serializable {
    private static final long serialVersionUID = 4749447908058798998L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private XEasyPdfBarCode.CodeType codeType;
    private Integer codeMargin;
    private Color onColor = Color.BLACK;
    private Color offColor = Color.WHITE;
    private String content;
    private String words;
    private Color wordsColor = Color.BLACK;
    private XEasyPdfBarCode.WordsStyle wordsStyle = XEasyPdfBarCode.WordsStyle.NORMAL;
    private Integer wordsSize = 20;
    private Float maxWidth;
    private Integer imageWidth;
    private Integer imageHeight;
    private Integer imageMaxWidth;
    private Integer imageMaxHeight;
    private Double radians;
    private Float beginX = Float.valueOf(0.0f);
    private Float beginY;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight;
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Boolean isShowWords = Boolean.FALSE;
    private final Map<EncodeHintType, Object> encodeHints = new HashMap<EncodeHintType, Object>(8);

    void setEncodeHints(EncodeHintType type, Object value) {
        this.encodeHints.put(type, value);
    }

    void init() {
        this.initEncodeHints();
        this.initWidthAndHeight();
        if (this.isShowWords.booleanValue() && (this.words == null || this.words.trim().length() == 0)) {
            this.words = this.content;
        }
    }

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        this.init();
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        this.initBeginY(document, page, rectangle);
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        if (this.maxWidth == null) {
            this.maxWidth = Float.valueOf(rectangle.getWidth());
        }
        if (this.marginRight != null) {
            XEasyPdfBarCodeParam xEasyPdfBarCodeParam = this;
            xEasyPdfBarCodeParam.beginX = Float.valueOf(xEasyPdfBarCodeParam.beginX.floatValue() + (this.maxWidth.floatValue() - (float)this.imageWidth.intValue() - this.marginRight.floatValue()));
        } else {
            XEasyPdfBarCodeParam xEasyPdfBarCodeParam = this;
            xEasyPdfBarCodeParam.beginX = Float.valueOf(xEasyPdfBarCodeParam.beginX.floatValue() + this.marginLeft.floatValue());
        }
    }

    boolean isRotate() {
        return this.radians != null && this.radians % 360.0 != 0.0;
    }

    private void initEncodeHints() {
        this.initErrorLevel();
        this.encodeHints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        this.encodeHints.put(EncodeHintType.MARGIN, this.codeMargin == null ? this.codeType.margin : this.codeMargin);
    }

    private void initErrorLevel() {
        Object errorLevel = this.encodeHints.get(EncodeHintType.ERROR_CORRECTION);
        if (errorLevel != null) {
            ErrorCorrectionLevel level = (ErrorCorrectionLevel)errorLevel;
            if (BarcodeFormat.AZTEC == this.codeType.codeFormat || BarcodeFormat.PDF_417 == this.codeType.codeFormat) {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, level.getBits());
            }
        } else if (BarcodeFormat.AZTEC == this.codeType.codeFormat || BarcodeFormat.PDF_417 == this.codeType.codeFormat) {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M.getBits());
        } else {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        }
    }

    private void initBeginY(XEasyPdfDocument document, XEasyPdfPage page, PDRectangle rectangle) {
        if (this.beginY == null) {
            float footerHeight = 0.0f;
            if (page.isAllowFooter() && page.getFooter() != null) {
                footerHeight = page.getFooter().getHeight(document, page);
            }
            if (page.getPageY() != null) {
                float initY = page.getPageY() != null ? page.getPageY().floatValue() : rectangle.getHeight();
                this.beginY = Float.valueOf(initY - this.marginTop.floatValue() - (float)this.imageHeight.intValue());
                if (this.beginY.floatValue() - footerHeight <= this.marginBottom.floatValue()) {
                    page.addNewPage(document, rectangle);
                    this.beginY = Float.valueOf(rectangle.getHeight() - this.marginTop.floatValue() - (float)this.imageHeight.intValue());
                }
            } else {
                this.beginY = Float.valueOf(rectangle.getHeight() - this.marginTop.floatValue() - (float)this.imageHeight.intValue());
            }
        }
    }

    private void initWidthAndHeight() {
        if (this.imageWidth == null) {
            this.imageWidth = this.codeType.isQrType() ? 100 : 180;
        }
        if (this.imageHeight == null) {
            this.imageHeight = this.codeType.isQrType() ? this.imageWidth : 60;
        }
        if (this.imageMaxWidth == null || this.imageMaxWidth < this.imageWidth) {
            this.imageMaxWidth = this.imageWidth;
        }
        if (this.imageMaxHeight == null || this.imageMaxHeight < this.imageHeight) {
            this.imageMaxHeight = this.imageHeight;
        }
    }

    void resetBeginY(int height) {
        this.beginY = Float.valueOf(this.beginY.floatValue() + (float)this.imageHeight.intValue() - (float)height);
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public XEasyPdfBarCode.CodeType getCodeType() {
        return this.codeType;
    }

    public Integer getCodeMargin() {
        return this.codeMargin;
    }

    public Color getOnColor() {
        return this.onColor;
    }

    public Color getOffColor() {
        return this.offColor;
    }

    public String getContent() {
        return this.content;
    }

    public String getWords() {
        return this.words;
    }

    public Color getWordsColor() {
        return this.wordsColor;
    }

    public XEasyPdfBarCode.WordsStyle getWordsStyle() {
        return this.wordsStyle;
    }

    public Integer getWordsSize() {
        return this.wordsSize;
    }

    public Float getMaxWidth() {
        return this.maxWidth;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public Integer getImageMaxWidth() {
        return this.imageMaxWidth;
    }

    public Integer getImageMaxHeight() {
        return this.imageMaxHeight;
    }

    public Double getRadians() {
        return this.radians;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Boolean getIsShowWords() {
        return this.isShowWords;
    }

    public Map<EncodeHintType, Object> getEncodeHints() {
        return this.encodeHints;
    }

    public XEasyPdfBarCodeParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfBarCodeParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfBarCodeParam setCodeType(XEasyPdfBarCode.CodeType codeType) {
        this.codeType = codeType;
        return this;
    }

    public XEasyPdfBarCodeParam setCodeMargin(Integer codeMargin) {
        this.codeMargin = codeMargin;
        return this;
    }

    public XEasyPdfBarCodeParam setOnColor(Color onColor) {
        this.onColor = onColor;
        return this;
    }

    public XEasyPdfBarCodeParam setOffColor(Color offColor) {
        this.offColor = offColor;
        return this;
    }

    public XEasyPdfBarCodeParam setContent(String content) {
        this.content = content;
        return this;
    }

    public XEasyPdfBarCodeParam setWords(String words) {
        this.words = words;
        return this;
    }

    public XEasyPdfBarCodeParam setWordsColor(Color wordsColor) {
        this.wordsColor = wordsColor;
        return this;
    }

    public XEasyPdfBarCodeParam setWordsStyle(XEasyPdfBarCode.WordsStyle wordsStyle) {
        this.wordsStyle = wordsStyle;
        return this;
    }

    public XEasyPdfBarCodeParam setWordsSize(Integer wordsSize) {
        this.wordsSize = wordsSize;
        return this;
    }

    public XEasyPdfBarCodeParam setMaxWidth(Float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public XEasyPdfBarCodeParam setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    public XEasyPdfBarCodeParam setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    public XEasyPdfBarCodeParam setImageMaxWidth(Integer imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
        return this;
    }

    public XEasyPdfBarCodeParam setImageMaxHeight(Integer imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
        return this;
    }

    public XEasyPdfBarCodeParam setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    public XEasyPdfBarCodeParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfBarCodeParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfBarCodeParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfBarCodeParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfBarCodeParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfBarCodeParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfBarCodeParam setIsShowWords(Boolean isShowWords) {
        this.isShowWords = isShowWords;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfBarCodeParam)) {
            return false;
        }
        XEasyPdfBarCodeParam other = (XEasyPdfBarCodeParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Integer this$codeMargin = this.getCodeMargin();
        Integer other$codeMargin = other.getCodeMargin();
        if (this$codeMargin == null ? other$codeMargin != null : !((Object)this$codeMargin).equals(other$codeMargin)) {
            return false;
        }
        Integer this$wordsSize = this.getWordsSize();
        Integer other$wordsSize = other.getWordsSize();
        if (this$wordsSize == null ? other$wordsSize != null : !((Object)this$wordsSize).equals(other$wordsSize)) {
            return false;
        }
        Float this$maxWidth = this.getMaxWidth();
        Float other$maxWidth = other.getMaxWidth();
        if (this$maxWidth == null ? other$maxWidth != null : !((Object)this$maxWidth).equals(other$maxWidth)) {
            return false;
        }
        Integer this$imageWidth = this.getImageWidth();
        Integer other$imageWidth = other.getImageWidth();
        if (this$imageWidth == null ? other$imageWidth != null : !((Object)this$imageWidth).equals(other$imageWidth)) {
            return false;
        }
        Integer this$imageHeight = this.getImageHeight();
        Integer other$imageHeight = other.getImageHeight();
        if (this$imageHeight == null ? other$imageHeight != null : !((Object)this$imageHeight).equals(other$imageHeight)) {
            return false;
        }
        Integer this$imageMaxWidth = this.getImageMaxWidth();
        Integer other$imageMaxWidth = other.getImageMaxWidth();
        if (this$imageMaxWidth == null ? other$imageMaxWidth != null : !((Object)this$imageMaxWidth).equals(other$imageMaxWidth)) {
            return false;
        }
        Integer this$imageMaxHeight = this.getImageMaxHeight();
        Integer other$imageMaxHeight = other.getImageMaxHeight();
        if (this$imageMaxHeight == null ? other$imageMaxHeight != null : !((Object)this$imageMaxHeight).equals(other$imageMaxHeight)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Boolean this$isShowWords = this.getIsShowWords();
        Boolean other$isShowWords = other.getIsShowWords();
        if (this$isShowWords == null ? other$isShowWords != null : !((Object)this$isShowWords).equals(other$isShowWords)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        XEasyPdfBarCode.CodeType this$codeType = this.getCodeType();
        XEasyPdfBarCode.CodeType other$codeType = other.getCodeType();
        if (this$codeType == null ? other$codeType != null : !((Object)((Object)this$codeType)).equals((Object)other$codeType)) {
            return false;
        }
        Color this$onColor = this.getOnColor();
        Color other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !((Object)this$onColor).equals(other$onColor)) {
            return false;
        }
        Color this$offColor = this.getOffColor();
        Color other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !((Object)this$offColor).equals(other$offColor)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$words = this.getWords();
        String other$words = other.getWords();
        if (this$words == null ? other$words != null : !this$words.equals(other$words)) {
            return false;
        }
        Color this$wordsColor = this.getWordsColor();
        Color other$wordsColor = other.getWordsColor();
        if (this$wordsColor == null ? other$wordsColor != null : !((Object)this$wordsColor).equals(other$wordsColor)) {
            return false;
        }
        XEasyPdfBarCode.WordsStyle this$wordsStyle = this.getWordsStyle();
        XEasyPdfBarCode.WordsStyle other$wordsStyle = other.getWordsStyle();
        if (this$wordsStyle == null ? other$wordsStyle != null : !((Object)((Object)this$wordsStyle)).equals((Object)other$wordsStyle)) {
            return false;
        }
        Map<EncodeHintType, Object> this$encodeHints = this.getEncodeHints();
        Map<EncodeHintType, Object> other$encodeHints = other.getEncodeHints();
        return !(this$encodeHints == null ? other$encodeHints != null : !((Object)this$encodeHints).equals(other$encodeHints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfBarCodeParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Integer $codeMargin = this.getCodeMargin();
        result = result * 59 + ($codeMargin == null ? 43 : ((Object)$codeMargin).hashCode());
        Integer $wordsSize = this.getWordsSize();
        result = result * 59 + ($wordsSize == null ? 43 : ((Object)$wordsSize).hashCode());
        Float $maxWidth = this.getMaxWidth();
        result = result * 59 + ($maxWidth == null ? 43 : ((Object)$maxWidth).hashCode());
        Integer $imageWidth = this.getImageWidth();
        result = result * 59 + ($imageWidth == null ? 43 : ((Object)$imageWidth).hashCode());
        Integer $imageHeight = this.getImageHeight();
        result = result * 59 + ($imageHeight == null ? 43 : ((Object)$imageHeight).hashCode());
        Integer $imageMaxWidth = this.getImageMaxWidth();
        result = result * 59 + ($imageMaxWidth == null ? 43 : ((Object)$imageMaxWidth).hashCode());
        Integer $imageMaxHeight = this.getImageMaxHeight();
        result = result * 59 + ($imageMaxHeight == null ? 43 : ((Object)$imageMaxHeight).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Boolean $isShowWords = this.getIsShowWords();
        result = result * 59 + ($isShowWords == null ? 43 : ((Object)$isShowWords).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        XEasyPdfBarCode.CodeType $codeType = this.getCodeType();
        result = result * 59 + ($codeType == null ? 43 : ((Object)((Object)$codeType)).hashCode());
        Color $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : ((Object)$onColor).hashCode());
        Color $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : ((Object)$offColor).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : $words.hashCode());
        Color $wordsColor = this.getWordsColor();
        result = result * 59 + ($wordsColor == null ? 43 : ((Object)$wordsColor).hashCode());
        XEasyPdfBarCode.WordsStyle $wordsStyle = this.getWordsStyle();
        result = result * 59 + ($wordsStyle == null ? 43 : ((Object)((Object)$wordsStyle)).hashCode());
        Map<EncodeHintType, Object> $encodeHints = this.getEncodeHints();
        result = result * 59 + ($encodeHints == null ? 43 : ((Object)$encodeHints).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfBarCodeParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", codeType=" + (Object)((Object)this.getCodeType()) + ", codeMargin=" + this.getCodeMargin() + ", onColor=" + this.getOnColor() + ", offColor=" + this.getOffColor() + ", content=" + this.getContent() + ", words=" + this.getWords() + ", wordsColor=" + this.getWordsColor() + ", wordsStyle=" + (Object)((Object)this.getWordsStyle()) + ", wordsSize=" + this.getWordsSize() + ", maxWidth=" + this.getMaxWidth() + ", imageWidth=" + this.getImageWidth() + ", imageHeight=" + this.getImageHeight() + ", imageMaxWidth=" + this.getImageMaxWidth() + ", imageMaxHeight=" + this.getImageMaxHeight() + ", radians=" + this.getRadians() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", isShowWords=" + this.getIsShowWords() + ", encodeHints=" + this.getEncodeHints() + ")";
    }
}

