/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.circle;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.circle.XEasyPdfCircle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

class XEasyPdfCircleParam
implements Serializable {
    private static final long serialVersionUID = -3306952717958325982L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float radius;
    private Float beginX;
    private Float beginY;
    private Boolean hasBorder = Boolean.FALSE;
    private Float borderWidth = Float.valueOf(1.0f);
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Boolean checkPage = Boolean.TRUE;
    private Boolean isNewLine = Boolean.TRUE;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        Float pageY;
        if (this.radius == null) {
            throw new RuntimeException("the radius can not be null");
        }
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float footerHeight = 0.0f;
        if (this.beginY == null) {
            if (page.isAllowFooter() && page.getFooter() != null) {
                footerHeight = page.getFooter().getHeight(document, page);
            }
            this.beginY = Float.valueOf((pageY = page.getPageY()) == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.radius.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.radius.floatValue());
        }
        if (this.checkPage.booleanValue() && this.beginY.floatValue() - footerHeight < this.marginBottom.floatValue()) {
            page.addNewPage(document, rectangle);
            pageY = page.getPageY();
            this.beginY = Float.valueOf(pageY == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.radius.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.radius.floatValue());
        }
        if (this.beginX == null) {
            Float pageX = page.getPageX();
            this.beginX = Float.valueOf(pageX == null ? this.marginLeft.floatValue() : pageX.floatValue() + this.marginLeft.floatValue());
        }
    }

    List<XEasyPdfCircle.Point> initDataPoints() {
        ArrayList<XEasyPdfCircle.Point> points = new ArrayList<XEasyPdfCircle.Point>(4);
        points.add(new XEasyPdfCircle.Point(this.beginX, Float.valueOf(this.beginY.floatValue() + this.radius.floatValue())));
        points.add(new XEasyPdfCircle.Point(Float.valueOf(this.beginX.floatValue() + this.radius.floatValue()), this.beginY));
        points.add(new XEasyPdfCircle.Point(this.beginX, Float.valueOf(this.beginY.floatValue() - this.radius.floatValue())));
        points.add(new XEasyPdfCircle.Point(Float.valueOf(this.beginX.floatValue() - this.radius.floatValue()), this.beginY));
        return points;
    }

    List<XEasyPdfCircle.Point> initCtrlPoints(List<XEasyPdfCircle.Point> dataPoints) {
        float offset = this.radius.floatValue() * 0.55191505f;
        ArrayList<XEasyPdfCircle.Point> points = new ArrayList<XEasyPdfCircle.Point>(8);
        XEasyPdfCircle.Point top = dataPoints.get(0);
        points.add(new XEasyPdfCircle.Point(Float.valueOf(top.getX().floatValue() + offset), top.getY()));
        XEasyPdfCircle.Point right = dataPoints.get(1);
        points.add(new XEasyPdfCircle.Point(right.getX(), Float.valueOf(right.getY().floatValue() + offset)));
        points.add(new XEasyPdfCircle.Point(right.getX(), Float.valueOf(right.getY().floatValue() - offset)));
        XEasyPdfCircle.Point bottom = dataPoints.get(2);
        points.add(new XEasyPdfCircle.Point(Float.valueOf(bottom.getX().floatValue() + offset), bottom.getY()));
        points.add(new XEasyPdfCircle.Point(Float.valueOf(bottom.getX().floatValue() - offset), bottom.getY()));
        XEasyPdfCircle.Point left = dataPoints.get(3);
        points.add(new XEasyPdfCircle.Point(left.getX(), Float.valueOf(left.getY().floatValue() - offset)));
        points.add(new XEasyPdfCircle.Point(left.getX(), Float.valueOf(left.getY().floatValue() + offset)));
        points.add(new XEasyPdfCircle.Point(Float.valueOf(top.getX().floatValue() - offset), top.getY()));
        return points;
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getRadius() {
        return this.radius;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Boolean getHasBorder() {
        return this.hasBorder;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Boolean getCheckPage() {
        return this.checkPage;
    }

    public Boolean getIsNewLine() {
        return this.isNewLine;
    }

    public XEasyPdfCircleParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfCircleParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfCircleParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfCircleParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfCircleParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfCircleParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfCircleParam setRadius(Float radius) {
        this.radius = radius;
        return this;
    }

    public XEasyPdfCircleParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfCircleParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfCircleParam setHasBorder(Boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfCircleParam setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfCircleParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfCircleParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfCircleParam setCheckPage(Boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public XEasyPdfCircleParam setIsNewLine(Boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfCircleParam)) {
            return false;
        }
        XEasyPdfCircleParam other = (XEasyPdfCircleParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$radius = this.getRadius();
        Float other$radius = other.getRadius();
        if (this$radius == null ? other$radius != null : !((Object)this$radius).equals(other$radius)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$hasBorder = this.getHasBorder();
        Boolean other$hasBorder = other.getHasBorder();
        if (this$hasBorder == null ? other$hasBorder != null : !((Object)this$hasBorder).equals(other$hasBorder)) {
            return false;
        }
        Float this$borderWidth = this.getBorderWidth();
        Float other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        Boolean this$checkPage = this.getCheckPage();
        Boolean other$checkPage = other.getCheckPage();
        if (this$checkPage == null ? other$checkPage != null : !((Object)this$checkPage).equals(other$checkPage)) {
            return false;
        }
        Boolean this$isNewLine = this.getIsNewLine();
        Boolean other$isNewLine = other.getIsNewLine();
        if (this$isNewLine == null ? other$isNewLine != null : !((Object)this$isNewLine).equals(other$isNewLine)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        return !(this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfCircleParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $radius = this.getRadius();
        result = result * 59 + ($radius == null ? 43 : ((Object)$radius).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $hasBorder = this.getHasBorder();
        result = result * 59 + ($hasBorder == null ? 43 : ((Object)$hasBorder).hashCode());
        Float $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        Boolean $checkPage = this.getCheckPage();
        result = result * 59 + ($checkPage == null ? 43 : ((Object)$checkPage).hashCode());
        Boolean $isNewLine = this.getIsNewLine();
        result = result * 59 + ($isNewLine == null ? 43 : ((Object)$isNewLine).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfCircleParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", radius=" + this.getRadius() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", hasBorder=" + this.getHasBorder() + ", borderWidth=" + this.getBorderWidth() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", checkPage=" + this.getCheckPage() + ", isNewLine=" + this.getIsNewLine() + ")";
    }
}

