/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImageType;
import org.dromara.pdf.pdfbox.util.XEasyPdfImageUtil;

public class XEasyPdfSVGImage
extends XEasyPdfImage {
    private static final long serialVersionUID = 5166066820276019483L;

    public XEasyPdfSVGImage setImageType(XEasyPdfImageType imageType) {
        if (imageType != null) {
            this.getParam().setImageType(imageType.name().toLowerCase());
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XEasyPdfSVGImage setImage(File imageFile) {
        try (FileInputStream imageStream = new FileInputStream(imageFile);){
            this.getParam().setImage(this.processSVG(imageStream));
            XEasyPdfSVGImage xEasyPdfSVGImage = this;
            return xEasyPdfSVGImage;
        }
    }

    @Override
    public XEasyPdfSVGImage setImage(InputStream imageStream, XEasyPdfImageType imageType) {
        this.getParam().setImageType(imageType.name().toLowerCase()).setImage(this.processSVG(imageStream));
        return this;
    }

    private BufferedImage processSVG(InputStream inputStream) {
        BufferedImage image;
        XEasyPdfImageType imageType;
        String imageTypeName = this.getParam().getImageType();
        if (imageTypeName == null) {
            throw new IllegalArgumentException("the image type can not be null");
        }
        try {
            imageType = XEasyPdfImageType.valueOf(imageTypeName.toUpperCase());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("the image type is unsupported: " + imageTypeName);
        }
        switch (imageType) {
            case PNG: {
                image = this.toImage(inputStream, (ImageTranscoder)new PNGTranscoder());
                break;
            }
            case JPEG: {
                image = this.toImage(inputStream, (ImageTranscoder)new JPEGTranscoder());
                break;
            }
            default: {
                image = this.toImage(inputStream, (ImageTranscoder)new TIFFTranscoder());
            }
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage toImage(InputStream inputStream, ImageTranscoder transcoder) {
        TranscoderInput input = new TranscoderInput(inputStream);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            transcoder.transcode(input, new TranscoderOutput((OutputStream)outputStream));
            BufferedImage bufferedImage = XEasyPdfImageUtil.read(outputStream.toByteArray());
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the file is unsupported");
        }
    }
}

