/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.line;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLine;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLineCapStyle;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLineParam;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.util.XEasyPdfFontUtil;

public class XEasyPdfBaseLine
implements XEasyPdfLine {
    private static final long serialVersionUID = -2997710088689093318L;
    private XEasyPdfLineParam param = new XEasyPdfLineParam();

    XEasyPdfBaseLine(XEasyPdfLineParam param) {
        this.param = param;
    }

    public XEasyPdfBaseLine(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
    }

    @Override
    public XEasyPdfBaseLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    @Override
    public XEasyPdfBaseLine setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    @Override
    public XEasyPdfBaseLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(this.param.getBeginX().floatValue() + margin));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(this.param.getBeginX().floatValue() - margin));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(Math.abs(lineWidth)));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setColor(Color color) {
        if (color != null) {
            this.param.setColor(color);
        }
        return this;
    }

    @Override
    public XEasyPdfBaseLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        if (lineCapStyle != null) {
            this.param.setStyle(lineCapStyle);
        }
        return this;
    }

    public XEasyPdfBaseLine setPosition(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setWidth(float width) {
        this.param.setEndX(Float.valueOf(this.param.getBeginX().floatValue() + Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setHeight(float height) {
        this.param.setEndY(Float.valueOf(this.param.getBeginY().floatValue() - Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public float getLineWidth() {
        return this.param.getLineWidth().floatValue();
    }

    @Override
    public XEasyPdfBaseLine enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        PDPageContentStream contentStream = this.initStream(document, page);
        contentStream.moveTo(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue());
        contentStream.setStrokingColor(this.param.getColor());
        contentStream.lineTo(this.param.getEndX().floatValue(), this.param.getEndY().floatValue());
        contentStream.stroke();
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.close();
    }

    private PDPageContentStream initStream(XEasyPdfDocument document, XEasyPdfPage page) {
        this.init(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        contentStream.setFont(XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath(), true), this.param.getFontSize().floatValue());
        contentStream.setLineWidth(this.param.getLineWidth().floatValue());
        contentStream.setLineCapStyle(this.param.getStyle().getType());
        return contentStream;
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        if (this.param.getBeginX() == null) {
            this.param.setBeginX(page.getPageX() == null ? this.param.getMarginLeft() : page.getPageX());
        }
        if (this.param.getBeginY() == null) {
            this.param.setBeginY(page.getPageY() == null ? this.param.getMarginTop() : page.getPageY());
        }
        if (this.param.getEndX() == null) {
            this.param.setEndX(Float.valueOf(rectangle.getWidth()));
        }
        if (this.param.getEndY() == null) {
            this.param.setEndY(Float.valueOf(rectangle.getHeight()));
        }
    }
}

