/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.text;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.XEasyPdfPagingCondition;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfText;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextExtendParam;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextScript;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextScriptType;
import org.dromara.pdf.pdfbox.component.text.XEasypdfTextRenderingMode;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;

public class XEasyPdfTextExtend
implements XEasyPdfComponent {
    private static final long serialVersionUID = -3542039487035427025L;
    private final XEasyPdfTextExtendParam param = new XEasyPdfTextExtendParam();

    public XEasyPdfTextExtend(String text) {
        this.param.setText(text);
    }

    public XEasyPdfTextExtend(String text, String scriptText) {
        this.param.setText(text);
        this.param.setScriptText(scriptText);
    }

    public XEasyPdfTextExtend enableTextAppend() {
        this.param.setIsTextAppend(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfTextExtend enableChildComponent() {
        this.param.setIsChildComponent(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableUnderline() {
        this.param.setIsUnderline(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableDeleteLine() {
        this.param.setIsDeleteLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableHighlight() {
        this.param.setIsHighlight(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableRotateLine() {
        this.param.setIsRotateLine(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfTextExtend enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend enableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextExtend disableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.FALSE);
        return this;
    }

    public XEasyPdfTextExtend setAutoIndent(int indent) {
        this.param.setIndent(Math.abs(indent));
        return this;
    }

    public XEasyPdfTextExtend setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextExtend setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextExtend setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextExtend setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextExtend setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextExtend setLeading(float leading) {
        this.param.setLeading(Float.valueOf(Math.abs(leading)));
        return this;
    }

    public XEasyPdfTextExtend setCharacterSpacing(float characterSpacing) {
        this.param.setCharacterSpacing(Float.valueOf(Math.abs(characterSpacing)));
        return this;
    }

    public XEasyPdfTextExtend setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfTextExtend setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfTextExtend setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfTextExtend setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfTextExtend setHighlightColor(Color highlightColor) {
        if (highlightColor != null) {
            this.param.setHighlightColor(highlightColor);
        }
        return this;
    }

    public XEasyPdfTextExtend setUnderlineColor(Color underlineColor) {
        if (underlineColor != null) {
            this.param.setUnderlineColor(underlineColor);
        }
        return this;
    }

    public XEasyPdfTextExtend setUnderlineWidth(float underlineWidth) {
        this.param.setUnderlineWidth(Float.valueOf(Math.abs(underlineWidth)));
        return this;
    }

    public XEasyPdfTextExtend setDeleteLineColor(Color deleteLineColor) {
        if (deleteLineColor != null) {
            this.param.setDeleteLineColor(deleteLineColor);
        }
        return this;
    }

    public XEasyPdfTextExtend setDeleteLineWidth(float deleteLineWidth) {
        this.param.setDeleteLineWidth(Float.valueOf(Math.abs(deleteLineWidth)));
        return this;
    }

    public XEasyPdfTextExtend setLink(String linkUrl) {
        this.param.setLinkUrl(linkUrl);
        return this;
    }

    public XEasyPdfTextExtend setComment(String comment) {
        this.param.setComment(comment);
        return this;
    }

    public XEasyPdfTextExtend setAlpha(float alpha) {
        if (alpha >= 0.0f && alpha <= 1.0f) {
            this.param.setAlpha(Float.valueOf(alpha));
        }
        return this;
    }

    public XEasyPdfTextExtend setRadians(double radians) {
        boolean min = false;
        int max = 360;
        if (radians % 360.0 != 0.0) {
            if ((radians %= 360.0) < 0.0) {
                radians += 360.0;
            }
            this.param.setRadians(radians);
        }
        return this;
    }

    public XEasyPdfTextExtend setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkHorizontalStyle(style);
            this.param.setHorizontalStyle(style);
        }
        return this;
    }

    public XEasyPdfTextExtend setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkVerticalStyle(style);
            this.param.setVerticalStyle(style);
        }
        return this;
    }

    public XEasyPdfTextExtend setSplitTextList(List<String> splitTextList) {
        if (splitTextList != null) {
            this.param.setSplitTextList(new ArrayList<String>(splitTextList)).setSplitTemplateTextList(new ArrayList<String>(splitTextList));
        }
        return this;
    }

    public XEasyPdfTextExtend setReplaceCharacters(String oldValue, String replacement) {
        if (oldValue != null && replacement != null) {
            this.param.getReplaceCharacterMap().put(oldValue, replacement);
        }
        return this;
    }

    public XEasyPdfTextExtend setReplaceCharacters(Map<String, String> replaceMap) {
        if (replaceMap != null && !replaceMap.isEmpty()) {
            this.param.getReplaceCharacterMap().putAll(replaceMap);
        }
        return this;
    }

    public XEasyPdfTextExtend setNewLine(boolean isNewLine) {
        this.param.setIsNewLine(isNewLine);
        return this;
    }

    public XEasyPdfTextExtend setCheckPage(boolean isCheckPage) {
        this.param.setCheckPage(isCheckPage);
        return this;
    }

    @Override
    public XEasyPdfTextExtend setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfTextExtend setWidth(float width) {
        this.param.setMaxWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfTextExtend setHeight(float height) {
        this.param.setMaxHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfTextExtend setMaxHeight(Float maxHeight) {
        this.param.setMaxHeight(maxHeight);
        return this;
    }

    @Override
    public XEasyPdfTextExtend setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfTextExtend setRenderingMode(XEasypdfTextRenderingMode renderingMode) {
        if (renderingMode != null) {
            this.param.setRenderingMode(renderingMode);
        }
        return this;
    }

    public XEasyPdfTextExtend setPagingCondition(XEasyPdfPagingCondition pagingCondition) {
        this.param.setPagingCondition(pagingCondition);
        return this;
    }

    public XEasyPdfTextExtend setNeedInitialize(boolean needInitialize) {
        this.param.setIsNeedInitialize(needInitialize);
        return this;
    }

    public XEasyPdfTextExtend setFontScaleRatio(float fontScaleRatio) {
        float ratio = Math.abs(fontScaleRatio);
        float max = 0.7f;
        float min = 0.1f;
        this.param.setFontScaleRatio(Float.valueOf(Math.min(max, Math.max(ratio, min))));
        return this;
    }

    public XEasyPdfTextExtend setScriptType(XEasyPdfTextScriptType scriptType) {
        this.param.setScriptType(scriptType);
        return this;
    }

    public XEasyPdfTextExtend setScriptType(String scriptText) {
        this.param.setScriptText(scriptText);
        return this;
    }

    public XEasyPdfTextExtend replaceAllPlaceholder(String placeholder, String value) {
        List<String> textList = this.param.getSplitTextList();
        List<String> templateTextList = this.param.getSplitTemplateTextList();
        int count = textList.size();
        for (int i = 0; i < count; ++i) {
            textList.set(i, templateTextList.get(i).replace(placeholder, value));
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        new XEasyPdfText(this.param).draw(document, page);
        if (this.param.getScriptText() != null) {
            this.param.setText(this.param.getScriptText()).setSplitTextList(null).setSplitTemplateTextList(null);
            new XEasyPdfTextScript(this.param).draw(document, page);
        }
    }

    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getHeight(document, page);
    }

    public float getWidth(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getWidth(document, page);
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.param.getContentMode();
    }

    float getBeginY() {
        return this.param.getBeginY().floatValue();
    }

    public float getMarginTop() {
        return this.param.getMarginTop().floatValue();
    }

    public float getMarginBottom() {
        return this.param.getMarginBottom().floatValue();
    }

    public float getMarginLeft() {
        return this.param.getMarginLeft().floatValue();
    }

    public float getMarginRight() {
        return this.param.getMarginRight().floatValue();
    }

    public List<String> getSplitTextList() {
        return this.param.getSplitTextList();
    }

    public float getFontSize() {
        return this.param.getFontSize().floatValue();
    }

    public String getFontPath() {
        return this.param.getFontPath();
    }

    public float getLeading() {
        return this.param.getLeading().floatValue();
    }

    public float getCharacterSpacing() {
        return this.param.getCharacterSpacing().floatValue();
    }

    public float getAlpha() {
        return this.param.getAlpha().floatValue();
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.param.getHorizontalStyle();
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.param.getVerticalStyle();
    }
}

