/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.text;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.XEasyPdfPagingCondition;
import org.dromara.pdf.pdfbox.component.text.XEasypdfTextRenderingMode;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;
import org.dromara.pdf.pdfbox.util.XEasyPdfFontUtil;
import org.dromara.pdf.pdfbox.util.XEasyPdfTextUtil;

class XEasyPdfTextParam
implements Serializable {
    private static final long serialVersionUID = 8028404070423440838L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private String fontPath;
    private Float fontSize = Float.valueOf(12.0f);
    private Float fontScaleRatio;
    private Float fontHeight;
    private Float leading = Float.valueOf(5.0f);
    private Float characterSpacing = Float.valueOf(0.0f);
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float maxWidth;
    private Float maxHeight;
    private Integer indent;
    private String text;
    private List<String> splitTextList;
    private List<String> splitTemplateTextList;
    private Map<String, String> replaceCharacterMap = this.initReplaceCharacterMap();
    private XEasyPdfPositionStyle horizontalStyle = XEasyPdfPositionStyle.LEFT;
    private XEasyPdfPositionStyle verticalStyle = XEasyPdfPositionStyle.TOP;
    private Float beginX;
    private Float beginY;
    private Color fontColor = Color.BLACK;
    private Color underlineColor;
    private Color deleteLineColor;
    private Color highlightColor = Color.ORANGE;
    private Float underlineWidth = Float.valueOf(1.0f);
    private Float deleteLineWidth = Float.valueOf(1.0f);
    private Float alpha = Float.valueOf(1.0f);
    private Double radians = 0.0;
    private String linkUrl;
    private String comment;
    private Boolean useSelfStyle = Boolean.FALSE;
    private Boolean isNewLine = Boolean.TRUE;
    private Boolean checkPage = Boolean.TRUE;
    private Boolean isTextAppend = Boolean.FALSE;
    private Boolean isChildComponent = Boolean.FALSE;
    private Boolean isUnderline = Boolean.FALSE;
    private Boolean isDeleteLine = Boolean.FALSE;
    private Boolean isHighlight = Boolean.FALSE;
    private Boolean isRotateLine = Boolean.FALSE;
    private Boolean isNeedInitialize = Boolean.TRUE;
    private XEasypdfTextRenderingMode renderingMode;
    private XEasyPdfPagingCondition pagingCondition;

    float getWidth(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.maxWidth != null) {
            return this.maxWidth.floatValue();
        }
        this.init(document, page);
        return this.maxWidth.floatValue();
    }

    float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.maxHeight != null) {
            return this.maxHeight.floatValue();
        }
        this.init(document, page);
        return (this.fontHeight.floatValue() + this.leading.floatValue()) * (float)this.splitTextList.size() - this.marginTop.floatValue() - this.marginBottom.floatValue();
    }

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        if (this.maxWidth == null) {
            this.maxWidth = Float.valueOf(rectangle.getWidth());
        }
        if (this.renderingMode == null) {
            this.renderingMode = XEasypdfTextRenderingMode.NORMAL;
        }
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        if (this.fontPath == null) {
            this.fontPath = page.getFontPath();
        }
        if (this.fontScaleRatio == null) {
            this.fontScaleRatio = Float.valueOf(1.0f);
        }
        this.fontHeight = this.fontSize;
        if (this.underlineColor == null) {
            this.underlineColor = this.fontColor;
        }
        if (this.deleteLineColor == null) {
            this.deleteLineColor = this.fontColor;
        }
        this.initTextList(document, page);
        if (this.maxHeight == null) {
            this.maxHeight = Float.valueOf((this.fontHeight.floatValue() + this.leading.floatValue()) * (float)this.splitTextList.size() - this.marginTop.floatValue() - this.marginBottom.floatValue());
        }
        this.initBeginY(document, page);
    }

    Float initBeginX(XEasyPdfDocument document, XEasyPdfPage page, String text) {
        Float x = this.beginX;
        x = x == null ? (this.isTextAppend.booleanValue() ? Float.valueOf(this.marginLeft.floatValue() + (page.getPageX() == null ? 0.0f : page.getPageX().floatValue())) : Float.valueOf(this.initBeginXForStyle(document, page, text))) : Float.valueOf(x.floatValue() + this.initBeginXForStyle(document, page, text));
        return x;
    }

    float initBeginXForStyle(XEasyPdfDocument document, XEasyPdfPage page, String text) {
        if (this.horizontalStyle == XEasyPdfPositionStyle.LEFT) {
            return this.marginLeft.floatValue();
        }
        PDFont font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath, true);
        if (this.horizontalStyle == XEasyPdfPositionStyle.CENTER) {
            return (this.maxWidth.floatValue() - (this.fontSize.floatValue() * font.getStringWidth(text) / 1000.0f + this.characterSpacing.floatValue() * (float)text.length())) / 2.0f + this.marginLeft.floatValue() - this.marginRight.floatValue();
        }
        return this.maxWidth.floatValue() - (this.fontSize.floatValue() * font.getStringWidth(text) / 1000.0f + this.characterSpacing.floatValue() * (float)text.length()) + this.marginLeft.floatValue() - this.marginRight.floatValue();
    }

    private Map<String, String> initReplaceCharacterMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("\n", "");
        map.put("\r", "");
        map.put("\t", "");
        map.put("\b", "");
        map.put("\f", "");
        return map;
    }

    private void initBeginY(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.beginY != null) {
            this.beginY = Float.valueOf(this.beginY.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue());
            return;
        }
        Float pageY = page.getPageY();
        if (pageY == null) {
            pageY = Float.valueOf(page.getLastPage().getMediaBox().getHeight());
        }
        if (this.isTextAppend.booleanValue()) {
            this.beginY = Float.valueOf(pageY.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue());
            return;
        }
        if (this.verticalStyle == XEasyPdfPositionStyle.TOP) {
            this.beginY = Float.valueOf(pageY.floatValue() - this.fontHeight.floatValue() - this.leading.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue());
            return;
        }
        if (this.verticalStyle == XEasyPdfPositionStyle.CENTER) {
            this.beginY = Float.valueOf(pageY.floatValue() - (pageY.floatValue() - this.maxHeight.floatValue()) / 2.0f - this.leading.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue());
            return;
        }
        if (this.verticalStyle == XEasyPdfPositionStyle.BOTTOM) {
            float footerHeight = 0.0f;
            if (page.isAllowFooter() && page.getFooter() != null) {
                footerHeight = page.getFooter().getHeight(document, page);
            }
            this.beginY = pageY.floatValue() - this.maxHeight.floatValue() < footerHeight ? Float.valueOf(pageY.floatValue() - this.fontHeight.floatValue() - this.leading.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue()) : Float.valueOf(footerHeight + this.maxHeight.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue() + 0.01f);
        }
    }

    private float initTextX(XEasyPdfPage page) {
        float x = 0.0f;
        if (this.indent != null) {
            x += (float)this.indent.intValue() * (this.fontSize.floatValue() + this.characterSpacing.floatValue());
        }
        x = this.isTextAppend.booleanValue() ? (this.beginX == null ? (x += page.getPageX() == null ? this.marginLeft.floatValue() : page.getPageX().floatValue() + this.marginLeft.floatValue()) : (x += this.beginX.floatValue())) : (x += this.marginLeft.floatValue());
        return x;
    }

    private void initTextList(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.splitTextList == null) {
            this.text = this.processText(this.text);
            float x = this.initTextX(page);
            PDFont font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath, true);
            String firstLineText = XEasyPdfTextUtil.splitText(this.text, this.maxWidth.floatValue() - x - this.marginRight.floatValue(), font, this.fontSize.floatValue() * this.fontScaleRatio.floatValue(), this.characterSpacing.floatValue());
            this.initTextList(page, font, firstLineText);
        } else {
            this.splitTextList = this.processTextList(this.splitTextList);
        }
        if (this.splitTemplateTextList == null) {
            this.splitTemplateTextList = new ArrayList<String>(this.splitTextList);
        }
    }

    private void initTextList(XEasyPdfPage page, PDFont font, String firstLineText) {
        if (firstLineText != null) {
            this.splitTextList = new ArrayList<String>(128);
            this.splitTextList.add(firstLineText);
            if (firstLineText.length() < this.text.length()) {
                this.splitTextList.addAll(XEasyPdfTextUtil.splitLines(this.text.substring(firstLineText.length()), this.maxWidth.floatValue() - this.marginLeft.floatValue() - this.marginRight.floatValue(), font, this.fontSize.floatValue() * this.fontScaleRatio.floatValue(), this.characterSpacing.floatValue()));
            }
        } else {
            this.splitTextList = XEasyPdfTextUtil.splitLines(this.text, this.maxWidth.floatValue() - this.marginLeft.floatValue() - this.marginRight.floatValue(), font, this.fontSize.floatValue() * this.fontScaleRatio.floatValue(), this.characterSpacing.floatValue());
            this.beginX = this.marginLeft;
            page.setPageX(null);
        }
    }

    private String processText(String text) {
        if (XEasyPdfTextUtil.isNotBlank(text)) {
            return XEasyPdfTextUtil.replaceAll(text, this.replaceCharacterMap);
        }
        return text;
    }

    private List<String> processTextList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> replaceList = new ArrayList<String>(this.splitTextList.size());
        for (String text : list) {
            replaceList.add(this.processText(text));
        }
        return replaceList;
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Float getFontScaleRatio() {
        return this.fontScaleRatio;
    }

    public Float getFontHeight() {
        return this.fontHeight;
    }

    public Float getLeading() {
        return this.leading;
    }

    public Float getCharacterSpacing() {
        return this.characterSpacing;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getMaxWidth() {
        return this.maxWidth;
    }

    public Float getMaxHeight() {
        return this.maxHeight;
    }

    public Integer getIndent() {
        return this.indent;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getSplitTextList() {
        return this.splitTextList;
    }

    public List<String> getSplitTemplateTextList() {
        return this.splitTemplateTextList;
    }

    public Map<String, String> getReplaceCharacterMap() {
        return this.replaceCharacterMap;
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.horizontalStyle;
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.verticalStyle;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public Color getDeleteLineColor() {
        return this.deleteLineColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Float getUnderlineWidth() {
        return this.underlineWidth;
    }

    public Float getDeleteLineWidth() {
        return this.deleteLineWidth;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Double getRadians() {
        return this.radians;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean getUseSelfStyle() {
        return this.useSelfStyle;
    }

    public Boolean getIsNewLine() {
        return this.isNewLine;
    }

    public Boolean getCheckPage() {
        return this.checkPage;
    }

    public Boolean getIsTextAppend() {
        return this.isTextAppend;
    }

    public Boolean getIsChildComponent() {
        return this.isChildComponent;
    }

    public Boolean getIsUnderline() {
        return this.isUnderline;
    }

    public Boolean getIsDeleteLine() {
        return this.isDeleteLine;
    }

    public Boolean getIsHighlight() {
        return this.isHighlight;
    }

    public Boolean getIsRotateLine() {
        return this.isRotateLine;
    }

    public Boolean getIsNeedInitialize() {
        return this.isNeedInitialize;
    }

    public XEasypdfTextRenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public XEasyPdfPagingCondition getPagingCondition() {
        return this.pagingCondition;
    }

    public XEasyPdfTextParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfTextParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfTextParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfTextParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfTextParam setFontScaleRatio(Float fontScaleRatio) {
        this.fontScaleRatio = fontScaleRatio;
        return this;
    }

    public XEasyPdfTextParam setFontHeight(Float fontHeight) {
        this.fontHeight = fontHeight;
        return this;
    }

    public XEasyPdfTextParam setLeading(Float leading) {
        this.leading = leading;
        return this;
    }

    public XEasyPdfTextParam setCharacterSpacing(Float characterSpacing) {
        this.characterSpacing = characterSpacing;
        return this;
    }

    public XEasyPdfTextParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfTextParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfTextParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfTextParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfTextParam setMaxWidth(Float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public XEasyPdfTextParam setMaxHeight(Float maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public XEasyPdfTextParam setIndent(Integer indent) {
        this.indent = indent;
        return this;
    }

    public XEasyPdfTextParam setText(String text) {
        this.text = text;
        return this;
    }

    public XEasyPdfTextParam setSplitTextList(List<String> splitTextList) {
        this.splitTextList = splitTextList;
        return this;
    }

    public XEasyPdfTextParam setSplitTemplateTextList(List<String> splitTemplateTextList) {
        this.splitTemplateTextList = splitTemplateTextList;
        return this;
    }

    public XEasyPdfTextParam setReplaceCharacterMap(Map<String, String> replaceCharacterMap) {
        this.replaceCharacterMap = replaceCharacterMap;
        return this;
    }

    public XEasyPdfTextParam setHorizontalStyle(XEasyPdfPositionStyle horizontalStyle) {
        this.horizontalStyle = horizontalStyle;
        return this;
    }

    public XEasyPdfTextParam setVerticalStyle(XEasyPdfPositionStyle verticalStyle) {
        this.verticalStyle = verticalStyle;
        return this;
    }

    public XEasyPdfTextParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfTextParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfTextParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfTextParam setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
        return this;
    }

    public XEasyPdfTextParam setDeleteLineColor(Color deleteLineColor) {
        this.deleteLineColor = deleteLineColor;
        return this;
    }

    public XEasyPdfTextParam setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
        return this;
    }

    public XEasyPdfTextParam setUnderlineWidth(Float underlineWidth) {
        this.underlineWidth = underlineWidth;
        return this;
    }

    public XEasyPdfTextParam setDeleteLineWidth(Float deleteLineWidth) {
        this.deleteLineWidth = deleteLineWidth;
        return this;
    }

    public XEasyPdfTextParam setAlpha(Float alpha) {
        this.alpha = alpha;
        return this;
    }

    public XEasyPdfTextParam setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    public XEasyPdfTextParam setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
        return this;
    }

    public XEasyPdfTextParam setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public XEasyPdfTextParam setUseSelfStyle(Boolean useSelfStyle) {
        this.useSelfStyle = useSelfStyle;
        return this;
    }

    public XEasyPdfTextParam setIsNewLine(Boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public XEasyPdfTextParam setCheckPage(Boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public XEasyPdfTextParam setIsTextAppend(Boolean isTextAppend) {
        this.isTextAppend = isTextAppend;
        return this;
    }

    public XEasyPdfTextParam setIsChildComponent(Boolean isChildComponent) {
        this.isChildComponent = isChildComponent;
        return this;
    }

    public XEasyPdfTextParam setIsUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
        return this;
    }

    public XEasyPdfTextParam setIsDeleteLine(Boolean isDeleteLine) {
        this.isDeleteLine = isDeleteLine;
        return this;
    }

    public XEasyPdfTextParam setIsHighlight(Boolean isHighlight) {
        this.isHighlight = isHighlight;
        return this;
    }

    public XEasyPdfTextParam setIsRotateLine(Boolean isRotateLine) {
        this.isRotateLine = isRotateLine;
        return this;
    }

    public XEasyPdfTextParam setIsNeedInitialize(Boolean isNeedInitialize) {
        this.isNeedInitialize = isNeedInitialize;
        return this;
    }

    public XEasyPdfTextParam setRenderingMode(XEasypdfTextRenderingMode renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    public XEasyPdfTextParam setPagingCondition(XEasyPdfPagingCondition pagingCondition) {
        this.pagingCondition = pagingCondition;
        return this;
    }

    public String toString() {
        return "XEasyPdfTextParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", fontPath=" + this.getFontPath() + ", fontSize=" + this.getFontSize() + ", fontScaleRatio=" + this.getFontScaleRatio() + ", fontHeight=" + this.getFontHeight() + ", leading=" + this.getLeading() + ", characterSpacing=" + this.getCharacterSpacing() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", maxWidth=" + this.getMaxWidth() + ", maxHeight=" + this.getMaxHeight() + ", indent=" + this.getIndent() + ", text=" + this.getText() + ", splitTextList=" + this.getSplitTextList() + ", splitTemplateTextList=" + this.getSplitTemplateTextList() + ", replaceCharacterMap=" + this.getReplaceCharacterMap() + ", horizontalStyle=" + (Object)((Object)this.getHorizontalStyle()) + ", verticalStyle=" + (Object)((Object)this.getVerticalStyle()) + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontColor=" + this.getFontColor() + ", underlineColor=" + this.getUnderlineColor() + ", deleteLineColor=" + this.getDeleteLineColor() + ", highlightColor=" + this.getHighlightColor() + ", underlineWidth=" + this.getUnderlineWidth() + ", deleteLineWidth=" + this.getDeleteLineWidth() + ", alpha=" + this.getAlpha() + ", radians=" + this.getRadians() + ", linkUrl=" + this.getLinkUrl() + ", comment=" + this.getComment() + ", useSelfStyle=" + this.getUseSelfStyle() + ", isNewLine=" + this.getIsNewLine() + ", checkPage=" + this.getCheckPage() + ", isTextAppend=" + this.getIsTextAppend() + ", isChildComponent=" + this.getIsChildComponent() + ", isUnderline=" + this.getIsUnderline() + ", isDeleteLine=" + this.getIsDeleteLine() + ", isHighlight=" + this.getIsHighlight() + ", isRotateLine=" + this.getIsRotateLine() + ", isNeedInitialize=" + this.getIsNeedInitialize() + ", renderingMode=" + (Object)((Object)this.getRenderingMode()) + ", pagingCondition=" + this.getPagingCondition() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTextParam)) {
            return false;
        }
        XEasyPdfTextParam other = (XEasyPdfTextParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$fontScaleRatio = this.getFontScaleRatio();
        Float other$fontScaleRatio = other.getFontScaleRatio();
        if (this$fontScaleRatio == null ? other$fontScaleRatio != null : !((Object)this$fontScaleRatio).equals(other$fontScaleRatio)) {
            return false;
        }
        Float this$fontHeight = this.getFontHeight();
        Float other$fontHeight = other.getFontHeight();
        if (this$fontHeight == null ? other$fontHeight != null : !((Object)this$fontHeight).equals(other$fontHeight)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        Float this$characterSpacing = this.getCharacterSpacing();
        Float other$characterSpacing = other.getCharacterSpacing();
        if (this$characterSpacing == null ? other$characterSpacing != null : !((Object)this$characterSpacing).equals(other$characterSpacing)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$maxWidth = this.getMaxWidth();
        Float other$maxWidth = other.getMaxWidth();
        if (this$maxWidth == null ? other$maxWidth != null : !((Object)this$maxWidth).equals(other$maxWidth)) {
            return false;
        }
        Float this$maxHeight = this.getMaxHeight();
        Float other$maxHeight = other.getMaxHeight();
        if (this$maxHeight == null ? other$maxHeight != null : !((Object)this$maxHeight).equals(other$maxHeight)) {
            return false;
        }
        Integer this$indent = this.getIndent();
        Integer other$indent = other.getIndent();
        if (this$indent == null ? other$indent != null : !((Object)this$indent).equals(other$indent)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$underlineWidth = this.getUnderlineWidth();
        Float other$underlineWidth = other.getUnderlineWidth();
        if (this$underlineWidth == null ? other$underlineWidth != null : !((Object)this$underlineWidth).equals(other$underlineWidth)) {
            return false;
        }
        Float this$deleteLineWidth = this.getDeleteLineWidth();
        Float other$deleteLineWidth = other.getDeleteLineWidth();
        if (this$deleteLineWidth == null ? other$deleteLineWidth != null : !((Object)this$deleteLineWidth).equals(other$deleteLineWidth)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        Boolean this$useSelfStyle = this.getUseSelfStyle();
        Boolean other$useSelfStyle = other.getUseSelfStyle();
        if (this$useSelfStyle == null ? other$useSelfStyle != null : !((Object)this$useSelfStyle).equals(other$useSelfStyle)) {
            return false;
        }
        Boolean this$isNewLine = this.getIsNewLine();
        Boolean other$isNewLine = other.getIsNewLine();
        if (this$isNewLine == null ? other$isNewLine != null : !((Object)this$isNewLine).equals(other$isNewLine)) {
            return false;
        }
        Boolean this$checkPage = this.getCheckPage();
        Boolean other$checkPage = other.getCheckPage();
        if (this$checkPage == null ? other$checkPage != null : !((Object)this$checkPage).equals(other$checkPage)) {
            return false;
        }
        Boolean this$isTextAppend = this.getIsTextAppend();
        Boolean other$isTextAppend = other.getIsTextAppend();
        if (this$isTextAppend == null ? other$isTextAppend != null : !((Object)this$isTextAppend).equals(other$isTextAppend)) {
            return false;
        }
        Boolean this$isChildComponent = this.getIsChildComponent();
        Boolean other$isChildComponent = other.getIsChildComponent();
        if (this$isChildComponent == null ? other$isChildComponent != null : !((Object)this$isChildComponent).equals(other$isChildComponent)) {
            return false;
        }
        Boolean this$isUnderline = this.getIsUnderline();
        Boolean other$isUnderline = other.getIsUnderline();
        if (this$isUnderline == null ? other$isUnderline != null : !((Object)this$isUnderline).equals(other$isUnderline)) {
            return false;
        }
        Boolean this$isDeleteLine = this.getIsDeleteLine();
        Boolean other$isDeleteLine = other.getIsDeleteLine();
        if (this$isDeleteLine == null ? other$isDeleteLine != null : !((Object)this$isDeleteLine).equals(other$isDeleteLine)) {
            return false;
        }
        Boolean this$isHighlight = this.getIsHighlight();
        Boolean other$isHighlight = other.getIsHighlight();
        if (this$isHighlight == null ? other$isHighlight != null : !((Object)this$isHighlight).equals(other$isHighlight)) {
            return false;
        }
        Boolean this$isRotateLine = this.getIsRotateLine();
        Boolean other$isRotateLine = other.getIsRotateLine();
        if (this$isRotateLine == null ? other$isRotateLine != null : !((Object)this$isRotateLine).equals(other$isRotateLine)) {
            return false;
        }
        Boolean this$isNeedInitialize = this.getIsNeedInitialize();
        Boolean other$isNeedInitialize = other.getIsNeedInitialize();
        if (this$isNeedInitialize == null ? other$isNeedInitialize != null : !((Object)this$isNeedInitialize).equals(other$isNeedInitialize)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$splitTextList = this.getSplitTextList();
        List<String> other$splitTextList = other.getSplitTextList();
        if (this$splitTextList == null ? other$splitTextList != null : !((Object)this$splitTextList).equals(other$splitTextList)) {
            return false;
        }
        List<String> this$splitTemplateTextList = this.getSplitTemplateTextList();
        List<String> other$splitTemplateTextList = other.getSplitTemplateTextList();
        if (this$splitTemplateTextList == null ? other$splitTemplateTextList != null : !((Object)this$splitTemplateTextList).equals(other$splitTemplateTextList)) {
            return false;
        }
        Map<String, String> this$replaceCharacterMap = this.getReplaceCharacterMap();
        Map<String, String> other$replaceCharacterMap = other.getReplaceCharacterMap();
        if (this$replaceCharacterMap == null ? other$replaceCharacterMap != null : !((Object)this$replaceCharacterMap).equals(other$replaceCharacterMap)) {
            return false;
        }
        XEasyPdfPositionStyle this$horizontalStyle = this.getHorizontalStyle();
        XEasyPdfPositionStyle other$horizontalStyle = other.getHorizontalStyle();
        if (this$horizontalStyle == null ? other$horizontalStyle != null : !((Object)((Object)this$horizontalStyle)).equals((Object)other$horizontalStyle)) {
            return false;
        }
        XEasyPdfPositionStyle this$verticalStyle = this.getVerticalStyle();
        XEasyPdfPositionStyle other$verticalStyle = other.getVerticalStyle();
        if (this$verticalStyle == null ? other$verticalStyle != null : !((Object)((Object)this$verticalStyle)).equals((Object)other$verticalStyle)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        Color this$underlineColor = this.getUnderlineColor();
        Color other$underlineColor = other.getUnderlineColor();
        if (this$underlineColor == null ? other$underlineColor != null : !((Object)this$underlineColor).equals(other$underlineColor)) {
            return false;
        }
        Color this$deleteLineColor = this.getDeleteLineColor();
        Color other$deleteLineColor = other.getDeleteLineColor();
        if (this$deleteLineColor == null ? other$deleteLineColor != null : !((Object)this$deleteLineColor).equals(other$deleteLineColor)) {
            return false;
        }
        Color this$highlightColor = this.getHighlightColor();
        Color other$highlightColor = other.getHighlightColor();
        if (this$highlightColor == null ? other$highlightColor != null : !((Object)this$highlightColor).equals(other$highlightColor)) {
            return false;
        }
        String this$linkUrl = this.getLinkUrl();
        String other$linkUrl = other.getLinkUrl();
        if (this$linkUrl == null ? other$linkUrl != null : !this$linkUrl.equals(other$linkUrl)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        XEasypdfTextRenderingMode this$renderingMode = this.getRenderingMode();
        XEasypdfTextRenderingMode other$renderingMode = other.getRenderingMode();
        if (this$renderingMode == null ? other$renderingMode != null : !((Object)((Object)this$renderingMode)).equals((Object)other$renderingMode)) {
            return false;
        }
        XEasyPdfPagingCondition this$pagingCondition = this.getPagingCondition();
        XEasyPdfPagingCondition other$pagingCondition = other.getPagingCondition();
        return !(this$pagingCondition == null ? other$pagingCondition != null : !this$pagingCondition.equals(other$pagingCondition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTextParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $fontScaleRatio = this.getFontScaleRatio();
        result = result * 59 + ($fontScaleRatio == null ? 43 : ((Object)$fontScaleRatio).hashCode());
        Float $fontHeight = this.getFontHeight();
        result = result * 59 + ($fontHeight == null ? 43 : ((Object)$fontHeight).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        Float $characterSpacing = this.getCharacterSpacing();
        result = result * 59 + ($characterSpacing == null ? 43 : ((Object)$characterSpacing).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $maxWidth = this.getMaxWidth();
        result = result * 59 + ($maxWidth == null ? 43 : ((Object)$maxWidth).hashCode());
        Float $maxHeight = this.getMaxHeight();
        result = result * 59 + ($maxHeight == null ? 43 : ((Object)$maxHeight).hashCode());
        Integer $indent = this.getIndent();
        result = result * 59 + ($indent == null ? 43 : ((Object)$indent).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $underlineWidth = this.getUnderlineWidth();
        result = result * 59 + ($underlineWidth == null ? 43 : ((Object)$underlineWidth).hashCode());
        Float $deleteLineWidth = this.getDeleteLineWidth();
        result = result * 59 + ($deleteLineWidth == null ? 43 : ((Object)$deleteLineWidth).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        Boolean $useSelfStyle = this.getUseSelfStyle();
        result = result * 59 + ($useSelfStyle == null ? 43 : ((Object)$useSelfStyle).hashCode());
        Boolean $isNewLine = this.getIsNewLine();
        result = result * 59 + ($isNewLine == null ? 43 : ((Object)$isNewLine).hashCode());
        Boolean $checkPage = this.getCheckPage();
        result = result * 59 + ($checkPage == null ? 43 : ((Object)$checkPage).hashCode());
        Boolean $isTextAppend = this.getIsTextAppend();
        result = result * 59 + ($isTextAppend == null ? 43 : ((Object)$isTextAppend).hashCode());
        Boolean $isChildComponent = this.getIsChildComponent();
        result = result * 59 + ($isChildComponent == null ? 43 : ((Object)$isChildComponent).hashCode());
        Boolean $isUnderline = this.getIsUnderline();
        result = result * 59 + ($isUnderline == null ? 43 : ((Object)$isUnderline).hashCode());
        Boolean $isDeleteLine = this.getIsDeleteLine();
        result = result * 59 + ($isDeleteLine == null ? 43 : ((Object)$isDeleteLine).hashCode());
        Boolean $isHighlight = this.getIsHighlight();
        result = result * 59 + ($isHighlight == null ? 43 : ((Object)$isHighlight).hashCode());
        Boolean $isRotateLine = this.getIsRotateLine();
        result = result * 59 + ($isRotateLine == null ? 43 : ((Object)$isRotateLine).hashCode());
        Boolean $isNeedInitialize = this.getIsNeedInitialize();
        result = result * 59 + ($isNeedInitialize == null ? 43 : ((Object)$isNeedInitialize).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $splitTextList = this.getSplitTextList();
        result = result * 59 + ($splitTextList == null ? 43 : ((Object)$splitTextList).hashCode());
        List<String> $splitTemplateTextList = this.getSplitTemplateTextList();
        result = result * 59 + ($splitTemplateTextList == null ? 43 : ((Object)$splitTemplateTextList).hashCode());
        Map<String, String> $replaceCharacterMap = this.getReplaceCharacterMap();
        result = result * 59 + ($replaceCharacterMap == null ? 43 : ((Object)$replaceCharacterMap).hashCode());
        XEasyPdfPositionStyle $horizontalStyle = this.getHorizontalStyle();
        result = result * 59 + ($horizontalStyle == null ? 43 : ((Object)((Object)$horizontalStyle)).hashCode());
        XEasyPdfPositionStyle $verticalStyle = this.getVerticalStyle();
        result = result * 59 + ($verticalStyle == null ? 43 : ((Object)((Object)$verticalStyle)).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        Color $underlineColor = this.getUnderlineColor();
        result = result * 59 + ($underlineColor == null ? 43 : ((Object)$underlineColor).hashCode());
        Color $deleteLineColor = this.getDeleteLineColor();
        result = result * 59 + ($deleteLineColor == null ? 43 : ((Object)$deleteLineColor).hashCode());
        Color $highlightColor = this.getHighlightColor();
        result = result * 59 + ($highlightColor == null ? 43 : ((Object)$highlightColor).hashCode());
        String $linkUrl = this.getLinkUrl();
        result = result * 59 + ($linkUrl == null ? 43 : $linkUrl.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        XEasypdfTextRenderingMode $renderingMode = this.getRenderingMode();
        result = result * 59 + ($renderingMode == null ? 43 : ((Object)((Object)$renderingMode)).hashCode());
        XEasyPdfPagingCondition $pagingCondition = this.getPagingCondition();
        result = result * 59 + ($pagingCondition == null ? 43 : $pagingCondition.hashCode());
        return result;
    }
}

