/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.text;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.XEasyPdfPagingCondition;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextBase;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextScriptParam;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfTextScriptType;
import org.dromara.pdf.pdfbox.component.text.XEasypdfTextRenderingMode;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;
import org.dromara.pdf.pdfbox.util.XEasyPdfFontUtil;
import org.dromara.pdf.pdfbox.util.XEasyPdfTextUtil;

public class XEasyPdfTextScript
extends XEasyPdfTextBase {
    private static final long serialVersionUID = 8367990811132640481L;
    private XEasyPdfTextScriptParam param = new XEasyPdfTextScriptParam();

    XEasyPdfTextScript(XEasyPdfTextScriptParam param) {
        this.param = param;
    }

    public XEasyPdfTextScript(String text) {
        this.param.setText(text);
    }

    public XEasyPdfTextScript enableChildComponent() {
        this.param.setIsChildComponent(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript enableUnderline() {
        this.param.setIsUnderline(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript enableDeleteLine() {
        this.param.setIsDeleteLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript enableHighlight() {
        this.param.setIsHighlight(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript enableRotateLine() {
        this.param.setIsRotateLine(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfTextScript enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript enableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTextScript disableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.FALSE);
        return this;
    }

    public XEasyPdfTextScript setAutoIndent(int indent) {
        this.param.setIndent(Math.abs(indent));
        return this;
    }

    @Override
    void setBeginX(Float beginX) {
        this.param.setBeginX(beginX);
    }

    @Override
    void setBeginY(Float beginY) {
        this.param.setBeginY(beginY);
    }

    public XEasyPdfTextScript setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextScript setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextScript setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextScript setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextScript setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTextScript setLeading(float leading) {
        this.param.setLeading(Float.valueOf(Math.abs(leading)));
        return this;
    }

    public XEasyPdfTextScript setCharacterSpacing(float characterSpacing) {
        this.param.setCharacterSpacing(Float.valueOf(Math.abs(characterSpacing)));
        return this;
    }

    public XEasyPdfTextScript setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfTextScript setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfTextScript setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfTextScript setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfTextScript setHighlightColor(Color highlightColor) {
        if (highlightColor != null) {
            this.param.setHighlightColor(highlightColor);
        }
        return this;
    }

    public XEasyPdfTextScript setUnderlineColor(Color underlineColor) {
        if (underlineColor != null) {
            this.param.setUnderlineColor(underlineColor);
        }
        return this;
    }

    public XEasyPdfTextScript setUnderlineWidth(float underlineWidth) {
        this.param.setUnderlineWidth(Float.valueOf(Math.abs(underlineWidth)));
        return this;
    }

    public XEasyPdfTextScript setDeleteLineColor(Color deleteLineColor) {
        if (deleteLineColor != null) {
            this.param.setDeleteLineColor(deleteLineColor);
        }
        return this;
    }

    public XEasyPdfTextScript setDeleteLineWidth(float deleteLineWidth) {
        this.param.setDeleteLineWidth(Float.valueOf(Math.abs(deleteLineWidth)));
        return this;
    }

    public XEasyPdfTextScript setLink(String linkUrl) {
        this.param.setLinkUrl(linkUrl);
        return this;
    }

    public XEasyPdfTextScript setComment(String comment) {
        this.param.setComment(comment);
        return this;
    }

    public XEasyPdfTextScript setAlpha(float alpha) {
        if (alpha >= 0.0f && alpha <= 1.0f) {
            this.param.setAlpha(Float.valueOf(alpha));
        }
        return this;
    }

    public XEasyPdfTextScript setReplaceCharacters(String oldValue, String replacement) {
        if (oldValue != null && replacement != null) {
            this.param.getReplaceCharacterMap().put(oldValue, replacement);
        }
        return this;
    }

    public XEasyPdfTextScript setReplaceCharacters(Map<String, String> replaceMap) {
        if (replaceMap != null && !replaceMap.isEmpty()) {
            this.param.getReplaceCharacterMap().putAll(replaceMap);
        }
        return this;
    }

    public XEasyPdfTextScript setNewLine(boolean isNewLine) {
        this.param.setIsNewLine(isNewLine);
        return this;
    }

    public XEasyPdfTextScript setCheckPage(boolean isCheckPage) {
        this.param.setCheckPage(isCheckPage);
        return this;
    }

    @Override
    public XEasyPdfTextScript setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfTextScript setWidth(float width) {
        this.param.setMaxWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfTextScript setHeight(float height) {
        this.param.setMaxHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfTextScript setMaxHeight(Float maxHeight) {
        this.param.setMaxHeight(maxHeight);
        return this;
    }

    @Override
    public XEasyPdfTextScript setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfTextScript setRenderingMode(XEasypdfTextRenderingMode renderingMode) {
        if (renderingMode != null) {
            this.param.setRenderingMode(renderingMode);
        }
        return this;
    }

    @Override
    public XEasyPdfTextScript setPagingCondition(XEasyPdfPagingCondition pagingCondition) {
        this.param.setPagingCondition(pagingCondition);
        return this;
    }

    @Override
    public XEasyPdfTextScript setNeedInitialize(boolean needInitialize) {
        this.param.setIsNeedInitialize(needInitialize);
        return this;
    }

    public XEasyPdfTextScript setFontScaleRatio(float fontScaleRatio) {
        float ratio = Math.abs(fontScaleRatio);
        float max = 0.7f;
        float min = 0.1f;
        this.param.setFontScaleRatio(Float.valueOf(Math.min(max, Math.max(ratio, min))));
        return this;
    }

    public XEasyPdfTextScript setScriptType(XEasyPdfTextScriptType scriptType) {
        this.param.setScriptType(scriptType);
        return this;
    }

    @Override
    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getHeight(document, page);
    }

    @Override
    public float getWidth(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getWidth(document, page);
    }

    @Override
    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.param.getContentMode();
    }

    @Override
    float getBeginY() {
        return this.param.getBeginY().floatValue();
    }

    @Override
    public float getMarginTop() {
        return this.param.getMarginTop().floatValue();
    }

    @Override
    public float getMarginBottom() {
        return this.param.getMarginBottom().floatValue();
    }

    @Override
    public float getMarginLeft() {
        return this.param.getMarginLeft().floatValue();
    }

    @Override
    public float getMarginRight() {
        return this.param.getMarginRight().floatValue();
    }

    @Override
    public List<String> getSplitTextList() {
        return this.param.getSplitTextList();
    }

    @Override
    public float getFontSize() {
        return this.param.getFontSize().floatValue();
    }

    @Override
    public String getFontPath() {
        return this.param.getFontPath();
    }

    @Override
    public float getLeading() {
        return this.param.getLeading().floatValue();
    }

    @Override
    public float getCharacterSpacing() {
        return this.param.getCharacterSpacing().floatValue();
    }

    @Override
    float getAlpha() {
        return this.param.getAlpha().floatValue();
    }

    @Override
    Integer getIndent() {
        return this.param.getIndent();
    }

    @Override
    String getLinkUrl() {
        return this.param.getLinkUrl();
    }

    @Override
    String getComment() {
        return this.param.getComment();
    }

    @Override
    Color getFontColor() {
        return this.param.getFontColor();
    }

    @Override
    Color getHighlightColor() {
        return this.param.getHighlightColor();
    }

    @Override
    Color getUnderlineColor() {
        return this.param.getUnderlineColor();
    }

    @Override
    Color getDeleteLineColor() {
        return this.param.getDeleteLineColor();
    }

    @Override
    float getUnderlineWidth() {
        return this.param.getUnderlineWidth().floatValue();
    }

    @Override
    float getDeleteLineWidth() {
        return this.param.getDeleteLineWidth().floatValue();
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.param.getHorizontalStyle();
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.param.getVerticalStyle();
    }

    @Override
    XEasypdfTextRenderingMode getRenderingMode() {
        return this.param.getRenderingMode();
    }

    @Override
    XEasyPdfPagingCondition getPagingCondition() {
        return this.param.getPagingCondition();
    }

    @Override
    boolean isUseSelfStyle() {
        return this.param.getUseSelfStyle();
    }

    @Override
    public boolean isNeedInitialize() {
        return this.param.getIsNeedInitialize();
    }

    @Override
    boolean isResetContext() {
        return this.param.getIsResetContext();
    }

    @Override
    boolean isNewLine() {
        return this.param.getIsNewLine();
    }

    @Override
    boolean isTextAppend() {
        return this.param.getIsTextAppend();
    }

    @Override
    boolean isHighlight() {
        return this.param.getIsHighlight();
    }

    @Override
    boolean isUnderline() {
        return this.param.getIsUnderline();
    }

    @Override
    boolean isDeleteLine() {
        return this.param.getIsDeleteLine();
    }

    @Override
    boolean isCheckPage() {
        return this.param.getCheckPage();
    }

    @Override
    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getFontScaleRatio() == null) {
            this.param.setFontScaleRatio(Float.valueOf(0.5f));
        }
        if (this.param.getScriptType() == null) {
            this.param.setScriptType(XEasyPdfTextScriptType.SUPERSCRIPT);
        }
        if (this.param.getRenderingMode() == null) {
            this.param.setRenderingMode(XEasypdfTextRenderingMode.NORMAL);
        }
        this.param.setIsTextAppend(Boolean.TRUE);
        this.param.init(document, page);
    }

    @Override
    float initBeginX(XEasyPdfDocument document, XEasyPdfPage page, String text) {
        return this.param.initBeginX(document, page, text).floatValue();
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.init(document, page);
        this.doDraw(document, page);
    }

    @Override
    void addText(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        if (this.param.getScriptType() == XEasyPdfTextScriptType.SUPERSCRIPT) {
            this.addTextSuperscript(font, page, stream, text, beginX, beginY);
        }
        if (this.param.getScriptType() == XEasyPdfTextScriptType.SUBSCRIPT) {
            this.addTextSubscript(font, page, stream, text, beginX, beginY);
        }
    }

    private void addTextSuperscript(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        float textRise = XEasyPdfFontUtil.getFontHeight(font, this.param.getFontSize().floatValue()) * (1.0f - this.param.getFontScaleRatio().floatValue());
        stream.beginText();
        if (this.param.getRenderingMode().isItalic()) {
            stream.setTextMatrix(new Matrix(this.param.getFontScaleRatio().floatValue(), 0.0f, 0.2f, this.param.getFontScaleRatio().floatValue(), beginX, beginY + textRise));
        } else {
            stream.setTextMatrix(new Matrix(this.param.getFontScaleRatio().floatValue(), 0.0f, 0.0f, this.param.getFontScaleRatio().floatValue(), beginX, beginY + textRise));
        }
        stream.showText(text);
        stream.endText();
    }

    private void addTextSubscript(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        stream.beginText();
        if (this.param.getRenderingMode().isItalic()) {
            stream.setTextMatrix(new Matrix(this.param.getFontScaleRatio().floatValue(), 0.0f, 0.2f, this.param.getFontScaleRatio().floatValue(), beginX, beginY));
        } else {
            stream.setTextMatrix(new Matrix(this.param.getFontScaleRatio().floatValue(), 0.0f, 0.0f, this.param.getFontScaleRatio().floatValue(), beginX, beginY));
        }
        stream.showText(text);
        stream.endText();
    }

    @Override
    PDRectangle getRectangleForWrite(PDFont font, String text, float beginX, float beginY) {
        PDRectangle rectangle = new PDRectangle();
        rectangle.setLowerLeftX(beginX);
        rectangle.setLowerLeftY(beginY);
        rectangle.setUpperRightY(beginY + this.param.getFontHeight().floatValue());
        rectangle.setUpperRightX(beginX + XEasyPdfTextUtil.getTextRealWidth(text, font, this.param.getFontSize().floatValue() * this.param.getFontScaleRatio().floatValue(), this.getCharacterSpacing()));
        return rectangle;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTextScript)) {
            return false;
        }
        XEasyPdfTextScript other = (XEasyPdfTextScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XEasyPdfTextScriptParam this$param = this.param;
        XEasyPdfTextScriptParam other$param = other.param;
        return !(this$param == null ? other$param != null : !((Object)this$param).equals(other$param));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTextScript;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        XEasyPdfTextScriptParam $param = this.param;
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        return result;
    }
}

